/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.MockHiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastoreStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCachingHiveMetastore {
    private MockHiveMetastoreClient mockClient;
    private CachingHiveMetastore metastore;
    private ThriftHiveMetastoreStats stats;

    @BeforeMethod
    public void setUp() {
        this.mockClient = new MockHiveMetastoreClient();
        MockHiveCluster mockHiveCluster = new MockHiveCluster(this.mockClient);
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s")));
        ThriftHiveMetastore thriftHiveMetastore = new ThriftHiveMetastore((HiveCluster)mockHiveCluster);
        this.metastore = new CachingHiveMetastore((ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)thriftHiveMetastore), (ExecutorService)executor, new Duration(5.0, TimeUnit.MINUTES), new Duration(1.0, TimeUnit.MINUTES), 1000L);
        this.stats = thriftHiveMetastore.getStats();
    }

    @Test
    public void testGetAllDatabases() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testGetAllTable() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)((Collection)this.metastore.getAllTables("testdb").get()), (Collection)ImmutableList.of((Object)"testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)((Collection)this.metastore.getAllTables("testdb").get()), (Collection)ImmutableList.of((Object)"testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)((Collection)this.metastore.getAllTables("testdb").get()), (Collection)ImmutableList.of((Object)"testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    public void testInvalidDbGetAllTAbles() {
        Assert.assertFalse((boolean)this.metastore.getAllTables("baddb").isPresent());
    }

    @Test
    public void testGetTable() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    public void testInvalidDbGetTable() {
        Assert.assertFalse((boolean)this.metastore.getTable("baddb", "testtbl").isPresent());
        Assert.assertEquals((long)this.stats.getGetTable().getThriftExceptions().getTotalCount(), (long)0L);
        Assert.assertEquals((long)this.stats.getGetTable().getTotalFailures().getTotalCount(), (long)0L);
    }

    @Test
    public void testGetPartitionNames() {
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNames("testdb", "testtbl").get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNames("testdb", "testtbl").get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNames("testdb", "testtbl").get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testInvalidGetPartitionNames() {
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNames("baddb", "testtbl").get()), (Collection)ImmutableList.of());
    }

    @Test
    public void testGetPartitionNamesByParts() {
        ImmutableList parts = ImmutableList.of();
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByParts("testdb", "testtbl", (List)parts).get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByParts("testdb", "testtbl", (List)parts).get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByParts("testdb", "testtbl", (List)parts).get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    public void testInvalidGetPartitionNamesByParts() {
        ImmutableList parts = ImmutableList.of();
        Assert.assertFalse((boolean)this.metastore.getPartitionNamesByParts("baddb", "testtbl", (List)parts).isPresent());
    }

    @Test
    public void testGetPartitionsByNames() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        this.metastore.getTable("testdb", "testtbl");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames("testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames("testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames("testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames("testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition2")).size(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames("testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        this.metastore.flushCache();
        Assert.assertEquals((int)this.metastore.getPartitionsByNames("testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
    }

    public void testInvalidGetPartitionsByNames() {
        Map partitionsByNames = this.metastore.getPartitionsByNames("baddb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1"));
        Assert.assertEquals((int)partitionsByNames.size(), (int)1);
        Optional onlyElement = (Optional)Iterables.getOnlyElement(partitionsByNames.values());
        Assert.assertFalse((boolean)onlyElement.isPresent());
    }

    @Test
    public void testNoCacheExceptions() {
        this.mockClient.setThrowException(true);
        try {
            this.metastore.getAllDatabases();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        try {
            this.metastore.getAllDatabases();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    private static class MockHiveCluster
    implements HiveCluster {
        private final HiveMetastoreClient client;

        private MockHiveCluster(HiveMetastoreClient client) {
            this.client = client;
        }

        public HiveMetastoreClient createMetastoreClient() {
            return this.client;
        }
    }
}

