/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMetastoreUtil {
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("col1", "bigint", "comment1"), (Object)new FieldSchema("col2", "binary", null), (Object)new FieldSchema("col3", "string", null)), "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 1)), (Map)ImmutableMap.of());
    private static final org.apache.hadoop.hive.metastore.api.Table TEST_TABLE = new org.apache.hadoop.hive.metastore.api.Table("table_name", "db_name", "owner_name", 0, 0, 0, TEST_STORAGE_DESCRIPTOR, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
    private static final org.apache.hadoop.hive.metastore.api.Partition TEST_PARTITION;
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS;
    private static final org.apache.hadoop.hive.metastore.api.Table TEST_TABLE_WITH_UNSUPPORTED_FIELDS;
    private static final org.apache.hadoop.hive.metastore.api.Partition TEST_PARTITION_WITH_UNSUPPORTED_FIELDS;

    @Test
    public void testTableRoundTrip() {
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE);
        PrincipalPrivileges privileges = new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of());
        org.apache.hadoop.hive.metastore.api.Table metastoreApiTable = ThriftMetastoreUtil.toMetastoreApiTable((Table)table, (PrincipalPrivileges)privileges);
        Assert.assertEquals((Object)metastoreApiTable, (Object)TEST_TABLE);
    }

    @Test
    public void testPartitionRoundTrip() {
        Partition partition = ThriftMetastoreUtil.fromMetastoreApiPartition((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION);
        org.apache.hadoop.hive.metastore.api.Partition metastoreApiPartition = ThriftMetastoreUtil.toMetastoreApiPartition((Partition)partition);
        Assert.assertEquals((Object)metastoreApiPartition, (Object)TEST_PARTITION);
    }

    @Test
    public void testHiveSchemaTable() {
        Properties expected = MetaStoreUtils.getTableMetadata((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS);
        Properties actual = MetastoreUtil.getHiveSchema((Table)ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS));
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testHiveSchemaPartition() {
        Properties expected = MetaStoreUtils.getPartitionMetadata((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS, (org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS);
        Properties actual = MetastoreUtil.getHiveSchema((Partition)ThriftMetastoreUtil.fromMetastoreApiPartition((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS), (Table)ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS));
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Writing to skewed table/partition is not supported")
    public void testTableRoundTripUnsupported() {
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS);
        ThriftMetastoreUtil.toMetastoreApiTable((Table)table, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Writing to skewed table/partition is not supported")
    public void testPartitionRoundTripUnsupported() {
        Partition partition = ThriftMetastoreUtil.fromMetastoreApiPartition((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS);
        ThriftMetastoreUtil.toMetastoreApiPartition((Partition)partition);
    }

    static {
        TEST_TABLE.setPrivileges(new PrincipalPrivilegeSet((Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        TEST_PARTITION = new org.apache.hadoop.hive.metastore.api.Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 0, 0, TEST_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("col1", "bigint", "comment1"), (Object)new FieldSchema("col2", "binary", null), (Object)new FieldSchema("col3", "string", null)), "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 0), (Object)new Order("col3", 1)), (Map)ImmutableMap.of((Object)"sk1", (Object)"sv1"));
        TEST_TABLE_WITH_UNSUPPORTED_FIELDS = new org.apache.hadoop.hive.metastore.api.Table("table_name", "db_name", "owner_name", 1234567890, 1234567891, 34, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
        TEST_PARTITION_WITH_UNSUPPORTED_FIELDS = new org.apache.hadoop.hive.metastore.api.Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 1234567892, 1234567893, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS.setSkewedInfo(new SkewedInfo((List)ImmutableList.of((Object)"col1"), (List)ImmutableList.of((Object)ImmutableList.of((Object)"val1")), (Map)ImmutableMap.of((Object)ImmutableList.of((Object)"val1"), (Object)"loc1")));
    }
}

