/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.glue.GlueExpressionUtil;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGlueExpressionUtil {
    private static final List<Column> PARTITION_KEYS = ImmutableList.of((Object)TestGlueExpressionUtil.getColumn("name", "string"), (Object)TestGlueExpressionUtil.getColumn("birthday", "date"), (Object)TestGlueExpressionUtil.getColumn("age", "int"));

    private static Column getColumn(String name, String type) {
        return new Column(name, HiveType.valueOf((String)type), Optional.empty());
    }

    @Test
    public void testBuildExpression() {
        ImmutableList partitionValues = ImmutableList.of((Object)"foo", (Object)"2018-01-02", (Object)"99");
        String expression = GlueExpressionUtil.buildGlueExpression(PARTITION_KEYS, (List)partitionValues);
        Assert.assertEquals((String)expression, (String)"(name='foo') AND (birthday='2018-01-02') AND (age=99)");
        partitionValues = ImmutableList.of((Object)"foo", (Object)"2018-01-02", (Object)"");
        expression = GlueExpressionUtil.buildGlueExpression(PARTITION_KEYS, (List)partitionValues);
        Assert.assertEquals((String)expression, (String)"(name='foo') AND (birthday='2018-01-02')");
    }

    @Test
    public void testBuildExpressionFromPartialSpecification() {
        ImmutableList partitionValues = ImmutableList.of((Object)"", (Object)"2018-01-02", (Object)"");
        String expression = GlueExpressionUtil.buildGlueExpression(PARTITION_KEYS, (List)partitionValues);
        Assert.assertEquals((String)expression, (String)"(birthday='2018-01-02')");
        partitionValues = ImmutableList.of((Object)"foo", (Object)"", (Object)"99");
        expression = GlueExpressionUtil.buildGlueExpression(PARTITION_KEYS, (List)partitionValues);
        Assert.assertEquals((String)expression, (String)"(name='foo') AND (age=99)");
    }

    @Test
    public void testBuildExpressionNullOrEmptyValues() {
        Assert.assertNull((Object)GlueExpressionUtil.buildGlueExpression(PARTITION_KEYS, (List)ImmutableList.of()));
        Assert.assertNull((Object)GlueExpressionUtil.buildGlueExpression(PARTITION_KEYS, null));
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testBuildExpressionInvalidPartitionValueListSize() {
        ImmutableList partitionValues = ImmutableList.of((Object)"foo", (Object)"2017-01-02", (Object)"99", (Object)"extra");
        GlueExpressionUtil.buildGlueExpression(PARTITION_KEYS, (List)partitionValues);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testBuildExpressionNullPartitionKeys() {
        ImmutableList partitionValues = ImmutableList.of((Object)"foo", (Object)"2018-01-02", (Object)"99");
        GlueExpressionUtil.buildGlueExpression(null, (List)partitionValues);
    }
}

