/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.util.CollectionUtils;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrincipalType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.glue.TestingMetastoreObjects;
import com.facebook.presto.hive.metastore.glue.converter.GlueToPrestoConverter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestGlueToPrestoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";
    private com.amazonaws.services.glue.model.Database testDb;
    private com.amazonaws.services.glue.model.Table testTbl;
    private com.amazonaws.services.glue.model.Partition testPartition;

    @BeforeMethod
    public void setup() {
        this.testDb = TestingMetastoreObjects.getGlueTestDatabase();
        this.testTbl = TestingMetastoreObjects.getGlueTestTable(this.testDb.getName());
        this.testPartition = TestingMetastoreObjects.getGlueTestPartition(this.testDb.getName(), this.testTbl.getName(), (List<String>)ImmutableList.of((Object)"val1"));
    }

    @Test
    public void testConvertDatabase() {
        Database prestoDb = GlueToPrestoConverter.convertDatabase((com.amazonaws.services.glue.model.Database)this.testDb);
        Assert.assertEquals((String)prestoDb.getDatabaseName(), (String)this.testDb.getName());
        Assert.assertEquals((String)((String)prestoDb.getLocation().get()), (String)this.testDb.getLocationUri());
        Assert.assertEquals((String)((String)prestoDb.getComment().get()), (String)this.testDb.getDescription());
        Assert.assertEquals((Map)prestoDb.getParameters(), (Map)this.testDb.getParameters());
        Assert.assertEquals((String)prestoDb.getOwnerName(), (String)PUBLIC_OWNER);
        Assert.assertEquals((Object)prestoDb.getOwnerType(), (Object)PrincipalType.ROLE);
    }

    @Test
    public void testConvertTable() {
        Table prestoTbl = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTbl, (String)this.testDb.getName());
        Assert.assertEquals((String)prestoTbl.getTableName(), (String)this.testTbl.getName());
        Assert.assertEquals((String)prestoTbl.getDatabaseName(), (String)this.testDb.getName());
        Assert.assertEquals((String)prestoTbl.getTableType(), (String)this.testTbl.getTableType());
        Assert.assertEquals((String)prestoTbl.getOwner(), (String)this.testTbl.getOwner());
        Assert.assertEquals((Map)prestoTbl.getParameters(), (Map)this.testTbl.getParameters());
        TestGlueToPrestoConverter.assertColumnList(prestoTbl.getDataColumns(), this.testTbl.getStorageDescriptor().getColumns());
        TestGlueToPrestoConverter.assertColumnList(prestoTbl.getPartitionColumns(), this.testTbl.getPartitionKeys());
        TestGlueToPrestoConverter.assertStorage(prestoTbl.getStorage(), this.testTbl.getStorageDescriptor());
        Assert.assertEquals((String)((String)prestoTbl.getViewOriginalText().get()), (String)this.testTbl.getViewOriginalText());
        Assert.assertEquals((String)((String)prestoTbl.getViewExpandedText().get()), (String)this.testTbl.getViewExpandedText());
    }

    @Test
    public void testConvertTableNullPartitions() {
        this.testTbl.setPartitionKeys(null);
        Table prestoTbl = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTbl, (String)this.testDb.getName());
        Assert.assertTrue((boolean)prestoTbl.getPartitionColumns().isEmpty());
    }

    @Test
    public void testConvertTableUppercaseColumnType() {
        com.amazonaws.services.glue.model.Column uppercaseCol = TestingMetastoreObjects.getGlueTestColumn().withType("String");
        this.testTbl.getStorageDescriptor().setColumns((Collection)ImmutableList.of((Object)uppercaseCol));
        GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTbl, (String)this.testDb.getName());
    }

    @Test
    public void testConvertPartition() {
        Partition prestoPartition = GlueToPrestoConverter.convertPartition((com.amazonaws.services.glue.model.Partition)this.testPartition);
        Assert.assertEquals((String)prestoPartition.getDatabaseName(), (String)this.testPartition.getDatabaseName());
        Assert.assertEquals((String)prestoPartition.getTableName(), (String)this.testPartition.getTableName());
        TestGlueToPrestoConverter.assertColumnList(prestoPartition.getColumns(), this.testPartition.getStorageDescriptor().getColumns());
        Assert.assertEquals((Collection)prestoPartition.getValues(), (Collection)this.testPartition.getValues());
        TestGlueToPrestoConverter.assertStorage(prestoPartition.getStorage(), this.testPartition.getStorageDescriptor());
        Assert.assertEquals((Map)prestoPartition.getParameters(), (Map)this.testPartition.getParameters());
    }

    private static void assertColumnList(List<Column> actual, List<com.amazonaws.services.glue.model.Column> expected) {
        if (expected == null) {
            Assert.assertNull(actual);
        }
        Assert.assertEquals((int)actual.size(), (int)expected.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestGlueToPrestoConverter.assertColumn(actual.get(i), expected.get(i));
        }
    }

    private static void assertColumn(Column actual, com.amazonaws.services.glue.model.Column expected) {
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((String)actual.getType().getHiveTypeName().toString(), (String)expected.getType());
        Assert.assertEquals((String)((String)actual.getComment().get()), (String)expected.getComment());
    }

    private static void assertStorage(Storage actual, StorageDescriptor expected) {
        Assert.assertEquals((String)actual.getLocation(), (String)expected.getLocation());
        Assert.assertEquals((String)actual.getStorageFormat().getSerDe(), (String)expected.getSerdeInfo().getSerializationLibrary());
        Assert.assertEquals((String)actual.getStorageFormat().getInputFormat(), (String)expected.getInputFormat());
        Assert.assertEquals((String)actual.getStorageFormat().getOutputFormat(), (String)expected.getOutputFormat());
        if (!CollectionUtils.isNullOrEmpty((Collection)expected.getBucketColumns())) {
            HiveBucketProperty bucketProperty = (HiveBucketProperty)actual.getBucketProperty().get();
            Assert.assertEquals((Collection)bucketProperty.getBucketedBy(), (Collection)expected.getBucketColumns());
            Assert.assertEquals((int)bucketProperty.getBucketCount(), (int)expected.getNumberOfBuckets());
        }
    }
}

