/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;

public class MockHiveMetastoreClient
implements HiveMetastoreClient {
    public static final String TEST_DATABASE = "testdb";
    public static final String BAD_DATABASE = "baddb";
    public static final String TEST_TABLE = "testtbl";
    public static final String TEST_PARTITION1 = "key=testpartition1";
    public static final String TEST_PARTITION2 = "key=testpartition2";
    public static final List<String> TEST_PARTITION_VALUES1 = ImmutableList.of((Object)"testpartition1");
    public static final List<String> TEST_PARTITION_VALUES2 = ImmutableList.of((Object)"testpartition2");
    private static final StorageDescriptor DEFAULT_STORAGE_DESCRIPTOR = new StorageDescriptor((List)ImmutableList.of(), "", null, null, false, 0, new SerDeInfo("testtbl", null, (Map)ImmutableMap.of()), null, null, (Map)ImmutableMap.of());
    private final AtomicInteger accessCount = new AtomicInteger();
    private boolean throwException;

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public int getAccessCount() {
        return this.accessCount.get();
    }

    public List<String> getAllDatabases() {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new IllegalStateException();
        }
        return ImmutableList.of((Object)TEST_DATABASE);
    }

    public List<String> getAllTables(String dbName) {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)TEST_TABLE);
    }

    public Database getDatabase(String name) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!name.equals(TEST_DATABASE)) {
            throw new NoSuchObjectException();
        }
        return new Database(TEST_DATABASE, null, null, null);
    }

    public Table getTable(String dbName, String tableName) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE) || !tableName.equals(TEST_TABLE)) {
            throw new NoSuchObjectException();
        }
        return new Table(TEST_TABLE, TEST_DATABASE, "", 0, 0, 0, DEFAULT_STORAGE_DESCRIPTOR, (List)ImmutableList.of((Object)new FieldSchema("key", "string", null)), null, "", "", TableType.MANAGED_TABLE.name());
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String databaseName, String tableName, List<String> columnNames) {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String databaseName, String tableName, List<String> partitionNames, List<String> columnNames) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTableNamesByFilter(String databaseName, String filter) {
        throw new UnsupportedOperationException();
    }

    public List<String> getPartitionNames(String dbName, String tableName) {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE) || !tableName.equals(TEST_TABLE)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)TEST_PARTITION1, (Object)TEST_PARTITION2);
    }

    public List<String> getPartitionNamesFiltered(String dbName, String tableName, List<String> partValues) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE) || !tableName.equals(TEST_TABLE)) {
            throw new NoSuchObjectException();
        }
        return ImmutableList.of((Object)TEST_PARTITION1, (Object)TEST_PARTITION2);
    }

    public Partition getPartition(String dbName, String tableName, List<String> partitionValues) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!(dbName.equals(TEST_DATABASE) && tableName.equals(TEST_TABLE) && ImmutableSet.of(TEST_PARTITION_VALUES1, TEST_PARTITION_VALUES2).contains(partitionValues))) {
            throw new NoSuchObjectException();
        }
        return new Partition(null, TEST_DATABASE, TEST_TABLE, 0, 0, DEFAULT_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of());
    }

    public List<Partition> getPartitionsByNames(String dbName, String tableName, List<String> names) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!(dbName.equals(TEST_DATABASE) && tableName.equals(TEST_TABLE) && ImmutableSet.of((Object)TEST_PARTITION1, (Object)TEST_PARTITION2).containsAll(names))) {
            throw new NoSuchObjectException();
        }
        return Lists.transform(names, name -> {
            try {
                return new Partition((List)ImmutableList.copyOf((Collection)Warehouse.getPartValuesFromPartName((String)name)), TEST_DATABASE, TEST_TABLE, 0, 0, DEFAULT_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of());
            }
            catch (MetaException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void createDatabase(Database database) {
        throw new UnsupportedOperationException();
    }

    public void dropDatabase(String databaseName, boolean deleteData, boolean cascade) {
        throw new UnsupportedOperationException();
    }

    public void alterDatabase(String databaseName, Database database) {
        throw new UnsupportedOperationException();
    }

    public void createTable(Table table) {
        throw new UnsupportedOperationException();
    }

    public void dropTable(String databaseName, String name, boolean deleteData) {
        throw new UnsupportedOperationException();
    }

    public void alterTable(String databaseName, String tableName, Table newTable) {
        throw new UnsupportedOperationException();
    }

    public int addPartitions(List<Partition> newPartitions) {
        throw new UnsupportedOperationException();
    }

    public boolean dropPartition(String databaseName, String tableName, List<String> partitionValues, boolean deleteData) {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(String databaseName, String tableName, Partition partition) {
        throw new UnsupportedOperationException();
    }

    public List<Role> listRoles(String principalName, PrincipalType principalType) {
        throw new UnsupportedOperationException();
    }

    public PrincipalPrivilegeSet getPrivilegeSet(HiveObjectRef hiveObject, String userName, List<String> groupNames) {
        throw new UnsupportedOperationException();
    }

    public List<HiveObjectPrivilege> listPrivileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObjectRef) {
        throw new UnsupportedOperationException();
    }

    public List<String> getRoleNames() {
        throw new UnsupportedOperationException();
    }

    public boolean grantPrivileges(PrivilegeBag privilegeBag) {
        throw new UnsupportedOperationException();
    }

    public boolean revokePrivileges(PrivilegeBag privilegeBag) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public void setUGI(String userName) {
    }
}

