/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import com.facebook.presto.hive.authentication.NoHiveMetastoreAuthentication;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClientFactory;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.thrift.transport.TTransportException;

public class MockHiveMetastoreClientFactory
extends HiveMetastoreClientFactory {
    private final List<HiveMetastoreClient> clients;

    public MockHiveMetastoreClientFactory(Optional<HostAndPort> socksProxy, Duration timeout, List<HiveMetastoreClient> clients) {
        super(Optional.empty(), socksProxy, timeout, (HiveMetastoreAuthentication)new NoHiveMetastoreAuthentication());
        this.clients = new ArrayList<HiveMetastoreClient>((Collection)Objects.requireNonNull(clients, "clients is null"));
    }

    public HiveMetastoreClient create(HostAndPort address) throws TTransportException {
        Preconditions.checkState((!this.clients.isEmpty() ? 1 : 0) != 0, (Object)"mock not given enough clients");
        HiveMetastoreClient client = this.clients.remove(0);
        if (client == null) {
            throw new TTransportException(3);
        }
        return client;
    }
}

