/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClientFactory;
import com.facebook.presto.hive.metastore.thrift.MockHiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.MockHiveMetastoreClientFactory;
import com.facebook.presto.hive.metastore.thrift.StaticHiveCluster;
import com.facebook.presto.hive.metastore.thrift.StaticMetastoreConfig;
import com.facebook.presto.spi.PrestoException;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStaticHiveCluster {
    private static final HiveMetastoreClient DEFAULT_CLIENT = TestStaticHiveCluster.createFakeMetastoreClient();
    private static final HiveMetastoreClient FALLBACK_CLIENT = TestStaticHiveCluster.createFakeMetastoreClient();
    private static final StaticMetastoreConfig CONFIG_WITH_FALLBACK = new StaticMetastoreConfig().setMetastoreUris("thrift://default:8080,thrift://fallback:8090,thrift://fallback2:8090");
    private static final StaticMetastoreConfig CONFIG_WITHOUT_FALLBACK = new StaticMetastoreConfig().setMetastoreUris("thrift://default:8080");
    private static final StaticMetastoreConfig CONFIG_WITH_FALLBACK_WITH_USER = new StaticMetastoreConfig().setMetastoreUris("thrift://default:8080,thrift://fallback:8090,thrift://fallback2:8090").setMetastoreUsername("presto");
    private static final StaticMetastoreConfig CONFIG_WITHOUT_FALLBACK_WITH_USER = new StaticMetastoreConfig().setMetastoreUris("thrift://default:8080").setMetastoreUsername("presto");

    @Test
    public void testDefaultHiveMetastore() {
        HiveCluster cluster = TestStaticHiveCluster.createHiveCluster(CONFIG_WITH_FALLBACK, Collections.singletonList(DEFAULT_CLIENT));
        Assert.assertEquals((Object)cluster.createMetastoreClient(), (Object)DEFAULT_CLIENT);
    }

    @Test
    public void testFallbackHiveMetastore() {
        HiveCluster cluster = TestStaticHiveCluster.createHiveCluster(CONFIG_WITH_FALLBACK, Arrays.asList(null, null, FALLBACK_CLIENT));
        Assert.assertEquals((Object)cluster.createMetastoreClient(), (Object)FALLBACK_CLIENT);
    }

    @Test
    public void testFallbackHiveMetastoreFails() {
        HiveCluster cluster = TestStaticHiveCluster.createHiveCluster(CONFIG_WITH_FALLBACK, Arrays.asList(null, null, null));
        TestStaticHiveCluster.assertCreateClientFails(cluster, "Failed connecting to Hive metastore: [default:8080, fallback:8090, fallback2:8090]");
    }

    @Test
    public void testMetastoreFailedWithoutFallback() {
        HiveCluster cluster = TestStaticHiveCluster.createHiveCluster(CONFIG_WITHOUT_FALLBACK, Collections.singletonList(null));
        TestStaticHiveCluster.assertCreateClientFails(cluster, "Failed connecting to Hive metastore: [default:8080]");
    }

    @Test
    public void testFallbackHiveMetastoreWithHiveUser() {
        HiveCluster cluster = TestStaticHiveCluster.createHiveCluster(CONFIG_WITH_FALLBACK_WITH_USER, Arrays.asList(null, null, FALLBACK_CLIENT));
        Assert.assertEquals((Object)cluster.createMetastoreClient(), (Object)FALLBACK_CLIENT);
    }

    @Test
    public void testMetastoreFailedWithoutFallbackWithHiveUser() {
        HiveCluster cluster = TestStaticHiveCluster.createHiveCluster(CONFIG_WITHOUT_FALLBACK_WITH_USER, Collections.singletonList(null));
        TestStaticHiveCluster.assertCreateClientFails(cluster, "Failed connecting to Hive metastore: [default:8080]");
    }

    private static void assertCreateClientFails(HiveCluster cluster, String message) {
        try {
            cluster.createMetastoreClient();
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assertions.assertContains((String)e.getMessage(), (String)message);
        }
    }

    private static HiveCluster createHiveCluster(StaticMetastoreConfig config, List<HiveMetastoreClient> clients) {
        return new StaticHiveCluster(config, (HiveMetastoreClientFactory)new MockHiveMetastoreClientFactory(Optional.empty(), new Duration(1.0, TimeUnit.SECONDS), clients));
    }

    private static HiveMetastoreClient createFakeMetastoreClient() {
        return new MockHiveMetastoreClient();
    }
}

