/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftMetastoreUtil {
    @Test
    public void testLongStatsToColumnStatistics() {
        LongColumnStatsData longColumnStatsData = new LongColumnStatsData();
        longColumnStatsData.setLowValue(0L);
        longColumnStatsData.setHighValue(100L);
        longColumnStatsData.setNumNulls(0L);
        longColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "bigint", ColumnStatisticsData.longStats((LongColumnStatsData)longColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assert.assertEquals((Object)actual.getLowValue(), Optional.of(0L));
        Assert.assertEquals((Object)actual.getHighValue(), Optional.of(100L));
        Assert.assertEquals((Object)actual.getMaxColumnLength(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getAverageColumnLength(), (Object)OptionalDouble.empty());
        Assert.assertEquals((Object)actual.getTrueCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getFalseCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(0L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(20L));
    }

    @Test
    public void testEmptyLongStatsToColumnStatistics() {
        LongColumnStatsData emptyLongColumnStatsData = new LongColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "bigint", ColumnStatisticsData.longStats((LongColumnStatsData)emptyLongColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        TestThriftMetastoreUtil.assertEmptyColumnStats(actual);
    }

    @Test
    public void testDoubleStatsToColumnStatistics() {
        DoubleColumnStatsData doubleColumnStatsData = new DoubleColumnStatsData();
        doubleColumnStatsData.setLowValue(0.0);
        doubleColumnStatsData.setHighValue(100.0);
        doubleColumnStatsData.setNumNulls(0L);
        doubleColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)doubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assert.assertEquals((Object)actual.getLowValue(), Optional.of(0.0));
        Assert.assertEquals((Object)actual.getHighValue(), Optional.of(100.0));
        Assert.assertEquals((Object)actual.getMaxColumnLength(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getAverageColumnLength(), (Object)OptionalDouble.empty());
        Assert.assertEquals((Object)actual.getTrueCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getFalseCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(0L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(20L));
    }

    @Test
    public void testEmptyDoubleStatsToColumnStatistics() {
        DoubleColumnStatsData emptyDoubleColumnStatsData = new DoubleColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "double", ColumnStatisticsData.doubleStats((DoubleColumnStatsData)emptyDoubleColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        TestThriftMetastoreUtil.assertEmptyColumnStats(actual);
    }

    @Test
    public void testDecimalStatsToColumnStatistics() {
        DecimalColumnStatsData decimalColumnStatsData = new DecimalColumnStatsData();
        BigDecimal low = new BigDecimal("0");
        decimalColumnStatsData.setLowValue(new Decimal(ByteBuffer.wrap(low.unscaledValue().toByteArray()), (short)low.scale()));
        BigDecimal high = new BigDecimal("100");
        decimalColumnStatsData.setHighValue(new Decimal(ByteBuffer.wrap(high.unscaledValue().toByteArray()), (short)high.scale()));
        decimalColumnStatsData.setNumNulls(0L);
        decimalColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "decimal", ColumnStatisticsData.decimalStats((DecimalColumnStatsData)decimalColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assert.assertEquals((Object)actual.getLowValue(), Optional.of(low));
        Assert.assertEquals((Object)actual.getHighValue(), Optional.of(high));
        Assert.assertEquals((Object)actual.getMaxColumnLength(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getAverageColumnLength(), (Object)OptionalDouble.empty());
        Assert.assertEquals((Object)actual.getTrueCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getFalseCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(0L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(20L));
    }

    @Test
    public void testEmptyDecimalStatsToColumnStatistics() {
        DecimalColumnStatsData emptyDecimalColumnStatsData = new DecimalColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "decimal", ColumnStatisticsData.decimalStats((DecimalColumnStatsData)emptyDecimalColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        TestThriftMetastoreUtil.assertEmptyColumnStats(actual);
    }

    @Test
    public void testBooleanStatsToColumnStatistics() {
        BooleanColumnStatsData booleanColumnStatsData = new BooleanColumnStatsData();
        booleanColumnStatsData.setNumTrues(100L);
        booleanColumnStatsData.setNumFalses(10L);
        booleanColumnStatsData.setNumNulls(0L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)booleanColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assert.assertEquals((Object)actual.getLowValue(), Optional.empty());
        Assert.assertEquals((Object)actual.getHighValue(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxColumnLength(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getAverageColumnLength(), (Object)OptionalDouble.empty());
        Assert.assertEquals((Object)actual.getTrueCount(), (Object)OptionalLong.of(100L));
        Assert.assertEquals((Object)actual.getFalseCount(), (Object)OptionalLong.of(10L));
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(0L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testEmptyBooleanStatsToColumnStatistics() {
        BooleanColumnStatsData emptyBooleanColumnStatsData = new BooleanColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "boolean", ColumnStatisticsData.booleanStats((BooleanColumnStatsData)emptyBooleanColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        TestThriftMetastoreUtil.assertEmptyColumnStats(actual);
    }

    @Test
    public void testDateStatsToColumnStatistics() {
        DateColumnStatsData dateColumnStatsData = new DateColumnStatsData();
        dateColumnStatsData.setLowValue(new Date(1000L));
        dateColumnStatsData.setHighValue(new Date(2000L));
        dateColumnStatsData.setNumNulls(0L);
        dateColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "date", ColumnStatisticsData.dateStats((DateColumnStatsData)dateColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assert.assertEquals((Object)actual.getLowValue(), Optional.of(LocalDate.ofEpochDay(1000L)));
        Assert.assertEquals((Object)actual.getHighValue(), Optional.of(LocalDate.ofEpochDay(2000L)));
        Assert.assertEquals((Object)actual.getMaxColumnLength(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getAverageColumnLength(), (Object)OptionalDouble.empty());
        Assert.assertEquals((Object)actual.getTrueCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getFalseCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(0L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(20L));
    }

    @Test
    public void testEmptyDateStatsToColumnStatistics() {
        DateColumnStatsData emptyDateColumnStatsData = new DateColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "date", ColumnStatisticsData.dateStats((DateColumnStatsData)emptyDateColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        TestThriftMetastoreUtil.assertEmptyColumnStats(actual);
    }

    @Test
    public void testStringStatsToColumnStatistics() {
        StringColumnStatsData stringColumnStatsData = new StringColumnStatsData();
        stringColumnStatsData.setMaxColLen(100L);
        stringColumnStatsData.setAvgColLen(40.0);
        stringColumnStatsData.setNumNulls(0L);
        stringColumnStatsData.setNumDVs(20L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "string", ColumnStatisticsData.stringStats((StringColumnStatsData)stringColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assert.assertEquals((Object)actual.getLowValue(), Optional.empty());
        Assert.assertEquals((Object)actual.getHighValue(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxColumnLength(), (Object)OptionalLong.of(100L));
        Assert.assertEquals((Object)actual.getAverageColumnLength(), (Object)OptionalDouble.of(40.0));
        Assert.assertEquals((Object)actual.getTrueCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getFalseCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(0L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.of(20L));
    }

    @Test
    public void testEmptyStringColumnStatsData() {
        StringColumnStatsData emptyStringColumnStatsData = new StringColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "string", ColumnStatisticsData.stringStats((StringColumnStatsData)emptyStringColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        TestThriftMetastoreUtil.assertEmptyColumnStats(actual);
    }

    @Test
    public void testBinaryStatsToColumnStatistics() {
        BinaryColumnStatsData binaryColumnStatsData = new BinaryColumnStatsData();
        binaryColumnStatsData.setMaxColLen(100L);
        binaryColumnStatsData.setAvgColLen(40.0);
        binaryColumnStatsData.setNumNulls(0L);
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "binary", ColumnStatisticsData.binaryStats((BinaryColumnStatsData)binaryColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        Assert.assertEquals((Object)actual.getLowValue(), Optional.empty());
        Assert.assertEquals((Object)actual.getHighValue(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxColumnLength(), (Object)OptionalLong.of(100L));
        Assert.assertEquals((Object)actual.getAverageColumnLength(), (Object)OptionalDouble.of(40.0));
        Assert.assertEquals((Object)actual.getTrueCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getFalseCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.of(0L));
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }

    @Test
    public void testEmptyBinaryStatsToColumnStatistics() {
        BinaryColumnStatsData emptyBinaryColumnStatsData = new BinaryColumnStatsData();
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj("my_col", "binary", ColumnStatisticsData.binaryStats((BinaryColumnStatsData)emptyBinaryColumnStatsData));
        HiveColumnStatistics actual = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics((ColumnStatisticsObj)columnStatisticsObj);
        TestThriftMetastoreUtil.assertEmptyColumnStats(actual);
    }

    private static void assertEmptyColumnStats(HiveColumnStatistics actual) {
        Assert.assertEquals((Object)actual.getLowValue(), Optional.empty());
        Assert.assertEquals((Object)actual.getHighValue(), Optional.empty());
        Assert.assertEquals((Object)actual.getMaxColumnLength(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getAverageColumnLength(), (Object)OptionalDouble.empty());
        Assert.assertEquals((Object)actual.getTrueCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getFalseCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getNullsCount(), (Object)OptionalLong.empty());
        Assert.assertEquals((Object)actual.getDistinctValuesCount(), (Object)OptionalLong.empty());
    }
}

