/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import com.facebook.presto.hive.authentication.NoHiveMetastoreAuthentication;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClientFactory;
import com.google.common.net.HostAndPort;
import java.util.Objects;
import org.apache.thrift.transport.TTransportException;

public class TestingHiveCluster
implements HiveCluster {
    private final HiveClientConfig config;
    private final HostAndPort address;

    public TestingHiveCluster(HiveClientConfig config, String host, int port) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.address = HostAndPort.fromParts((String)Objects.requireNonNull(host, "host is null"), (int)port);
    }

    public HiveMetastoreClient createMetastoreClient() {
        try {
            return new HiveMetastoreClientFactory(this.config, (HiveMetastoreAuthentication)new NoHiveMetastoreAuthentication()).create(this.address);
        }
        catch (TTransportException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TestingHiveCluster o = (TestingHiveCluster)obj;
        return Objects.equals(this.address, o.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }
}

