/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.AbstractTestHiveFileFormats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.benchmark.FileFormat;
import com.facebook.presto.hive.parquet.write.MapKeyValuesSchemaConverter;
import com.facebook.presto.hive.parquet.write.SingleLevelArrayMapKeyValuesSchemaConverter;
import com.facebook.presto.hive.parquet.write.SingleLevelArraySchemaConverter;
import com.facebook.presto.hive.parquet.write.TestMapredParquetOutputFormat;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlDecimal;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlVarbinary;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.Varchars;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import parquet.column.ParquetProperties;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.MessageType;

public class ParquetTester {
    public static final DateTimeZone HIVE_STORAGE_TIME_ZONE = DateTimeZone.forID((String)"Asia/Katmandu");
    private static final boolean OPTIMIZED = true;
    private static final HiveClientConfig HIVE_CLIENT_CONFIG = ParquetTester.getHiveClientConfig();
    private static final HdfsEnvironment HDFS_ENVIRONMENT = HiveTestUtils.createTestHdfsEnvironment(HIVE_CLIENT_CONFIG);
    private static final TestingConnectorSession SESSION = new TestingConnectorSession(new HiveSessionProperties(HIVE_CLIENT_CONFIG, new OrcFileWriterConfig()).getSessionProperties());
    private static final List<String> TEST_COLUMN = Collections.singletonList("test");
    private Set<CompressionCodecName> compressions = ImmutableSet.of();
    private Set<ParquetProperties.WriterVersion> versions = ImmutableSet.of();

    public static ParquetTester quickParquetTester() {
        ParquetTester parquetTester = new ParquetTester();
        parquetTester.compressions = ImmutableSet.of((Object)CompressionCodecName.GZIP);
        parquetTester.versions = ImmutableSet.of((Object)ParquetProperties.WriterVersion.PARQUET_1_0);
        return parquetTester;
    }

    public static ParquetTester fullParquetTester() {
        ParquetTester parquetTester = new ParquetTester();
        parquetTester.compressions = ImmutableSet.of((Object)CompressionCodecName.GZIP, (Object)CompressionCodecName.UNCOMPRESSED, (Object)CompressionCodecName.SNAPPY, (Object)CompressionCodecName.LZO);
        parquetTester.versions = ImmutableSet.copyOf((Object[])ParquetProperties.WriterVersion.values());
        return parquetTester;
    }

    public void testRoundTrip(PrimitiveObjectInspector columnObjectInspector, Iterable<?> writeValues, Type parameterType) throws Exception {
        this.testRoundTrip((ObjectInspector)columnObjectInspector, writeValues, writeValues, parameterType);
    }

    public <W, R> void testRoundTrip(PrimitiveObjectInspector columnObjectInspector, Iterable<W> writeValues, Function<W, R> readTransform, Type parameterType) throws Exception {
        this.testRoundTrip((ObjectInspector)columnObjectInspector, writeValues, Iterables.transform(writeValues, readTransform), parameterType);
    }

    public void testSingleLevelArraySchemaRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type) throws Exception {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)objectInspector.getTypeName());
        MessageType schema = SingleLevelArraySchemaConverter.convert(TEST_COLUMN, typeInfos);
        this.testRoundTrip(objectInspector, writeValues, readValues, type, Optional.of(schema));
        if (objectInspector.getTypeName().contains("map<")) {
            schema = SingleLevelArrayMapKeyValuesSchemaConverter.convert(TEST_COLUMN, typeInfos);
            this.testRoundTrip(objectInspector, writeValues, readValues, type, Optional.of(schema));
        }
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type) throws Exception {
        this.testRoundTripType(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), Optional.empty());
        this.assertRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, TEST_COLUMN, Collections.singletonList(type), Optional.empty());
        if (objectInspector.getTypeName().contains("map<")) {
            ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)objectInspector.getTypeName());
            MessageType schema = MapKeyValuesSchemaConverter.convert(TEST_COLUMN, typeInfos);
            this.testRoundTripType(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), Optional.of(schema));
            this.assertRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, TEST_COLUMN, Collections.singletonList(type), Optional.of(schema));
        }
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), parquetSchema);
    }

    public void testRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTripType(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema);
        this.assertRoundTrip(objectInspectors, this.transformToNulls(writeValues), this.transformToNulls(readValues), columnNames, columnTypes, parquetSchema);
    }

    private void testRoundTripType(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema) throws Exception {
        this.assertRoundTrip(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema);
        this.assertRoundTrip(objectInspectors, ParquetTester.reverse(writeValues), ParquetTester.reverse(readValues), columnNames, columnTypes, parquetSchema);
        this.assertRoundTrip(objectInspectors, ParquetTester.insertNullEvery(5, writeValues), ParquetTester.insertNullEvery(5, readValues), columnNames, columnTypes, parquetSchema);
        this.assertRoundTrip(objectInspectors, ParquetTester.insertNullEvery(5, ParquetTester.reverse(writeValues)), ParquetTester.insertNullEvery(5, ParquetTester.reverse(readValues)), columnNames, columnTypes, parquetSchema);
    }

    void assertRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema) throws Exception {
        for (ParquetProperties.WriterVersion version : this.versions) {
            for (CompressionCodecName compressionCodecName : this.compressions) {
                TempFile tempFile = new TempFile("test", "parquet");
                Throwable throwable = null;
                try {
                    JobConf jobConf = new JobConf();
                    jobConf.setEnum("parquet.compression", (Enum)compressionCodecName);
                    jobConf.setBoolean("parquet.enable.dictionary", true);
                    jobConf.setEnum("parquet.writer.version", (Enum)version);
                    ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), compressionCodecName, ParquetTester.createTableProperties(columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, objectInspectors), this.getIterators(writeValues), parquetSchema);
                    ParquetTester.assertFileContents(tempFile.getFile(), this.getIterators(readValues), columnNames, columnTypes);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tempFile == null) continue;
                    if (throwable != null) {
                        try {
                            tempFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tempFile.close();
                }
            }
        }
    }

    private static void assertFileContents(File dataFile, Iterator<?>[] expectedValues, List<String> columnNames, List<Type> columnTypes) throws IOException {
        try (ConnectorPageSource pageSource = ParquetTester.getFileFormat().createFileFormatReader((ConnectorSession)SESSION, HDFS_ENVIRONMENT, dataFile, columnNames, columnTypes);){
            if (pageSource instanceof RecordPageSource) {
                ParquetTester.assertRecordCursor(columnTypes, expectedValues, ((RecordPageSource)pageSource).getCursor());
            } else {
                ParquetTester.assertPageSource(columnTypes, expectedValues, pageSource);
            }
            Assert.assertFalse((boolean)Arrays.stream(expectedValues).allMatch(Iterator::hasNext));
        }
    }

    private static void assertPageSource(List<Type> types, Iterator<?>[] valuesByField, ConnectorPageSource pageSource) {
        Page page;
        while ((page = pageSource.getNextPage()) != null) {
            for (int field = 0; field < page.getChannelCount(); ++field) {
                Block block = page.getBlock(field);
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    Assert.assertTrue((boolean)valuesByField[field].hasNext());
                    Object expected = valuesByField[field].next();
                    Object actual = ParquetTester.decodeObject(types.get(field), block, i);
                    Assert.assertEquals((Object)actual, expected);
                }
            }
        }
    }

    private static void assertRecordCursor(List<Type> types, Iterator<?>[] valuesByField, RecordCursor cursor) {
        while (cursor.advanceNextPosition()) {
            for (int field = 0; field < types.size(); ++field) {
                Assert.assertTrue((boolean)valuesByField[field].hasNext());
                Object expected = valuesByField[field].next();
                Object actual = ParquetTester.getActualCursorValue(cursor, types.get(field), field);
                Assert.assertEquals((Object)actual, expected);
            }
        }
    }

    private static Object getActualCursorValue(RecordCursor cursor, Type type, int field) {
        Object fieldFromCursor = AbstractTestHiveFileFormats.getFieldFromCursor(cursor, type, field);
        if (fieldFromCursor == null) {
            return null;
        }
        if (HiveUtil.isStructuralType((Type)type)) {
            Block block = (Block)fieldFromCursor;
            if (HiveUtil.isArrayType((Type)type)) {
                Type elementType = ((ArrayType)type).getElementType();
                return ParquetTester.toArrayValue(block, elementType);
            }
            if (HiveUtil.isMapType((Type)type)) {
                MapType mapType = (MapType)type;
                return ParquetTester.toMapValue(block, mapType.getKeyType(), mapType.getValueType());
            }
            if (HiveUtil.isRowType((Type)type)) {
                return ParquetTester.toRowValue(block, type.getTypeParameters());
            }
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new SqlDecimal((BigInteger)fieldFromCursor, decimalType.getPrecision(), decimalType.getScale());
        }
        if (Varchars.isVarcharType((Type)type)) {
            return new String(((Slice)fieldFromCursor).getBytes());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return new SqlVarbinary(((Slice)fieldFromCursor).getBytes());
        }
        if (DateType.DATE.equals((Object)type)) {
            return new SqlDate(((Long)fieldFromCursor).intValue());
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return new SqlTimestamp(((Long)fieldFromCursor).longValue(), TimeZoneKey.UTC_KEY);
        }
        return fieldFromCursor;
    }

    private static Map toMapValue(Block mapBlock, Type keyType, Type valueType) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(mapBlock.getPositionCount() * 2);
        for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
            map.put(keyType.getObjectValue((ConnectorSession)SESSION, mapBlock, i), valueType.getObjectValue((ConnectorSession)SESSION, mapBlock, i + 1));
        }
        return Collections.unmodifiableMap(map);
    }

    private static List toArrayValue(Block arrayBlock, Type elementType) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int position = 0; position < arrayBlock.getPositionCount(); ++position) {
            values.add(elementType.getObjectValue((ConnectorSession)SESSION, arrayBlock, position));
        }
        return Collections.unmodifiableList(values);
    }

    private static List toRowValue(Block rowBlock, List<Type> fieldTypes) {
        ArrayList<Object> values = new ArrayList<Object>(rowBlock.getPositionCount());
        for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
            values.add(fieldTypes.get(i).getObjectValue((ConnectorSession)SESSION, rowBlock, i));
        }
        return Collections.unmodifiableList(values);
    }

    private static HiveClientConfig getHiveClientConfig() {
        HiveClientConfig config = new HiveClientConfig();
        config.setHiveStorageFormat(HiveStorageFormat.PARQUET);
        config.setParquetOptimizedReaderEnabled(true);
        config.setParquetPredicatePushdownEnabled(true);
        return config;
    }

    private static FileFormat getFileFormat() {
        return FileFormat.PRESTO_PARQUET;
    }

    private static DataSize writeParquetColumn(JobConf jobConf, File outputFile, CompressionCodecName compressionCodecName, Properties tableProperties, SettableStructObjectInspector objectInspector, Iterator<?>[] valuesByField, Optional<MessageType> parquetSchema) throws Exception {
        FileSinkOperator.RecordWriter recordWriter = new TestMapredParquetOutputFormat(parquetSchema).getHiveRecordWriter(jobConf, new Path(outputFile.toURI()), Text.class, compressionCodecName != CompressionCodecName.UNCOMPRESSED, tableProperties, () -> {});
        Object row = objectInspector.create();
        ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
        while (Arrays.stream(valuesByField).allMatch(Iterator::hasNext)) {
            for (int field = 0; field < fields.size(); ++field) {
                Object value = valuesByField[field].next();
                objectInspector.setStructFieldData(row, (StructField)fields.get(field), value);
            }
            ParquetHiveSerDe serde = new ParquetHiveSerDe();
            serde.initialize((Configuration)jobConf, tableProperties, null);
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            recordWriter.write(record);
        }
        recordWriter.close(false);
        return DataSize.succinctBytes((long)outputFile.length());
    }

    private static Properties createTableProperties(List<String> columnNames, List<ObjectInspector> objectInspectors) {
        Properties orderTableProperties = new Properties();
        orderTableProperties.setProperty("columns", Joiner.on((char)',').join(columnNames));
        orderTableProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform(objectInspectors, ObjectInspector::getTypeName)));
        return orderTableProperties;
    }

    private Iterator<?>[] getIterators(Iterable<?>[] values) {
        return (Iterator[])Arrays.stream(values).map(Iterable::iterator).toArray(Iterator[]::new);
    }

    private Iterable<?>[] transformToNulls(Iterable<?>[] values) {
        return (Iterable[])Arrays.stream(values).map(v -> Iterables.transform((Iterable)v, (Function)Functions.constant(null))).toArray(Iterable[]::new);
    }

    private static Iterable<?>[] reverse(Iterable<?>[] iterables) {
        return (Iterable[])Arrays.stream(iterables).map(ImmutableList::copyOf).map(Lists::reverse).toArray(Iterable[]::new);
    }

    static Iterable<?>[] insertNullEvery(int n, Iterable<?>[] iterables) {
        return (Iterable[])Arrays.stream(iterables).map(itr -> ParquetTester.insertNullEvery(n, itr)).toArray(Iterable[]::new);
    }

    static <T> Iterable<T> insertNullEvery(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                ++this.position;
                if (this.position > n) {
                    this.position = 0;
                    return null;
                }
                if (!this.delegate.hasNext()) {
                    return this.endOfData();
                }
                return this.delegate.next();
            }
        };
    }

    private static Object decodeObject(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return type.getObjectValue((ConnectorSession)SESSION, block, position);
    }

    static class TempFile
    implements Closeable {
        private final File file;

        public TempFile(String prefix, String suffix) {
            try {
                this.file = File.createTempFile(prefix, suffix);
                this.file.delete();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public void close() {
            this.file.delete();
        }
    }
}

