/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.parquet.predicate.TupleDomainParquetPredicate;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;
import parquet.column.statistics.BinaryStatistics;
import parquet.column.statistics.BooleanStatistics;
import parquet.column.statistics.DoubleStatistics;
import parquet.column.statistics.FloatStatistics;
import parquet.column.statistics.LongStatistics;
import parquet.column.statistics.Statistics;
import parquet.io.api.Binary;

public class TestTupleDomainParquetPredicate {
    @Test
    public void testBoolean() {
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)0L, null), (Object)Domain.all((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)10L, (Statistics)TestTupleDomainParquetPredicate.booleanColumnStats(true, true)), (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)true));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)10L, (Statistics)TestTupleDomainParquetPredicate.booleanColumnStats(false, false)), (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)BooleanType.BOOLEAN, (long)20L, (Statistics)TestTupleDomainParquetPredicate.booleanColumnStats(false, true)), (Object)Domain.all((Type)BooleanType.BOOLEAN));
    }

    private static BooleanStatistics booleanColumnStats(boolean minimum, boolean maximum) {
        BooleanStatistics statistics = new BooleanStatistics();
        statistics.setMinMax(minimum, maximum);
        return statistics;
    }

    @Test
    public void testBigint() {
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)BigintType.BIGINT, (long)0L, null), (Object)Domain.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(100L, 100L)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)100L));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)BigintType.BIGINT, (long)10L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(0L, 100L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
    }

    private static LongStatistics longColumnStats(long minimum, long maximum) {
        LongStatistics statistics = new LongStatistics();
        statistics.setMinMax(minimum, maximum);
        return statistics;
    }

    @Test
    public void testInteger() {
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)IntegerType.INTEGER, (long)0L, null), (Object)Domain.all((Type)IntegerType.INTEGER));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)IntegerType.INTEGER, (long)10L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(100L, 100L)), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)100L));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)IntegerType.INTEGER, (long)10L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(0L, 100L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)IntegerType.INTEGER, (long)20L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(0L, 0x80000000L)), (Object)Domain.notNull((Type)IntegerType.INTEGER));
    }

    @Test
    public void testSmallint() {
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)SmallintType.SMALLINT, (long)0L, null), (Object)Domain.all((Type)SmallintType.SMALLINT));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)SmallintType.SMALLINT, (long)10L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(100L, 100L)), (Object)Domain.singleValue((Type)SmallintType.SMALLINT, (Object)100L));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)SmallintType.SMALLINT, (long)10L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(0L, 100L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)SmallintType.SMALLINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)SmallintType.SMALLINT, (long)20L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(0L, 0x80000000L)), (Object)Domain.notNull((Type)SmallintType.SMALLINT));
    }

    @Test
    public void testTinyint() {
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)TinyintType.TINYINT, (long)0L, null), (Object)Domain.all((Type)TinyintType.TINYINT));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)TinyintType.TINYINT, (long)10L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(100L, 100L)), (Object)Domain.singleValue((Type)TinyintType.TINYINT, (Object)100L));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)TinyintType.TINYINT, (long)10L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(0L, 100L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)TinyintType.TINYINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)TinyintType.TINYINT, (long)20L, (Statistics)TestTupleDomainParquetPredicate.longColumnStats(0L, 0x80000000L)), (Object)Domain.notNull((Type)TinyintType.TINYINT));
    }

    @Test
    public void testDouble() {
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)DoubleType.DOUBLE, (long)0L, null), (Object)Domain.all((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.doubleColumnStats(42.24, 42.24)), (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)42.24));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)DoubleType.DOUBLE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.doubleColumnStats(3.3, 42.24)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)3.3, (boolean)true, (Object)42.24, (boolean)true), (Range[])new Range[0]), (boolean)false));
    }

    private static DoubleStatistics doubleColumnStats(double minimum, double maximum) {
        DoubleStatistics statistics = new DoubleStatistics();
        statistics.setMinMax(minimum, maximum);
        return statistics;
    }

    @Test
    public void testString() {
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)VarcharType.createUnboundedVarcharType(), (long)0L, null), (Object)Domain.all((Type)VarcharType.createUnboundedVarcharType()));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)VarcharType.createUnboundedVarcharType(), (long)10L, (Statistics)TestTupleDomainParquetPredicate.stringColumnStats("taco", "taco")), (Object)Domain.singleValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"taco")));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)VarcharType.createUnboundedVarcharType(), (long)10L, (Statistics)TestTupleDomainParquetPredicate.stringColumnStats("apple", "taco")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"apple"), (boolean)true, (Object)Slices.utf8Slice((String)"taco"), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)VarcharType.createUnboundedVarcharType(), (long)10L, (Statistics)TestTupleDomainParquetPredicate.stringColumnStats("\u4e2d\u56fd", "\u7f8e\u5229\u575a")), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"\u4e2d\u56fd"), (boolean)true, (Object)Slices.utf8Slice((String)"\u7f8e\u5229\u575a"), (boolean)true), (Range[])new Range[0]), (boolean)false));
    }

    private static BinaryStatistics stringColumnStats(String minimum, String maximum) {
        BinaryStatistics statistics = new BinaryStatistics();
        statistics.setMinMax(Binary.fromString((String)minimum), Binary.fromString((String)maximum));
        return statistics;
    }

    @Test
    public void testFloat() {
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)RealType.REAL, (long)0L, null), (Object)Domain.all((Type)RealType.REAL));
        float minimum = 4.3f;
        float maximum = 40.3f;
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(minimum, minimum)), (Object)Domain.singleValue((Type)RealType.REAL, (Object)Float.floatToRawIntBits(minimum)));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(minimum, maximum)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(minimum), (boolean)true, (Object)Float.floatToRawIntBits(maximum), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(maximum, minimum)), (Object)Domain.create((ValueSet)ValueSet.all((Type)RealType.REAL), (boolean)false));
    }

    private static FloatStatistics floatColumnStats(float minimum, float maximum) {
        FloatStatistics statistics = new FloatStatistics();
        statistics.setMinMax(minimum, maximum);
        return statistics;
    }
}

