/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.predicate;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicateUtils;
import com.facebook.presto.spi.block.MethodHandleUtil;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class TestParquetPredicateUtils {
    @Test
    public void testDictionaryEncodingCasesV1() {
        ImmutableSet required = ImmutableSet.of((Object)Encoding.BIT_PACKED);
        ImmutableSet optional = ImmutableSet.of((Object)Encoding.BIT_PACKED, (Object)Encoding.RLE);
        ImmutableSet repeated = ImmutableSet.of((Object)Encoding.RLE);
        ImmutableSet notDictionary = ImmutableSet.of((Object)Encoding.PLAIN);
        ImmutableSet mixedDictionary = ImmutableSet.of((Object)Encoding.PLAIN_DICTIONARY, (Object)Encoding.PLAIN);
        ImmutableSet dictionary = ImmutableSet.of((Object)Encoding.PLAIN_DICTIONARY);
        Assert.assertFalse((boolean)ParquetPredicateUtils.isOnlyDictionaryEncodingPages((Set)Sets.union((Set)required, (Set)notDictionary)), (String)"required notDictionary");
        Assert.assertFalse((boolean)ParquetPredicateUtils.isOnlyDictionaryEncodingPages((Set)Sets.union((Set)optional, (Set)notDictionary)), (String)"optional notDictionary");
        Assert.assertFalse((boolean)ParquetPredicateUtils.isOnlyDictionaryEncodingPages((Set)Sets.union((Set)repeated, (Set)notDictionary)), (String)"repeated notDictionary");
        Assert.assertFalse((boolean)ParquetPredicateUtils.isOnlyDictionaryEncodingPages((Set)Sets.union((Set)required, (Set)mixedDictionary)), (String)"required mixedDictionary");
        Assert.assertFalse((boolean)ParquetPredicateUtils.isOnlyDictionaryEncodingPages((Set)Sets.union((Set)optional, (Set)mixedDictionary)), (String)"optional mixedDictionary");
        Assert.assertFalse((boolean)ParquetPredicateUtils.isOnlyDictionaryEncodingPages((Set)Sets.union((Set)repeated, (Set)mixedDictionary)), (String)"repeated mixedDictionary");
        Assert.assertTrue((boolean)ParquetPredicateUtils.isOnlyDictionaryEncodingPages((Set)Sets.union((Set)required, (Set)dictionary)), (String)"required dictionary");
        Assert.assertTrue((boolean)ParquetPredicateUtils.isOnlyDictionaryEncodingPages((Set)Sets.union((Set)optional, (Set)dictionary)), (String)"optional dictionary");
        Assert.assertTrue((boolean)ParquetPredicateUtils.isOnlyDictionaryEncodingPages((Set)Sets.union((Set)repeated, (Set)dictionary)), (String)"repeated dictionary");
    }

    @Test
    public void testParquetTupleDomainPrimitiveArray() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_array", HiveType.valueOf((String)"array<int>"), TypeSignature.parseTypeSignature((String)"array"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((com.facebook.presto.spi.type.Type)new ArrayType((com.facebook.presto.spi.type.Type)IntegerType.INTEGER))));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_array", new Type[]{new GroupType(Type.Repetition.REPEATED, "bag", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "array_element")})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPredicateUtils.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertTrue((boolean)((Map)tupleDomain.getDomains().get()).isEmpty());
    }

    @Test
    public void testParquetTupleDomainStructArray() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_array_struct", HiveType.valueOf((String)"array<struct<a:int>>"), TypeSignature.parseTypeSignature((String)"array"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        RowType.Field rowField = new RowType.Field(Optional.of("a"), (com.facebook.presto.spi.type.Type)IntegerType.INTEGER);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)rowField));
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((com.facebook.presto.spi.type.Type)new ArrayType((com.facebook.presto.spi.type.Type)rowType))));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_array_struct", new Type[]{new GroupType(Type.Repetition.REPEATED, "bag", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "array_element", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a")})})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPredicateUtils.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertTrue((boolean)((Map)tupleDomain.getDomains().get()).isEmpty());
    }

    @Test
    public void testParquetTupleDomainPrimitive() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_primitive", HiveType.valueOf((String)"bigint"), TypeSignature.parseTypeSignature((String)"bigint"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        Domain singleValueDomain = Domain.singleValue((com.facebook.presto.spi.type.Type)BigintType.BIGINT, (Object)123L);
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)singleValueDomain));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "my_primitive")});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPredicateUtils.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertEquals((int)((Map)tupleDomain.getDomains().get()).size(), (int)1);
        ColumnDescriptor descriptor = (ColumnDescriptor)((Map)tupleDomain.getDomains().get()).keySet().iterator().next();
        Assert.assertEquals((int)descriptor.getPath().length, (int)1);
        Assert.assertEquals((String)descriptor.getPath()[0], (String)"my_primitive");
        Domain predicateDomain = (Domain)Iterables.getOnlyElement(((Map)tupleDomain.getDomains().get()).values());
        Assert.assertEquals((Object)predicateDomain, (Object)singleValueDomain);
    }

    @Test
    public void testParquetTupleDomainStruct() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_struct", HiveType.valueOf((String)"struct<a:int,b:int>"), TypeSignature.parseTypeSignature((String)"row"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        RowType.Field rowField = new RowType.Field(Optional.of("my_struct"), (com.facebook.presto.spi.type.Type)IntegerType.INTEGER);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)rowField));
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((com.facebook.presto.spi.type.Type)rowType)));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_struct", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b")})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPredicateUtils.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertTrue((boolean)((Map)tupleDomain.getDomains().get()).isEmpty());
    }

    @Test
    public void testParquetTupleDomainMap() {
        HiveColumnHandle columnHandle = new HiveColumnHandle("my_map", HiveType.valueOf((String)"map<int,int>"), TypeSignature.parseTypeSignature((String)"map"), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        MapType mapType = new MapType((com.facebook.presto.spi.type.Type)IntegerType.INTEGER, (com.facebook.presto.spi.type.Type)IntegerType.INTEGER, MethodHandleUtil.methodHandle(TestParquetPredicateUtils.class, (String)"throwUnsupportedOperationException", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestParquetPredicateUtils.class, (String)"throwUnsupportedOperationException", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestParquetPredicateUtils.class, (String)"throwUnsupportedOperationException", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestParquetPredicateUtils.class, (String)"throwUnsupportedOperationException", (Class[])new Class[0]));
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((com.facebook.presto.spi.type.Type)mapType)));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_map", new Type[]{new GroupType(Type.Repetition.REPEATED, "map", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "key"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "value")})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPredicateUtils.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain);
        Assert.assertTrue((boolean)((Map)tupleDomain.getDomains().get()).isEmpty());
    }

    public static void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException();
    }
}

