/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.write;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.Types;

public class SingleLevelArrayMapKeyValuesSchemaConverter {
    private SingleLevelArrayMapKeyValuesSchemaConverter() {
    }

    public static MessageType convert(List<String> columnNames, List<TypeInfo> columnTypes) {
        return new MessageType("hive_schema", SingleLevelArrayMapKeyValuesSchemaConverter.convertTypes(columnNames, columnTypes));
    }

    private static Type[] convertTypes(List<String> columnNames, List<TypeInfo> columnTypes) {
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalStateException("Mismatched Hive columns and types. Hive columns names found : " + columnNames + " . And Hive types found : " + columnTypes);
        }
        Type[] types = new Type[columnNames.size()];
        for (int i = 0; i < columnNames.size(); ++i) {
            types[i] = SingleLevelArrayMapKeyValuesSchemaConverter.convertType(columnNames.get(i), columnTypes.get(i));
        }
        return types;
    }

    private static Type convertType(String name, TypeInfo typeInfo) {
        return SingleLevelArrayMapKeyValuesSchemaConverter.convertType(name, typeInfo, Type.Repetition.OPTIONAL);
    }

    private static Type convertType(String name, TypeInfo typeInfo, Type.Repetition repetition) {
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            if (typeInfo.equals((Object)TypeInfoFactory.stringTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.intTypeInfo) || typeInfo.equals((Object)TypeInfoFactory.shortTypeInfo) || typeInfo.equals((Object)TypeInfoFactory.byteTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.longTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.floatTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.binaryTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.voidTypeInfo)) {
                throw new UnsupportedOperationException("Void type not implemented");
            }
            if (typeInfo.getTypeName().toLowerCase().startsWith("char")) {
                if (repetition == Type.Repetition.OPTIONAL) {
                    return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(name);
                }
                return (Type)((Types.PrimitiveBuilder)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(name);
            }
            if (typeInfo.getTypeName().toLowerCase().startsWith("varchar")) {
                if (repetition == Type.Repetition.OPTIONAL) {
                    return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(name);
                }
                return (Type)((Types.PrimitiveBuilder)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(name);
            }
            if (typeInfo instanceof DecimalTypeInfo) {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                int prec = decimalTypeInfo.precision();
                int scale = decimalTypeInfo.scale();
                int bytes = ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1];
                if (repetition == Type.Repetition.OPTIONAL) {
                    return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(bytes).as(OriginalType.DECIMAL)).scale(scale).precision(prec).named(name);
                }
                return (Type)((Types.PrimitiveBuilder)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(bytes).as(OriginalType.DECIMAL)).scale(scale).precision(prec).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.dateTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE)).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.unknownTypeInfo)) {
                throw new UnsupportedOperationException("Unknown type not implemented");
            }
            throw new IllegalArgumentException("Unknown type: " + typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            return SingleLevelArrayMapKeyValuesSchemaConverter.convertArrayType(name, (ListTypeInfo)typeInfo, repetition);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return SingleLevelArrayMapKeyValuesSchemaConverter.convertStructType(name, (StructTypeInfo)typeInfo, repetition);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            return SingleLevelArrayMapKeyValuesSchemaConverter.convertMapType(name, (MapTypeInfo)typeInfo, repetition);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.UNION)) {
            throw new UnsupportedOperationException("Union type not implemented");
        }
        throw new IllegalArgumentException("Unknown type: " + typeInfo);
    }

    private static GroupType convertArrayType(String name, ListTypeInfo typeInfo, Type.Repetition repetition) {
        TypeInfo subType = typeInfo.getListElementTypeInfo();
        return SingleLevelArrayMapKeyValuesSchemaConverter.listWrapper(name, OriginalType.LIST, SingleLevelArrayMapKeyValuesSchemaConverter.convertType("array_element", subType, Type.Repetition.REPEATED), repetition);
    }

    private static GroupType convertStructType(String name, StructTypeInfo typeInfo, Type.Repetition repetition) {
        ArrayList columnNames = typeInfo.getAllStructFieldNames();
        ArrayList columnTypes = typeInfo.getAllStructFieldTypeInfos();
        return new GroupType(repetition, name, SingleLevelArrayMapKeyValuesSchemaConverter.convertTypes(columnNames, columnTypes));
    }

    private static GroupType convertMapType(String name, MapTypeInfo typeInfo, Type.Repetition repetition) {
        Type keyType = SingleLevelArrayMapKeyValuesSchemaConverter.convertType(ParquetHiveSerDe.MAP_KEY.toString(), typeInfo.getMapKeyTypeInfo(), Type.Repetition.REQUIRED);
        Type valueType = SingleLevelArrayMapKeyValuesSchemaConverter.convertType(ParquetHiveSerDe.MAP_VALUE.toString(), typeInfo.getMapValueTypeInfo());
        return SingleLevelArrayMapKeyValuesSchemaConverter.mapType(repetition, name, "map", keyType, valueType);
    }

    public static GroupType mapType(Type.Repetition repetition, String alias, String mapAlias, Type keyType, Type valueType) {
        if (valueType == null) {
            return SingleLevelArrayMapKeyValuesSchemaConverter.listWrapper(repetition, alias, OriginalType.MAP_KEY_VALUE, (Type)new GroupType(Type.Repetition.REPEATED, mapAlias, new Type[]{keyType}));
        }
        if (!valueType.getName().equals("value")) {
            throw new RuntimeException(valueType.getName() + " should be value");
        }
        return SingleLevelArrayMapKeyValuesSchemaConverter.listWrapper(repetition, alias, OriginalType.MAP_KEY_VALUE, (Type)new GroupType(Type.Repetition.REPEATED, mapAlias, new Type[]{keyType, valueType}));
    }

    private static GroupType listWrapper(Type.Repetition repetition, String alias, OriginalType originalType, Type nested) {
        if (!nested.isRepetition(Type.Repetition.REPEATED)) {
            throw new IllegalArgumentException("Nested type should be repeated: " + nested);
        }
        return new GroupType(repetition, alias, originalType, new Type[]{nested});
    }

    private static GroupType listWrapper(String name, OriginalType originalType, Type elementType, Type.Repetition repetition) {
        return new GroupType(repetition, name, originalType, new Type[]{elementType});
    }
}

