/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3;

import com.facebook.presto.hive.s3.HiveS3Config;
import com.facebook.presto.hive.s3.PrestoS3SignerType;
import com.facebook.presto.hive.s3.PrestoS3SseType;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestHiveS3Config {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HiveS3Config)ConfigAssertions.recordDefaults(HiveS3Config.class)).setS3AwsAccessKey(null).setS3AwsSecretKey(null).setS3Endpoint(null).setS3SignerType(null).setS3PathStyleAccess(false).setS3UseInstanceCredentials(true).setS3SslEnabled(true).setS3SseEnabled(false).setS3SseType(PrestoS3SseType.S3).setS3SseKmsKeyId(null).setS3KmsKeyId(null).setS3EncryptionMaterialsProvider(null).setS3MaxClientRetries(5).setS3MaxErrorRetries(10).setS3MaxBackoffTime(new Duration(10.0, TimeUnit.MINUTES)).setS3MaxRetryTime(new Duration(10.0, TimeUnit.MINUTES)).setS3ConnectTimeout(new Duration(5.0, TimeUnit.SECONDS)).setS3SocketTimeout(new Duration(5.0, TimeUnit.SECONDS)).setS3MultipartMinFileSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setS3MultipartMinPartSize(new DataSize(5.0, DataSize.Unit.MEGABYTE)).setS3MaxConnections(500).setS3StagingDirectory(new File(StandardSystemProperty.JAVA_IO_TMPDIR.value())).setPinS3ClientToCurrentRegion(false).setS3UserAgentPrefix(""));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.s3.aws-access-key", (Object)"abc123").put((Object)"hive.s3.aws-secret-key", (Object)"secret").put((Object)"hive.s3.endpoint", (Object)"endpoint.example.com").put((Object)"hive.s3.signer-type", (Object)"S3SignerType").put((Object)"hive.s3.path-style-access", (Object)"true").put((Object)"hive.s3.use-instance-credentials", (Object)"false").put((Object)"hive.s3.ssl.enabled", (Object)"false").put((Object)"hive.s3.sse.enabled", (Object)"true").put((Object)"hive.s3.sse.type", (Object)"KMS").put((Object)"hive.s3.sse.kms-key-id", (Object)"KMS_KEY_ID").put((Object)"hive.s3.encryption-materials-provider", (Object)"EMP_CLASS").put((Object)"hive.s3.kms-key-id", (Object)"KEY_ID").put((Object)"hive.s3.max-client-retries", (Object)"9").put((Object)"hive.s3.max-error-retries", (Object)"8").put((Object)"hive.s3.max-backoff-time", (Object)"4m").put((Object)"hive.s3.max-retry-time", (Object)"20m").put((Object)"hive.s3.connect-timeout", (Object)"8s").put((Object)"hive.s3.socket-timeout", (Object)"4m").put((Object)"hive.s3.multipart.min-file-size", (Object)"32MB").put((Object)"hive.s3.multipart.min-part-size", (Object)"15MB").put((Object)"hive.s3.max-connections", (Object)"77").put((Object)"hive.s3.staging-directory", (Object)"/s3-staging").put((Object)"hive.s3.pin-client-to-current-region", (Object)"true").put((Object)"hive.s3.user-agent-prefix", (Object)"user-agent-prefix").build();
        HiveS3Config expected = new HiveS3Config().setS3AwsAccessKey("abc123").setS3AwsSecretKey("secret").setS3Endpoint("endpoint.example.com").setS3SignerType(PrestoS3SignerType.S3SignerType).setS3PathStyleAccess(true).setS3UseInstanceCredentials(false).setS3SslEnabled(false).setS3SseEnabled(true).setS3SseType(PrestoS3SseType.KMS).setS3SseKmsKeyId("KMS_KEY_ID").setS3EncryptionMaterialsProvider("EMP_CLASS").setS3KmsKeyId("KEY_ID").setS3MaxClientRetries(9).setS3MaxErrorRetries(8).setS3MaxBackoffTime(new Duration(4.0, TimeUnit.MINUTES)).setS3MaxRetryTime(new Duration(20.0, TimeUnit.MINUTES)).setS3ConnectTimeout(new Duration(8.0, TimeUnit.SECONDS)).setS3SocketTimeout(new Duration(4.0, TimeUnit.MINUTES)).setS3MultipartMinFileSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setS3MultipartMinPartSize(new DataSize(15.0, DataSize.Unit.MEGABYTE)).setS3MaxConnections(77).setS3StagingDirectory(new File("/s3-staging")).setPinS3ClientToCurrentRegion(true).setS3UserAgentPrefix("user-agent-prefix");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

