/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security;

import com.facebook.presto.hive.security.PartitionsAwareAccessControl;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import java.lang.reflect.Method;
import org.testng.annotations.Test;

public class TestPartitionsAwareAccessControl {
    @Test
    public void testEverythingDelegated() throws Exception {
        TestPartitionsAwareAccessControl.checkEverythingImplemented(ConnectorAccessControl.class, PartitionsAwareAccessControl.class);
    }

    private static <I> void checkEverythingImplemented(Class<I> interfaceClass, Class<? extends I> implementationClass) throws ReflectiveOperationException {
        for (Method interfaceMethod : interfaceClass.getMethods()) {
            Method implementationMethod = implementationClass.getMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
            if (interfaceMethod.equals(implementationMethod)) {
                throw new AssertionError((Object)String.format("Method should be overridden in %s: %s", implementationClass, interfaceMethod));
            }
        }
    }
}

