/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.util.MergingPageIterator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.IntegerType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMergingPageIterator {
    @Test
    public void testMerging() {
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER);
        ImmutableList sortIndexes = ImmutableList.of((Object)1);
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST);
        ArrayList pageLists = new ArrayList();
        PageBuilder pageBuilder = new PageBuilder((List)types);
        for (int i = 0; i < 10; ++i) {
            Iterator values = IntStream.range(0, 1000).map(ignored -> ThreadLocalRandom.current().nextInt(100000)).mapToObj(n -> n % 100 == 0 ? null : Integer.valueOf(n)).sorted(Comparator.nullsFirst(Comparator.naturalOrder())).iterator();
            ArrayList<Page> pages = new ArrayList<Page>();
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 100; ++k) {
                    Integer n2 = (Integer)values.next();
                    pageBuilder.declarePosition();
                    if (n2 == null) {
                        pageBuilder.getBlockBuilder(0).appendNull();
                        pageBuilder.getBlockBuilder(1).appendNull();
                        continue;
                    }
                    IntegerType.INTEGER.writeLong(pageBuilder.getBlockBuilder(0), (long)n2.intValue());
                    IntegerType.INTEGER.writeLong(pageBuilder.getBlockBuilder(1), (long)n2.intValue() * 22L);
                }
                pages.add(pageBuilder.build());
                pageBuilder.reset();
            }
            pageLists.add(pages);
            Assert.assertFalse((boolean)values.hasNext());
        }
        List pages = pageLists.stream().map(List::iterator).collect(Collectors.toList());
        MergingPageIterator iterator = new MergingPageIterator(pages, (List)types, (List)sortIndexes, (List)sortOrders);
        ArrayList<Long> values = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Page page = (Page)iterator.next();
            for (int i = 0; i < page.getPositionCount(); ++i) {
                if (page.getBlock(0).isNull(i)) {
                    Assert.assertTrue((boolean)page.getBlock(1).isNull(i));
                    values.add(null);
                    continue;
                }
                long x = IntegerType.INTEGER.getLong(page.getBlock(0), i);
                long y = IntegerType.INTEGER.getLong(page.getBlock(1), i);
                Assert.assertEquals((long)y, (long)(x * 22L));
                values.add(x);
            }
        }
        Assertions.assertThat(values).isSortedAccordingTo(Comparator.nullsFirst(Comparator.naturalOrder()));
    }
}

