/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.glue.TestingMetastoreObjects;
import com.facebook.presto.hive.util.Statistics;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestStatistics {
    @Test
    public void testReduce() {
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.ADD)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createZeroStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.ADD)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createZeroStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.ADD)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.SUBTRACT)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createZeroStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.SUBTRACT)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)HiveBasicStatistics.createEmptyStatistics(), (HiveBasicStatistics)HiveBasicStatistics.createZeroStatistics(), (Statistics.ReduceOperator)Statistics.ReduceOperator.SUBTRACT)).isEqualTo((Object)HiveBasicStatistics.createEmptyStatistics());
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)new HiveBasicStatistics(11L, 9L, 7L, 5L), (HiveBasicStatistics)new HiveBasicStatistics(1L, 2L, 3L, 4L), (Statistics.ReduceOperator)Statistics.ReduceOperator.ADD)).isEqualTo((Object)new HiveBasicStatistics(12L, 11L, 10L, 9L));
        Assertions.assertThat((Object)Statistics.reduce((HiveBasicStatistics)new HiveBasicStatistics(11L, 9L, 7L, 5L), (HiveBasicStatistics)new HiveBasicStatistics(1L, 2L, 3L, 4L), (Statistics.ReduceOperator)Statistics.ReduceOperator.SUBTRACT)).isEqualTo((Object)new HiveBasicStatistics(10L, 7L, 4L, 1L));
    }

    @Test
    public void testUpdateTableStatistics() {
        TestStatistics.testUpdateTableStatistics(Statistics.ReduceOperator.ADD, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdateTableStatistics(Statistics.ReduceOperator.SUBTRACT, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdateTableStatistics(Statistics.ReduceOperator.ADD, HiveBasicStatistics.createZeroStatistics(), HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdateTableStatistics(Statistics.ReduceOperator.SUBTRACT, HiveBasicStatistics.createZeroStatistics(), HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdateTableStatistics(Statistics.ReduceOperator.ADD, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createZeroStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdateTableStatistics(Statistics.ReduceOperator.SUBTRACT, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createZeroStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdateTableStatistics(Statistics.ReduceOperator.ADD, new HiveBasicStatistics(1L, 2L, 3L, 4L), new HiveBasicStatistics(2L, 3L, 4L, 5L), new HiveBasicStatistics(3L, 5L, 7L, 9L));
        TestStatistics.testUpdateTableStatistics(Statistics.ReduceOperator.SUBTRACT, new HiveBasicStatistics(11L, 9L, 7L, 5L), new HiveBasicStatistics(1L, 2L, 3L, 4L), new HiveBasicStatistics(10L, 7L, 4L, 1L));
    }

    @Test
    public void testUpdatePartitionStatistics() {
        TestStatistics.testUpdatePartitionStatistics(Statistics.ReduceOperator.ADD, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdatePartitionStatistics(Statistics.ReduceOperator.SUBTRACT, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdatePartitionStatistics(Statistics.ReduceOperator.ADD, HiveBasicStatistics.createZeroStatistics(), HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdatePartitionStatistics(Statistics.ReduceOperator.SUBTRACT, HiveBasicStatistics.createZeroStatistics(), HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdatePartitionStatistics(Statistics.ReduceOperator.ADD, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createZeroStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdatePartitionStatistics(Statistics.ReduceOperator.SUBTRACT, HiveBasicStatistics.createEmptyStatistics(), HiveBasicStatistics.createZeroStatistics(), HiveBasicStatistics.createEmptyStatistics());
        TestStatistics.testUpdatePartitionStatistics(Statistics.ReduceOperator.ADD, new HiveBasicStatistics(1L, 2L, 3L, 4L), new HiveBasicStatistics(2L, 3L, 4L, 5L), new HiveBasicStatistics(3L, 5L, 7L, 9L));
        TestStatistics.testUpdatePartitionStatistics(Statistics.ReduceOperator.SUBTRACT, new HiveBasicStatistics(11L, 9L, 7L, 5L), new HiveBasicStatistics(1L, 2L, 3L, 4L), new HiveBasicStatistics(10L, 7L, 4L, 1L));
    }

    private static void testUpdateTableStatistics(Statistics.ReduceOperator operator, HiveBasicStatistics initial, HiveBasicStatistics update, HiveBasicStatistics expected) {
        Table initialTable = TestStatistics.table(initial);
        Table updatedTable = Statistics.updateStatistics((Table)initialTable, (HiveBasicStatistics)update, (Statistics.ReduceOperator)operator);
        HiveBasicStatistics updatedStatistics = HiveBasicStatistics.createFromPartitionParameters((Map)updatedTable.getParameters());
        Assertions.assertThat((Object)updatedStatistics).isEqualTo((Object)expected);
    }

    private static void testUpdatePartitionStatistics(Statistics.ReduceOperator operator, HiveBasicStatistics initial, HiveBasicStatistics update, HiveBasicStatistics expected) {
        Partition initialPartition = TestStatistics.partition(initial);
        Partition updatedPartition = Statistics.updateStatistics((Partition)initialPartition, (HiveBasicStatistics)update, (Statistics.ReduceOperator)operator);
        HiveBasicStatistics updatedStatistics = HiveBasicStatistics.createFromPartitionParameters((Map)updatedPartition.getParameters());
        Assertions.assertThat((Object)updatedStatistics).isEqualTo((Object)expected);
    }

    private static Table table(HiveBasicStatistics statistics) {
        return Table.builder((Table)TestingMetastoreObjects.getPrestoTestTable("test_database")).setParameters(statistics.toPartitionParameters()).build();
    }

    private static Partition partition(HiveBasicStatistics statistics) {
        return Partition.builder((Partition)TestingMetastoreObjects.getPrestoTestPartition("test_database", "test_table", (List<String>)ImmutableList.of((Object)"test_partition"))).setParameters(statistics.toPartitionParameters()).build();
    }
}

