/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import javax.annotation.Nullable;

public class HiveBasicStatistics {
    private static final String NUM_FILES = "numFiles";
    private static final String NUM_ROWS = "numRows";
    private static final String RAW_DATA_SIZE = "rawDataSize";
    private static final String TOTAL_SIZE = "totalSize";
    private final OptionalLong fileCount;
    private final OptionalLong rowCount;
    private final OptionalLong inMemoryDataSizeInBytes;
    private final OptionalLong onDiskDataSizeInBytes;

    public static HiveBasicStatistics createEmptyStatistics() {
        return new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty());
    }

    public static HiveBasicStatistics createZeroStatistics() {
        return new HiveBasicStatistics(0L, 0L, 0L, 0L);
    }

    public HiveBasicStatistics(long fileCount, long rowCount, long inMemoryDataSizeInBytes, long onDiskDataSizeInBytes) {
        this(OptionalLong.of(fileCount), OptionalLong.of(rowCount), OptionalLong.of(inMemoryDataSizeInBytes), OptionalLong.of(onDiskDataSizeInBytes));
    }

    public HiveBasicStatistics(OptionalLong fileCount, OptionalLong rowCount, OptionalLong inMemoryDataSizeInBytes, OptionalLong onDiskDataSizeInBytes) {
        this.fileCount = Objects.requireNonNull(fileCount, "fileCount is null");
        fileCount.ifPresent(count -> Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (String)"fileCount is negative: %d", (long)count));
        this.rowCount = Objects.requireNonNull(rowCount, "rowCount is null");
        rowCount.ifPresent(count -> Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (String)"rowCount is negative: %d", (long)count));
        this.inMemoryDataSizeInBytes = Objects.requireNonNull(inMemoryDataSizeInBytes, "inMemoryDataSizeInBytes is null");
        inMemoryDataSizeInBytes.ifPresent(size -> Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (String)"inMemoryDataSizeInBytes is negative: %d", (long)size));
        this.onDiskDataSizeInBytes = Objects.requireNonNull(onDiskDataSizeInBytes, "onDiskDataSizeInBytes is null");
        onDiskDataSizeInBytes.ifPresent(size -> Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (String)"onDiskDataSizeInBytes is negative: %d", (long)size));
    }

    public OptionalLong getFileCount() {
        return this.fileCount;
    }

    public OptionalLong getRowCount() {
        return this.rowCount;
    }

    public OptionalLong getInMemoryDataSizeInBytes() {
        return this.inMemoryDataSizeInBytes;
    }

    public OptionalLong getOnDiskDataSizeInBytes() {
        return this.onDiskDataSizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveBasicStatistics that = (HiveBasicStatistics)o;
        return Objects.equals(this.fileCount, that.fileCount) && Objects.equals(this.rowCount, that.rowCount) && Objects.equals(this.inMemoryDataSizeInBytes, that.inMemoryDataSizeInBytes) && Objects.equals(this.onDiskDataSizeInBytes, that.onDiskDataSizeInBytes);
    }

    public int hashCode() {
        return Objects.hash(this.fileCount, this.rowCount, this.inMemoryDataSizeInBytes, this.onDiskDataSizeInBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileCount", (Object)this.fileCount).add("rowCount", (Object)this.rowCount).add("inMemoryDataSizeInBytes", (Object)this.inMemoryDataSizeInBytes).add("onDiskDataSizeInBytes", (Object)this.onDiskDataSizeInBytes).toString();
    }

    public Map<String, String> toPartitionParameters() {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        this.fileCount.ifPresent(count -> properties.put((Object)NUM_FILES, (Object)Long.toString(count)));
        this.rowCount.ifPresent(count -> properties.put((Object)NUM_ROWS, (Object)Long.toString(count)));
        this.inMemoryDataSizeInBytes.ifPresent(size -> properties.put((Object)RAW_DATA_SIZE, (Object)Long.toString(size)));
        this.onDiskDataSizeInBytes.ifPresent(size -> properties.put((Object)TOTAL_SIZE, (Object)Long.toString(size)));
        return properties.build();
    }

    public static HiveBasicStatistics createFromPartitionParameters(Map<String, String> parameters) {
        OptionalLong numFiles = HiveBasicStatistics.parse(parameters.get(NUM_FILES));
        OptionalLong numRows = HiveBasicStatistics.parse(parameters.get(NUM_ROWS));
        OptionalLong inMemoryDataSizeInBytes = HiveBasicStatistics.parse(parameters.get(RAW_DATA_SIZE));
        OptionalLong onDiskDataSizeInBytes = HiveBasicStatistics.parse(parameters.get(TOTAL_SIZE));
        return new HiveBasicStatistics(numFiles, numRows, inMemoryDataSizeInBytes, onDiskDataSizeInBytes);
    }

    private static OptionalLong parse(@Nullable String parameterValue) {
        if (parameterValue == null) {
            return OptionalLong.empty();
        }
        try {
            long longValue = Long.parseLong(parameterValue);
            if (longValue < 0L) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(longValue);
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
    }
}

