/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HiveBucketHandle {
    private final List<HiveColumnHandle> columns;
    private final int bucketCount;

    @JsonCreator
    public HiveBucketHandle(@JsonProperty(value="columns") List<HiveColumnHandle> columns, @JsonProperty(value="bucketCount") int bucketCount) {
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.bucketCount = Objects.requireNonNull(Integer.valueOf(bucketCount), "bucketCount is null");
    }

    @JsonProperty
    public List<HiveColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    public HiveBucketProperty toBucketProperty() {
        return new HiveBucketProperty(this.columns.stream().map(HiveColumnHandle::getName).collect(Collectors.toList()), this.bucketCount, (List<SortingColumn>)ImmutableList.of());
    }
}

