/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

final class HiveBucketing {
    private static final Set<HiveType> SUPPORTED_TYPES_FOR_BUCKET_FILTER = ImmutableSet.of((Object)HiveType.HIVE_BYTE, (Object)HiveType.HIVE_SHORT, (Object)HiveType.HIVE_INT, (Object)HiveType.HIVE_LONG, (Object)HiveType.HIVE_BOOLEAN, (Object)HiveType.HIVE_STRING, (Object[])new HiveType[0]);

    private HiveBucketing() {
    }

    public static int getHiveBucket(int bucketCount, List<TypeInfo> types, Page page, int position) {
        return (HiveBucketing.getBucketHashCode(types, page, position) & Integer.MAX_VALUE) % bucketCount;
    }

    public static int getHiveBucket(int bucketCount, List<TypeInfo> types, Object[] values) {
        return (HiveBucketing.getBucketHashCode(types, values) & Integer.MAX_VALUE) % bucketCount;
    }

    private static int getBucketHashCode(List<TypeInfo> types, Page page, int position) {
        Preconditions.checkArgument((types.size() == page.getChannelCount() ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            int fieldHash = HiveBucketing.hash(types.get(i), page.getBlock(i), position);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    private static int getBucketHashCode(List<TypeInfo> types, Object[] values) {
        Preconditions.checkArgument((types.size() == values.length ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < values.length; ++i) {
            int fieldHash = HiveBucketing.hash(types.get(i), values[i]);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    private static int hash(TypeInfo type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                Type prestoType = Objects.requireNonNull(HiveType.getPrimitiveType(typeInfo));
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return prestoType.getBoolean(block, position) ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)prestoType.getLong(block, position));
                    }
                    case SHORT: {
                        return Shorts.checkedCast((long)prestoType.getLong(block, position));
                    }
                    case INT: {
                        return Math.toIntExact(prestoType.getLong(block, position));
                    }
                    case LONG: {
                        long bigintValue = prestoType.getLong(block, position);
                        return (int)(bigintValue >>> 32 ^ bigintValue);
                    }
                    case FLOAT: {
                        return (int)prestoType.getLong(block, position);
                    }
                    case DOUBLE: {
                        long doubleValue = Double.doubleToLongBits(prestoType.getDouble(block, position));
                        return (int)(doubleValue >>> 32 ^ doubleValue);
                    }
                    case STRING: {
                        return HiveBucketing.hashBytes(0, prestoType.getSlice(block, position));
                    }
                    case VARCHAR: {
                        return HiveBucketing.hashBytes(1, prestoType.getSlice(block, position));
                    }
                    case DATE: {
                        long days = prestoType.getLong(block, position);
                        return Math.toIntExact(days);
                    }
                    case TIMESTAMP: {
                        long millisSinceEpoch = prestoType.getLong(block, position);
                        long secondsAndNanos = (Math.floorDiv(millisSinceEpoch, 1000L) << 30) + Math.floorMod(millisSinceEpoch, 1000L);
                        return (int)(secondsAndNanos >>> 32 ^ secondsAndNanos);
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory.toString() + ".");
            }
            case LIST: {
                Block elementsBlock = (Block)block.getObject(position, Block.class);
                return HiveBucketing.hashOfList((ListTypeInfo)type, elementsBlock);
            }
            case MAP: {
                Block elementsBlock = (Block)block.getObject(position, Block.class);
                return HiveBucketing.hashOfMap((MapTypeInfo)type, elementsBlock);
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory().toString() + ".");
    }

    private static int hash(TypeInfo type, Object value) {
        if (value == null) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                Type prestoType = Objects.requireNonNull(HiveType.getPrimitiveType(typeInfo));
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return (Boolean)value != false ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)((Long)value));
                    }
                    case SHORT: {
                        return Shorts.checkedCast((long)((Long)value));
                    }
                    case INT: {
                        return Math.toIntExact((Long)value);
                    }
                    case LONG: {
                        long bigintValue = (Long)value;
                        return (int)(bigintValue >>> 32 ^ bigintValue);
                    }
                    case FLOAT: {
                        return (int)((Long)value).longValue();
                    }
                    case DOUBLE: {
                        long doubleValue = Double.doubleToLongBits((Double)value);
                        return (int)(doubleValue >>> 32 ^ doubleValue);
                    }
                    case STRING: {
                        return HiveBucketing.hashBytes(0, (Slice)value);
                    }
                    case VARCHAR: {
                        return HiveBucketing.hashBytes(1, (Slice)value);
                    }
                    case DATE: {
                        long days = (Long)value;
                        return Math.toIntExact(days);
                    }
                    case TIMESTAMP: {
                        long millisSinceEpoch = (Long)value;
                        long secondsAndNanos = (Math.floorDiv(millisSinceEpoch, 1000L) << 30) + Math.floorMod(millisSinceEpoch, 1000L);
                        return (int)(secondsAndNanos >>> 32 ^ secondsAndNanos);
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory.toString() + ".");
            }
            case LIST: {
                return HiveBucketing.hashOfList((ListTypeInfo)type, (Block)value);
            }
            case MAP: {
                return HiveBucketing.hashOfMap((MapTypeInfo)type, (Block)value);
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory().toString() + ".");
    }

    private static int hashOfMap(MapTypeInfo type, Block singleMapBlock) {
        TypeInfo keyTypeInfo = type.getMapKeyTypeInfo();
        TypeInfo valueTypeInfo = type.getMapValueTypeInfo();
        int result = 0;
        for (int i = 0; i < singleMapBlock.getPositionCount(); i += 2) {
            result += HiveBucketing.hash(keyTypeInfo, singleMapBlock, i) ^ HiveBucketing.hash(valueTypeInfo, singleMapBlock, i + 1);
        }
        return result;
    }

    private static int hashOfList(ListTypeInfo type, Block singleListBlock) {
        TypeInfo elementTypeInfo = type.getListElementTypeInfo();
        int result = 0;
        for (int i = 0; i < singleListBlock.getPositionCount(); ++i) {
            result = result * 31 + HiveBucketing.hash(elementTypeInfo, singleListBlock, i);
        }
        return result;
    }

    private static int hashBytes(int initialValue, Slice bytes) {
        int result = initialValue;
        for (int i = 0; i < bytes.length(); ++i) {
            result = result * 31 + bytes.getByte(i);
        }
        return result;
    }

    public static Optional<HiveBucketHandle> getHiveBucketHandle(Table table) {
        Optional<HiveBucketProperty> hiveBucketProperty = table.getStorage().getBucketProperty();
        if (!hiveBucketProperty.isPresent()) {
            return Optional.empty();
        }
        Map map = HiveUtil.getRegularColumnHandles(table).stream().collect(Collectors.toMap(HiveColumnHandle::getName, Function.identity()));
        ImmutableList.Builder bucketColumns = ImmutableList.builder();
        for (String bucketColumnName : hiveBucketProperty.get().getBucketedBy()) {
            HiveColumnHandle bucketColumnHandle = (HiveColumnHandle)map.get(bucketColumnName);
            if (bucketColumnHandle == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s.%s' is bucketed on non-existent column '%s'", table.getDatabaseName(), table.getTableName(), bucketColumnName));
            }
            bucketColumns.add((Object)bucketColumnHandle);
        }
        return Optional.of(new HiveBucketHandle((List<HiveColumnHandle>)bucketColumns.build(), hiveBucketProperty.get().getBucketCount()));
    }

    public static Optional<HiveBucketFilter> getHiveBucketFilter(Table table, TupleDomain<ColumnHandle> effectivePredicate) {
        if (!table.getStorage().getBucketProperty().isPresent()) {
            return Optional.empty();
        }
        Optional bindings = TupleDomain.extractFixedValues(effectivePredicate);
        if (!bindings.isPresent()) {
            return Optional.empty();
        }
        OptionalInt singleBucket = HiveBucketing.getHiveBucket(table, (Map)bindings.get());
        if (singleBucket.isPresent()) {
            return Optional.of(new HiveBucketFilter((Set<Integer>)ImmutableSet.of((Object)singleBucket.getAsInt())));
        }
        if (!effectivePredicate.getDomains().isPresent()) {
            return Optional.empty();
        }
        Optional<Domain> domain = ((Map)effectivePredicate.getDomains().get()).entrySet().stream().filter(entry -> ((HiveColumnHandle)entry.getKey()).getName().equals("$bucket")).findFirst().map(Map.Entry::getValue);
        if (!domain.isPresent()) {
            return Optional.empty();
        }
        ValueSet values = domain.get().getValues();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int bucketCount = table.getStorage().getBucketProperty().get().getBucketCount();
        for (int i = 0; i < bucketCount; ++i) {
            if (!values.containsValue((Object)i)) continue;
            builder.add((Object)i);
        }
        return Optional.of(new HiveBucketFilter((Set<Integer>)builder.build()));
    }

    private static OptionalInt getHiveBucket(Table table, Map<ColumnHandle, NullableValue> bindings) {
        if (bindings.isEmpty()) {
            return OptionalInt.empty();
        }
        List<String> bucketColumns = table.getStorage().getBucketProperty().get().getBucketedBy();
        HashMap<String, HiveType> hiveTypes = new HashMap<String, HiveType>();
        for (Column column : table.getDataColumns()) {
            hiveTypes.put(column.getName(), column.getType());
        }
        for (String string : bucketColumns) {
            if (SUPPORTED_TYPES_FOR_BUCKET_FILTER.contains(hiveTypes.get(string))) continue;
            return OptionalInt.empty();
        }
        HashMap<String, Object> bucketBindings = new HashMap<String, Object>();
        for (Map.Entry<ColumnHandle, NullableValue> entry : bindings.entrySet()) {
            HiveColumnHandle colHandle = (HiveColumnHandle)entry.getKey();
            if (entry.getValue().isNull() || !bucketColumns.contains(colHandle.getName())) continue;
            bucketBindings.put(colHandle.getName(), entry.getValue().getValue());
        }
        if (bucketBindings.size() != bucketColumns.size()) {
            return OptionalInt.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        Object[] values = new Object[bucketColumns.size()];
        for (int i = 0; i < bucketColumns.size(); ++i) {
            String column = bucketColumns.get(i);
            builder.add((Object)((HiveType)hiveTypes.get(column)).getTypeInfo());
            values[i] = bucketBindings.get(column);
        }
        return OptionalInt.of(HiveBucketing.getHiveBucket(table.getStorage().getBucketProperty().get().getBucketCount(), (List<TypeInfo>)builder.build(), values));
    }

    public static class HiveBucketFilter {
        private final Set<Integer> bucketsToKeep;

        public HiveBucketFilter(@JsonProperty(value="bucketsToKeep") Set<Integer> bucketsToKeep) {
            this.bucketsToKeep = bucketsToKeep;
        }

        @JsonProperty
        public Set<Integer> getBucketsToKeep() {
            return this.bucketsToKeep;
        }
    }
}

