/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;

public class HiveLocationService
implements LocationService {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public HiveLocationService(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    @Override
    public LocationHandle forNewTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName) {
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, schemaName, tableName);
        Path targetPath = HiveWriteUtils.getTableDefaultLocation(context, metastore, this.hdfsEnvironment, schemaName, tableName);
        if (HiveWriteUtils.pathExists(context, this.hdfsEnvironment, targetPath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        if (this.shouldUseTemporaryDirectory(context, targetPath)) {
            Path writePath = HiveWriteUtils.createTemporaryPath(context, this.hdfsEnvironment, targetPath);
            return new LocationHandle(targetPath, writePath, false, LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, false, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
    }

    @Override
    public LocationHandle forExistingTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        Path targetPath;
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
        if (this.shouldUseTemporaryDirectory(context, targetPath = new Path(table.getStorage().getLocation()))) {
            Path writePath = HiveWriteUtils.createTemporaryPath(context, this.hdfsEnvironment, targetPath);
            return new LocationHandle(targetPath, writePath, true, LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, true, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY);
    }

    private boolean shouldUseTemporaryDirectory(HdfsEnvironment.HdfsContext context, Path path) {
        return !HiveWriteUtils.isS3FileSystem(context, this.hdfsEnvironment, path);
    }

    @Override
    public LocationService.WriteInfo getQueryWriteInfo(LocationHandle locationHandle) {
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getTableWriteInfo(LocationHandle locationHandle) {
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getPartitionWriteInfo(LocationHandle locationHandle, Optional<Partition> partition, String partitionName) {
        if (partition.isPresent()) {
            Path writePath;
            LocationHandle.WriteMode writeMode = locationHandle.getWriteMode();
            Path targetPath = new Path(partition.get().getStorage().getLocation());
            switch (writeMode) {
                case STAGE_AND_MOVE_TO_TARGET_DIRECTORY: {
                    writePath = new Path(locationHandle.getWritePath(), partitionName);
                    break;
                }
                case DIRECT_TO_TARGET_EXISTING_DIRECTORY: {
                    writePath = targetPath;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("inserting into existing partition is not supported for %s", new Object[]{writeMode}));
                }
            }
            return new LocationService.WriteInfo(targetPath, writePath, writeMode);
        }
        return new LocationService.WriteInfo(new Path(locationHandle.getTargetPath(), partitionName), new Path(locationHandle.getWritePath(), partitionName), locationHandle.getWriteMode());
    }
}

