/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveInputInfo;
import com.facebook.presto.hive.HiveInsertTableHandle;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HivePartitioningHandle;
import com.facebook.presto.hive.HiveSchemaProperties;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.HiveWritableTableHandle;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.HiveWriterFactory;
import com.facebook.presto.hive.HiveWrittenPartitions;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ViewAlreadyExistsException;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.PrincipalType;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.statistics.HiveStatisticsProvider;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.hive.util.Statistics;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorTablePartitioning;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.security.GrantInfo;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public class HiveMetadata
implements ConnectorMetadata {
    public static final String PRESTO_VERSION_NAME = "presto_version";
    public static final String PRESTO_QUERY_ID_NAME = "presto_query_id";
    public static final String TABLE_COMMENT = "comment";
    private static final String ORC_BLOOM_FILTER_COLUMNS_KEY = "orc.bloom.filter.columns";
    private static final String ORC_BLOOM_FILTER_FPP_KEY = "orc.bloom.filter.fpp";
    private static final String PARTITIONS_TABLE_SUFFIX = "$partitions";
    private final boolean allowCorruptWritesForTesting;
    private final SemiTransactionalHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final DateTimeZone timeZone;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final TableParameterCodec tableParameterCodec;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final TypeTranslator typeTranslator;
    private final String prestoVersion;
    private final HiveStatisticsProvider hiveStatisticsProvider;
    private final int maxPartitions;

    public HiveMetadata(SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, DateTimeZone timeZone, boolean allowCorruptWritesForTesting, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, TypeManager typeManager, LocationService locationService, TableParameterCodec tableParameterCodec, JsonCodec<PartitionUpdate> partitionUpdateCodec, TypeTranslator typeTranslator, String prestoVersion, HiveStatisticsProvider hiveStatisticsProvider, int maxPartitions) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.tableParameterCodec = Objects.requireNonNull(tableParameterCodec, "tableParameterCodec is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        this.hiveStatisticsProvider = Objects.requireNonNull(hiveStatisticsProvider, "hiveStatisticsProvider is null");
        Preconditions.checkArgument((maxPartitions >= 1 ? 1 : 0) != 0, (Object)"maxPartitions must be at least 1");
        this.maxPartitions = maxPartitions;
    }

    public SemiTransactionalHiveMetastore getMetastore() {
        return this.metastore;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases();
    }

    public HiveTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            return null;
        }
        if (HiveMetadata.isPartitionsSystemTable(tableName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unexpected table %s present in Hive metastore", tableName));
        }
        MetastoreUtil.verifyOnline(tableName, Optional.empty(), MetastoreUtil.getProtectMode(table.get()), table.get().getParameters());
        return new HiveTableHandle(tableName.getSchemaName(), tableName.getTableName());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        if (HiveMetadata.isPartitionsSystemTable(tableName)) {
            return this.getPartitionsSystemTable(session, tableName);
        }
        return Optional.empty();
    }

    private Optional<SystemTable> getPartitionsSystemTable(ConnectorSession session, final SchemaTableName tableName) {
        SchemaTableName sourceTableName = HiveMetadata.getSourceTableNameForPartitionsTable(tableName);
        final HiveTableHandle sourceTableHandle = this.getTableHandle(session, sourceTableName);
        if (sourceTableHandle == null) {
            return Optional.empty();
        }
        final List<HiveColumnHandle> partitionColumns = this.getPartitionColumns(sourceTableName);
        if (partitionColumns.isEmpty()) {
            return Optional.empty();
        }
        final List partitionColumnTypes = (List)partitionColumns.stream().map(HiveColumnHandle::getTypeSignature).map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        final List partitionSystemTableColumns = (List)partitionColumns.stream().map(column -> new ColumnMetadata(column.getName(), this.typeManager.getType(column.getTypeSignature()), (String)column.getComment().orElse(null), column.isHidden())).collect(ImmutableList.toImmutableList());
        final Map fieldIdToColumnHandle = (Map)IntStream.range(0, partitionColumns.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), partitionColumns::get));
        SystemTable partitionsSystemTable = new SystemTable(){

            public SystemTable.Distribution getDistribution() {
                return SystemTable.Distribution.SINGLE_COORDINATOR;
            }

            public ConnectorTableMetadata getTableMetadata() {
                return new ConnectorTableMetadata(tableName, partitionSystemTableColumns);
            }

            public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
                TupleDomain targetTupleDomain = constraint.transform(fieldIdToColumnHandle::get);
                Predicate<Map<ColumnHandle, NullableValue>> targetPredicate = HiveMetadata.convertToPredicate((TupleDomain<ColumnHandle>)targetTupleDomain);
                Constraint targetConstraint = new Constraint(targetTupleDomain, targetPredicate);
                Iterable records = () -> Streams.stream(HiveMetadata.this.partitionManager.getPartitions(HiveMetadata.this.metastore, sourceTableHandle, (Constraint<ColumnHandle>)targetConstraint).getPartitions()).map(hivePartition -> IntStream.range(0, partitionColumns.size()).mapToObj(fieldIdToColumnHandle::get).map(columnHandle -> hivePartition.getKeys().get(columnHandle).getValue()).collect(Collectors.toList())).iterator();
                return new InMemoryRecordSet((Collection)partitionColumnTypes, records).cursor();
            }
        };
        return Optional.of(partitionsSystemTable);
    }

    private List<HiveColumnHandle> getPartitionColumns(SchemaTableName tableName) {
        Table sourceTable = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).get();
        return HiveUtil.getPartitionKeyColumnHandles(sourceTable);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        return this.getTableMetadata(tableName);
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        String orcBloomFilterFfp;
        String orcBloomFilterColumns;
        Optional<HiveBucketProperty> bucketProperty;
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent() || table.get().getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new TableNotFoundException(tableName);
        }
        Function<HiveColumnHandle, ColumnMetadata> metadataGetter = HiveMetadata.columnMetadataGetter(table.get(), this.typeManager);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(table.get())) {
            columns.add((Object)metadataGetter.apply(columnHandle));
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        if (table.get().getTableType().equals(TableType.EXTERNAL_TABLE.name())) {
            properties.put((Object)"external_location", (Object)table.get().getStorage().getLocation());
        }
        try {
            HiveStorageFormat format = HiveMetadata.extractHiveStorageFormat(table.get());
            properties.put((Object)"format", (Object)format);
        }
        catch (PrestoException format) {
            // empty catch block
        }
        List partitionedBy = table.get().getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
        if (!partitionedBy.isEmpty()) {
            properties.put((Object)"partitioned_by", partitionedBy);
        }
        if ((bucketProperty = table.get().getStorage().getBucketProperty()).isPresent()) {
            properties.put((Object)"bucket_count", (Object)bucketProperty.get().getBucketCount());
            properties.put((Object)"bucketed_by", bucketProperty.get().getBucketedBy());
            properties.put((Object)"sorted_by", bucketProperty.get().getSortedBy());
        }
        if ((orcBloomFilterColumns = table.get().getParameters().get(ORC_BLOOM_FILTER_COLUMNS_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_columns", (Object)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)orcBloomFilterColumns));
        }
        if ((orcBloomFilterFfp = table.get().getParameters().get(ORC_BLOOM_FILTER_FPP_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_fpp", (Object)Double.parseDouble(orcBloomFilterFfp));
        }
        properties.putAll(this.tableParameterCodec.decode(table.get().getParameters()));
        Optional<String> comment = Optional.ofNullable(table.get().getParameters().get(TABLE_COMMENT));
        return new ConnectorTableMetadata(tableName, (List)columns.build(), (Map)properties.build(), comment);
    }

    public Optional<Object> getInfo(ConnectorTableLayoutHandle layoutHandle) {
        HiveTableLayoutHandle tableLayoutHandle = (HiveTableLayoutHandle)layoutHandle;
        if (tableLayoutHandle.getPartitions().isPresent()) {
            return Optional.of(new HiveInputInfo(tableLayoutHandle.getPartitions().get().stream().map(HivePartition::getPartitionId).collect(Collectors.toList()), false));
        }
        return Optional.empty();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            for (String tableName : this.metastore.getAllTables(schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames(session);
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(table.get())) {
            columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (HiveViewNotSupportedException hiveViewNotSupportedException) {
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint) {
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.EMPTY_STATISTICS;
        }
        List<HivePartition> hivePartitions = this.getPartitionsAsList(tableHandle, constraint);
        Map tableColumns = (Map)this.getColumnHandles(session, tableHandle).entrySet().stream().filter(entry -> !((HiveColumnHandle)entry.getValue()).isHidden()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.hiveStatisticsProvider.getTableStatistics(session, tableHandle, hivePartitions, tableColumns);
    }

    private List<HivePartition> getPartitionsAsList(ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint) {
        HivePartitionResult partitions = this.partitionManager.getPartitions(this.metastore, tableHandle, constraint);
        return this.getPartitionsAsList(partitions);
    }

    private List<HivePartition> getPartitionsAsList(HivePartitionResult partitions) {
        ImmutableList.Builder partitionList = ImmutableList.builder();
        int count = 0;
        Iterator<HivePartition> iterator = partitions.getPartitions();
        while (iterator.hasNext()) {
            HivePartition partition = iterator.next();
            if (count == this.maxPartitions) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_EXCEEDED_PARTITION_LIMIT, String.format("Query over table '%s' can potentially read more than %s partitions", partition.getTableName(), this.maxPartitions));
            }
            partitionList.add((Object)partition);
            ++count;
        }
        return partitionList.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null || prefix.getTableName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getColumnMetadata(this.typeManager);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        Optional<String> location = HiveSchemaProperties.getLocation(properties).map(locationUri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, schemaName), new Path(locationUri));
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + locationUri, (Throwable)e);
            }
            return locationUri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(PrincipalType.USER).setOwnerName(session.getUser()).build();
        this.metastore.createDatabase(database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.listTables(session, schemaName).isEmpty() || !this.listViews(session, schemaName).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        this.metastore.dropDatabase(schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(source, target);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Path targetPath;
        boolean external;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy), this.typeTranslator);
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, !partitionedBy.isEmpty());
        hiveStorageFormat.validateColumns(columnHandles);
        String externalLocation = HiveTableProperties.getExternalLocation(tableMetadata.getProperties());
        if (externalLocation != null) {
            if (!this.createsOfNonManagedTablesEnabled) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot create non-managed Hive table");
            }
            external = true;
            targetPath = this.getExternalPath(new HdfsEnvironment.HdfsContext(session, schemaName, tableName), externalLocation);
        } else {
            external = false;
            LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName);
            targetPath = this.locationService.getQueryWriteInfo(locationHandle).getTargetPath();
        }
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), schemaName, tableName, session.getUser(), columnHandles, hiveStorageFormat, partitionedBy, bucketProperty, tableProperties, targetPath, external, this.prestoVersion);
        PrincipalPrivileges principalPrivileges = HiveMetadata.buildInitialPrivilegeSet(table.getOwner());
        this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), ignoreExisting);
    }

    private Map<String, String> getEmptyTableProperties(ConnectorTableMetadata tableMetadata, boolean partitioned) {
        ImmutableMap.Builder tableProperties = ImmutableMap.builder();
        tableProperties.putAll(this.tableParameterCodec.encode(tableMetadata.getProperties()));
        List<String> columns = HiveTableProperties.getOrcBloomFilterColumns(tableMetadata.getProperties());
        if (columns != null && !columns.isEmpty()) {
            tableProperties.put((Object)ORC_BLOOM_FILTER_COLUMNS_KEY, (Object)Joiner.on((String)",").join(columns));
            tableProperties.put((Object)ORC_BLOOM_FILTER_FPP_KEY, (Object)String.valueOf(HiveTableProperties.getOrcBloomFilterFpp(tableMetadata.getProperties())));
        }
        tableMetadata.getComment().ifPresent(value -> tableProperties.put((Object)TABLE_COMMENT, value));
        if (!partitioned) {
            tableProperties.putAll(HiveBasicStatistics.createZeroStatistics().toPartitionParameters());
        }
        return tableProperties.build();
    }

    private Path getExternalPath(HdfsEnvironment.HdfsContext context, String location) {
        try {
            Path path = new Path(location);
            if (!this.hdfsEnvironment.getFileSystem(context, path).isDirectory(path)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location must be a directory");
            }
            return path;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location is not a valid file system URI", (Throwable)e);
        }
    }

    private static Table buildTableObject(String queryId, String schemaName, String tableName, String tableOwner, List<HiveColumnHandle> columnHandles, HiveStorageFormat hiveStorageFormat, List<String> partitionedBy, Optional<HiveBucketProperty> bucketProperty, Map<String, String> additionalTableParameters, Path targetPath, boolean external, String prestoVersion) {
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(partitionedBy);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : columnHandles) {
            String name = columnHandle.getName();
            HiveType type = columnHandle.getHiveType();
            if (!partitionColumnNames.contains(name)) {
                Verify.verify((!columnHandle.isPartitionKey() ? 1 : 0) != 0, (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
                columns.add((Object)new Column(name, type, columnHandle.getComment()));
                continue;
            }
            Verify.verify((boolean)columnHandle.isPartitionKey(), (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
        }
        ImmutableMap.Builder tableParameters = ImmutableMap.builder().put((Object)PRESTO_VERSION_NAME, (Object)prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)queryId).putAll(additionalTableParameters);
        if (external) {
            tableParameters.put((Object)"EXTERNAL", (Object)"TRUE");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(tableOwner).setTableType((external ? TableType.EXTERNAL_TABLE : TableType.MANAGED_TABLE).name()).setDataColumns((List<Column>)columns.build()).setPartitionColumns(partitionColumns).setParameters((Map<String, String>)tableParameters.build());
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat(hiveStorageFormat)).setBucketProperty(bucketProperty).setLocation(targetPath.toString());
        return tableBuilder.build();
    }

    private static PrincipalPrivileges buildInitialPrivilegeSet(String tableOwner) {
        return new PrincipalPrivileges((Multimap<String, HivePrivilegeInfo>)ImmutableMultimap.builder().put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, true)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, true)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, true)).build(), (Multimap<String, HivePrivilegeInfo>)ImmutableMultimap.of());
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.metastore.addColumn(handle.getSchemaName(), handle.getTableName(), column.getName(), HiveType.toHiveType(this.typeTranslator, column.getType()), column.getComment());
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        HiveColumnHandle sourceHandle = (HiveColumnHandle)source;
        this.metastore.renameColumn(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), sourceHandle.getName(), target);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        HiveColumnHandle columnHandle = (HiveColumnHandle)column;
        this.metastore.dropColumn(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), columnHandle.getName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.metastore.renameTable(handle.getSchemaName(), handle.getTableName(), newTableName.getSchemaName(), newTableName.getTableName());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional<Table> target = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.verifyJvmTimeZone();
        if (HiveTableProperties.getExternalLocation(tableMetadata.getProperties()) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "External tables cannot be created using CREATE TABLE AS");
        }
        HiveStorageFormat tableStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, !partitionedBy.isEmpty());
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy), this.typeTranslator);
        HiveStorageFormat partitionStorageFormat = HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session);
        HiveStorageFormat actualStorageFormat = partitionedBy.isEmpty() ? tableStorageFormat : partitionStorageFormat;
        actualStorageFormat.validateColumns(columnHandles);
        LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName);
        HiveOutputTableHandle result = new HiveOutputTableHandle(schemaName, tableName, columnHandles, session.getQueryId(), this.metastore.generatePageSinkMetadata(schemaTableName), locationHandle, tableStorageFormat, partitionStorageFormat, partitionedBy, bucketProperty, session.getUser(), tableProperties);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), result.getFilePrefix(), schemaTableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(Collectors.toList());
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(handle.getLocationHandle());
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), handle.getSchemaName(), handle.getTableName(), handle.getTableOwner(), handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionedBy(), handle.getBucketProperty(), handle.getAdditionalTableParameters(), writeInfo.getTargetPath(), false, this.prestoVersion);
        PrincipalPrivileges principalPrivileges = HiveMetadata.buildInitialPrivilegeSet(handle.getTableOwner());
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        if (handle.getBucketProperty().isPresent()) {
            ImmutableList<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, table, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table, partitionUpdate));
                this.createEmptyFile(session, partitionUpdate.getWritePath(), table, partition, partitionUpdate.getFileNames());
            }
        }
        if (table.getPartitionColumns().isEmpty()) {
            HiveBasicStatistics tableStatistic = partitionUpdates.stream().map(PartitionUpdate::getStatistics).reduce(Statistics::add).orElse(HiveBasicStatistics.createZeroStatistics());
            table = Statistics.updateStatistics(table, tableStatistic, Statistics.ReduceOperator.ADD);
        }
        this.metastore.createTable(session, table, principalPrivileges, Optional.of(writeInfo.getWritePath()), false);
        if (!handle.getPartitionedBy().isEmpty()) {
            if (HiveSessionProperties.isRespectTableFormat(session)) {
                Verify.verify((handle.getPartitionStorageFormat() == handle.getTableStorageFormat() ? 1 : 0) != 0);
            }
            for (PartitionUpdate update : partitionUpdates) {
                this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), this.buildPartitionObject(session, table, update), update.getWritePath());
            }
        }
        return Optional.of(new HiveWrittenPartitions(partitionUpdates.stream().map(PartitionUpdate::getName).collect(Collectors.toList())));
    }

    private ImmutableList<PartitionUpdate> computePartitionUpdatesForMissingBuckets(ConnectorSession session, HiveWritableTableHandle handle, Table table, List<PartitionUpdate> partitionUpdates) {
        ImmutableList.Builder partitionUpdatesForMissingBucketsBuilder = ImmutableList.builder();
        HiveStorageFormat storageFormat = table.getPartitionColumns().isEmpty() ? handle.getTableStorageFormat() : handle.getPartitionStorageFormat();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            int bucketCount = handle.getBucketProperty().get().getBucketCount();
            List<String> fileNamesForMissingBuckets = this.computeFileNamesForMissingBuckets(session, table, storageFormat, partitionUpdate.getTargetPath(), handle.getFilePrefix(), bucketCount, partitionUpdate);
            partitionUpdatesForMissingBucketsBuilder.add((Object)new PartitionUpdate(partitionUpdate.getName(), partitionUpdate.isNew(), partitionUpdate.getWritePath(), partitionUpdate.getTargetPath(), fileNamesForMissingBuckets, 0L, 0L, 0L));
        }
        return partitionUpdatesForMissingBucketsBuilder.build();
    }

    private List<String> computeFileNamesForMissingBuckets(ConnectorSession session, Table table, HiveStorageFormat storageFormat, Path targetPath, String filePrefix, int bucketCount, PartitionUpdate partitionUpdate) {
        if (partitionUpdate.getFileNames().size() == bucketCount) {
            return ImmutableList.of();
        }
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
        JobConf conf = ConfigurationUtils.toJobConf(this.hdfsEnvironment.getConfiguration(hdfsContext, targetPath));
        String fileExtension = HiveWriterFactory.getFileExtension(conf, StorageFormat.fromHiveStorageFormat(storageFormat));
        ImmutableSet fileNames = ImmutableSet.copyOf(partitionUpdate.getFileNames());
        ImmutableList.Builder missingFileNamesBuilder = ImmutableList.builder();
        for (int i = 0; i < bucketCount; ++i) {
            String fileName = HiveWriterFactory.computeBucketedFileName(filePrefix, i) + fileExtension;
            if (fileNames.contains(fileName)) continue;
            missingFileNamesBuilder.add((Object)fileName);
        }
        ImmutableList missingFileNames = missingFileNamesBuilder.build();
        Verify.verify((fileNames.size() + missingFileNames.size() == bucketCount ? 1 : 0) != 0);
        return missingFileNames;
    }

    private void createEmptyFile(ConnectorSession session, Path path, Table table, Optional<Partition> partition, List<String> fileNames) {
        StorageFormat format;
        Properties schema;
        JobConf conf = ConfigurationUtils.toJobConf(this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName()), path));
        if (partition.isPresent()) {
            schema = MetastoreUtil.getHiveSchema(partition.get(), table);
            format = partition.get().getStorage().getStorageFormat();
        } else {
            schema = MetastoreUtil.getHiveSchema(table);
            format = table.getStorage().getStorageFormat();
        }
        for (String fileName : fileNames) {
            HiveMetadata.writeEmptyFile(new Path(path, fileName), conf, schema, format.getSerDe(), format.getOutputFormat());
        }
    }

    private static void writeEmptyFile(Path target, JobConf conf, Properties properties, String serDe, String outputFormatName) {
        HiveWriteUtils.initializeSerializer((Configuration)conf, properties, serDe);
        FileSinkOperator.RecordWriter recordWriter = HiveWriteUtils.createRecordWriter(target, conf, properties, outputFormatName);
        try {
            recordWriter.close(false);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error write empty file to Hive", (Throwable)e);
        }
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.verifyJvmTimeZone();
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        HiveWriteUtils.checkTableIsWritable(table.get(), this.writesToNonManagedTablesEnabled);
        for (Column column : table.get().getDataColumns()) {
            if (HiveWriteUtils.isWritableType(column.getType())) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table %s.%s with column type %s not supported", table.get().getDatabaseName(), table.get().getTableName(), column.getType()));
        }
        List<HiveColumnHandle> handles = HiveUtil.hiveColumnHandles(table.get()).stream().filter(columnHandle -> !columnHandle.isHidden()).collect(Collectors.toList());
        HiveStorageFormat tableStorageFormat = HiveMetadata.extractHiveStorageFormat(table.get());
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table.get());
        HiveInsertTableHandle result = new HiveInsertTableHandle(tableName.getSchemaName(), tableName.getTableName(), handles, session.getQueryId(), this.metastore.generatePageSinkMetadata(tableName), locationHandle, table.get().getStorage().getBucketProperty(), tableStorageFormat, HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session));
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), result.getFilePrefix(), tableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)insertHandle;
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(Collectors.toList());
        HiveStorageFormat tableStorageFormat = handle.getTableStorageFormat();
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        Optional<Table> table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
        }
        if (!table.get().getStorage().getStorageFormat().getInputFormat().equals(tableStorageFormat.getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during insert");
        }
        if (handle.getBucketProperty().isPresent()) {
            ImmutableList<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, table.get(), partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = table.get().getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table.get(), partitionUpdate));
                this.createEmptyFile(session, partitionUpdate.getWritePath(), table.get(), partition, partitionUpdate.getFileNames());
            }
        }
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            if (partitionUpdate.getName().isEmpty()) {
                this.metastore.finishInsertIntoExistingTable(session, handle.getSchemaName(), handle.getTableName(), partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionUpdate.getStatistics());
                continue;
            }
            if (!partitionUpdate.isNew()) {
                this.metastore.finishInsertIntoExistingPartition(session, handle.getSchemaName(), handle.getTableName(), HiveUtil.toPartitionValues(partitionUpdate.getName()), partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionUpdate.getStatistics());
                continue;
            }
            Partition partition = this.buildPartitionObject(session, table.get(), partitionUpdate);
            if (!partition.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Partition format changed during insert");
            }
            this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), partition, partitionUpdate.getWritePath());
        }
        return Optional.of(new HiveWrittenPartitions(partitionUpdates.stream().map(PartitionUpdate::getName).collect(Collectors.toList())));
    }

    private Partition buildPartitionObject(ConnectorSession session, Table table, PartitionUpdate partitionUpdate) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HivePartitionManager.extractPartitionKeyValues(partitionUpdate.getName())).setParameters((Map<String, String>)ImmutableMap.builder().put((Object)PRESTO_VERSION_NAME, (Object)this.prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).putAll(partitionUpdate.getStatistics().toPartitionParameters()).build()).withStorage(storage -> storage.setStorageFormat(HiveSessionProperties.isRespectTableFormat(session) ? table.getStorage().getStorageFormat() : StorageFormat.fromHiveStorageFormat(HiveSessionProperties.getHiveStorageFormat(session))).setLocation(partitionUpdate.getTargetPath().toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        ImmutableMap properties = ImmutableMap.builder().put((Object)TABLE_COMMENT, (Object)"Presto View").put((Object)"presto_view", (Object)"true").put((Object)PRESTO_VERSION_NAME, (Object)this.prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).build();
        Column dummyColumn = new Column("dummy", HiveType.HIVE_STRING, Optional.empty());
        Table.Builder tableBuilder = Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(session.getUser()).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List<Column>)ImmutableList.of((Object)dummyColumn)).setPartitionColumns((List<Column>)ImmutableList.of()).setParameters((Map<String, String>)properties).setViewOriginalText(Optional.of(HiveUtil.encodeViewData(viewData))).setViewExpandedText(Optional.of("/* Presto View */"));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("");
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = HiveMetadata.buildInitialPrivilegeSet(session.getUser());
        Optional<Table> existing = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !HiveUtil.isPrestoView(existing.get())) {
                throw new ViewAlreadyExistsException(viewName);
            }
            this.metastore.replaceView(viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), false);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorViewDefinition view = this.getViews(session, viewName.toSchemaTablePrefix()).get(viewName);
        if (view == null) {
            throw new ViewNotFoundException(viewName);
        }
        try {
            this.metastore.dropTable(session, viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            for (String tableName : this.metastore.getAllViews(schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getTableName() != null ? ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName())) : this.listViews(session, prefix.getSchemaName());
        for (SchemaTableName schemaTableName : tableNames) {
            Optional<Table> table = this.metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
            if (!table.isPresent() || !HiveUtil.isPrestoView(table.get())) continue;
            views.put((Object)schemaTableName, (Object)new ConnectorViewDefinition(schemaTableName, Optional.ofNullable(table.get().getOwner()), HiveUtil.decodeViewData(table.get().getViewOriginalText().get())));
        }
        return views.build();
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more partitions are deleted entirely");
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return HiveColumnHandle.updateRowIdHandle();
    }

    public OptionalLong metadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)tableLayoutHandle;
        Optional<Table> table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        if (table.get().getPartitionColumns().isEmpty()) {
            this.metastore.truncateUnpartitionedTable(session, handle.getSchemaName(), handle.getTableName());
        } else {
            for (HivePartition hivePartition : this.getOrComputePartitions(layoutHandle, session, tableHandle)) {
                this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), HiveUtil.toPartitionValues(hivePartition.getPartitionId()));
            }
        }
        return OptionalLong.empty();
    }

    private List<HivePartition> getOrComputePartitions(HiveTableLayoutHandle layoutHandle, ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (layoutHandle.getPartitions().isPresent()) {
            return layoutHandle.getPartitions().get();
        }
        TupleDomain<ColumnHandle> promisedPredicate = layoutHandle.getPromisedPredicate();
        Predicate<Map<ColumnHandle, NullableValue>> predicate = HiveMetadata.convertToPredicate(promisedPredicate);
        List<ConnectorTableLayoutResult> tableLayoutResults = this.getTableLayouts(session, tableHandle, (Constraint<ColumnHandle>)new Constraint(promisedPredicate, predicate), Optional.empty());
        return ((HiveTableLayoutHandle)((ConnectorTableLayoutResult)Iterables.getOnlyElement(tableLayoutResults)).getTableLayout().getHandle()).getPartitions().get();
    }

    @VisibleForTesting
    static Predicate<Map<ColumnHandle, NullableValue>> convertToPredicate(TupleDomain<ColumnHandle> tupleDomain) {
        return bindings -> tupleDomain.contains(TupleDomain.fromFixedValues((Map)bindings));
    }

    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        return true;
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        HivePartitionResult hivePartitionResult = this.partitionManager.getPartitions(this.metastore, tableHandle, constraint);
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(this.getTableLayout(session, new HiveTableLayoutHandle(handle.getSchemaTableName(), (List<ColumnHandle>)ImmutableList.copyOf(hivePartitionResult.getPartitionColumns()), this.getPartitionsAsList(hivePartitionResult), hivePartitionResult.getCompactEffectivePredicate(), hivePartitionResult.getEnforcedConstraint(), hivePartitionResult.getBucketHandle(), hivePartitionResult.getBucketFilter())), hivePartitionResult.getUnenforcedConstraint()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle layoutHandle) {
        HiveTableLayoutHandle hiveLayoutHandle = (HiveTableLayoutHandle)layoutHandle;
        List<ColumnHandle> partitionColumns = hiveLayoutHandle.getPartitionColumns();
        List<HivePartition> partitions = hiveLayoutHandle.getPartitions().get();
        TupleDomain<ColumnHandle> predicate = HiveMetadata.createPredicate(partitionColumns, partitions);
        Optional<Object> discretePredicates = Optional.empty();
        if (!partitionColumns.isEmpty()) {
            Iterable partitionDomains = Iterables.transform(partitions, hivePartition -> TupleDomain.fromFixedValues(hivePartition.getKeys()));
            discretePredicates = Optional.of(new DiscretePredicates(partitionColumns, partitionDomains));
        }
        Optional<Object> nodePartitioning = Optional.empty();
        if (HiveSessionProperties.isBucketExecutionEnabled(session) && hiveLayoutHandle.getBucketHandle().isPresent()) {
            nodePartitioning = hiveLayoutHandle.getBucketHandle().map(hiveBucketHandle -> new ConnectorTablePartitioning((ConnectorPartitioningHandle)new HivePartitioningHandle(hiveBucketHandle.getBucketCount(), hiveBucketHandle.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(Collectors.toList())), hiveBucketHandle.getColumns().stream().map(ColumnHandle.class::cast).collect(Collectors.toList())));
        }
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)hiveLayoutHandle, Optional.empty(), predicate, nodePartitioning, Optional.empty(), discretePredicates, (List)ImmutableList.of());
    }

    @VisibleForTesting
    static TupleDomain<ColumnHandle> createPredicate(List<ColumnHandle> partitionColumns, List<HivePartition> partitions) {
        if (partitions.isEmpty()) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(partitionColumns.stream().collect(Collectors.toMap(Function.identity(), column -> HiveMetadata.buildColumnDomain(column, partitions))));
    }

    private static Domain buildColumnDomain(ColumnHandle column, List<HivePartition> partitions) {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"partitions cannot be empty");
        boolean hasNull = false;
        ArrayList<Object> nonNullValues = new ArrayList<Object>();
        Type type = null;
        for (HivePartition partition : partitions) {
            NullableValue value = partition.getKeys().get(column);
            if (value == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, String.format("Partition %s does not have a value for partition column %s", partition, column));
            }
            if (value.isNull()) {
                hasNull = true;
            } else {
                nonNullValues.add(value.getValue());
            }
            if (type != null) continue;
            type = value.getType();
        }
        if (!nonNullValues.isEmpty()) {
            Domain domain = Domain.multipleValues(type, nonNullValues);
            if (hasNull) {
                return domain.union(Domain.onlyNull(type));
            }
            return domain;
        }
        return Domain.onlyNull(type);
    }

    public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(table);
        if (!hiveBucketHandle.isPresent()) {
            return Optional.empty();
        }
        HiveBucketProperty bucketProperty = table.getStorage().getBucketProperty().orElseThrow(() -> new NoSuchElementException("Bucket property should be set"));
        if (!bucketProperty.getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(hiveBucketHandle.get().getBucketCount(), hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getHiveType).collect(Collectors.toList()));
        List partitionColumns = hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getName).collect(Collectors.toList());
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionColumns));
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (!bucketProperty.isPresent()) {
            return Optional.empty();
        }
        if (!bucketProperty.get().getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        List<String> bucketedBy = bucketProperty.get().getBucketedBy();
        Map<String, HiveType> hiveTypeMap = tableMetadata.getColumns().stream().collect(Collectors.toMap(ColumnMetadata::getName, column -> HiveType.toHiveType(this.typeTranslator, column.getType())));
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)new HivePartitioningHandle(bucketProperty.get().getBucketCount(), bucketedBy.stream().map(hiveTypeMap::get).collect(Collectors.toList())), bucketedBy));
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Set<HivePrivilegeInfo> hivePrivilegeInfos = privileges.stream().map(privilege -> new HivePrivilegeInfo(HivePrivilegeInfo.toHivePrivilege(privilege), grantOption)).collect(Collectors.toSet());
        this.metastore.grantTablePrivileges(schemaName, tableName, grantee, hivePrivilegeInfos);
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Set<HivePrivilegeInfo> hivePrivilegeInfos = privileges.stream().map(privilege -> new HivePrivilegeInfo(HivePrivilegeInfo.toHivePrivilege(privilege), grantOption)).collect(Collectors.toSet());
        this.metastore.revokeTablePrivileges(schemaName, tableName, grantee, hivePrivilegeInfos);
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix schemaTablePrefix) {
        ImmutableList.Builder grantInfos = ImmutableList.builder();
        for (SchemaTableName tableName : this.listTables(session, schemaTablePrefix)) {
            Set privileges = (Set)this.metastore.getTablePrivileges(session.getUser(), tableName.getSchemaName(), tableName.getTableName()).stream().map(HivePrivilegeInfo::toPrivilegeInfo).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
            grantInfos.add((Object)new GrantInfo(privileges, session.getIdentity(), tableName, Optional.empty(), Optional.empty()));
        }
        return grantInfos.build();
    }

    private void verifyJvmTimeZone() {
        if (!this.allowCorruptWritesForTesting && !this.timeZone.equals((Object)DateTimeZone.getDefault())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TIMEZONE_MISMATCH, String.format("To write Hive data, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments.", this.timeZone.getID()));
        }
    }

    private static HiveStorageFormat extractHiveStorageFormat(Table table) {
        StorageFormat storageFormat = table.getStorage().getStorageFormat();
        String outputFormat = storageFormat.getOutputFormat();
        String serde = storageFormat.getSerDe();
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (!format.getOutputFormat().equals(outputFormat) || !format.getSerDe().equals(serde)) continue;
            return format;
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Output format %s with SerDe %s is not supported", outputFormat, serde));
    }

    private static void validateBucketColumns(ConnectorTableMetadata tableMetadata) {
        List<String> bucketedBy;
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (!bucketProperty.isPresent()) {
            return;
        }
        Set allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toSet());
        if (!allColumns.containsAll(bucketedBy = bucketProperty.get().getBucketedBy())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Bucketing columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(bucketedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        List sortedBy = (List)bucketProperty.get().getSortedBy().stream().map(SortingColumn::getColumnName).collect(ImmutableList.toImmutableList());
        if (!allColumns.containsAll(sortedBy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Sorting columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf((Collection)sortedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
    }

    private static void validatePartitionColumns(ConnectorTableMetadata tableMetadata) {
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        List allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        if (!allColumns.containsAll(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Partition columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(partitionedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        if (allColumns.size() == partitionedBy.size()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Table contains only partition columns");
        }
        if (!allColumns.subList(allColumns.size() - partitionedBy.size(), allColumns.size()).equals(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_COLUMN_ORDER_MISMATCH, "Partition keys must be the last columns in the table and in the same order as the table properties: " + partitionedBy);
        }
    }

    private static List<HiveColumnHandle> getColumnHandles(ConnectorTableMetadata tableMetadata, Set<String> partitionColumnNames, TypeTranslator typeTranslator) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        int ordinal = 0;
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            HiveColumnHandle.ColumnType columnType = partitionColumnNames.contains(column.getName()) ? HiveColumnHandle.ColumnType.PARTITION_KEY : (column.isHidden() ? HiveColumnHandle.ColumnType.SYNTHESIZED : HiveColumnHandle.ColumnType.REGULAR);
            columnHandles.add((Object)new HiveColumnHandle(column.getName(), HiveType.toHiveType(typeTranslator, column.getType()), column.getType().getTypeSignature(), ordinal, columnType, Optional.ofNullable(column.getComment())));
            ++ordinal;
        }
        return columnHandles.build();
    }

    private static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter(Table table, TypeManager typeManager) {
        ImmutableList.Builder columnNames = ImmutableList.builder();
        table.getPartitionColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        table.getDataColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        ImmutableList allColumnNames = columnNames.build();
        if (allColumnNames.size() > Sets.newHashSet((Iterable)allColumnNames).size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Hive metadata for table %s is invalid: Table descriptor contains duplicate columns", table.getTableName()));
        }
        List<Column> tableColumns = table.getDataColumns();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Column field : Iterables.concat(tableColumns, table.getPartitionColumns())) {
            if (field.getComment() != null && !Optional.of("from deserializer").equals(field.getComment())) {
                builder.put((Object)field.getName(), field.getComment());
                continue;
            }
            builder.put((Object)field.getName(), Optional.empty());
        }
        builder.put((Object)"$path", Optional.empty());
        if (table.getStorage().getBucketProperty().isPresent()) {
            builder.put((Object)"$bucket", Optional.empty());
        }
        ImmutableMap columnComment = builder.build();
        return arg_0 -> HiveMetadata.lambda$columnMetadataGetter$16(typeManager, (Map)columnComment, arg_0);
    }

    public void rollback() {
        this.metastore.rollback();
    }

    public void commit() {
        this.metastore.commit();
    }

    public static boolean isPartitionsSystemTable(SchemaTableName tableName) {
        return tableName.getTableName().endsWith(PARTITIONS_TABLE_SUFFIX) && tableName.getTableName().length() > PARTITIONS_TABLE_SUFFIX.length();
    }

    public static SchemaTableName getSourceTableNameForPartitionsTable(SchemaTableName tableName) {
        Preconditions.checkArgument((boolean)HiveMetadata.isPartitionsSystemTable(tableName), (Object)"not a partitions table name");
        return new SchemaTableName(tableName.getSchemaName(), tableName.getTableName().substring(0, tableName.getTableName().length() - PARTITIONS_TABLE_SUFFIX.length()));
    }

    private static /* synthetic */ ColumnMetadata lambda$columnMetadataGetter$16(TypeManager typeManager, Map columnComment, HiveColumnHandle handle) {
        return new ColumnMetadata(handle.getName(), typeManager.getType(handle.getTypeSignature()), (String)((Optional)columnComment.get(handle.getName())).orElse(null), HiveUtil.columnExtraInfo(handle.isPartitionKey()), handle.isHidden());
    }
}

