/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketFunction;
import com.facebook.presto.hive.HivePartitionHandle;
import com.facebook.presto.hive.HivePartitioningHandle;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class HiveNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeManager nodeManager;

    @Inject
    public HiveNodePartitioningProvider(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        List<HiveType> hiveTypes = handle.getHiveTypes();
        return new HiveBucketFunction(bucketCount, hiveTypes);
    }

    public Map<Integer, Node> getBucketToNode(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        List nodes = HiveNodePartitioningProvider.shuffle(this.nodeManager.getRequiredWorkerNodes());
        int bucketCount = handle.getBucketCount();
        ImmutableMap.Builder distribution = ImmutableMap.builder();
        for (int i = 0; i < bucketCount; ++i) {
            distribution.put((Object)i, nodes.get(i % nodes.size()));
        }
        return distribution.build();
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((HiveSplit)value).getBucketNumber().getAsInt();
    }

    public List<ConnectorPartitionHandle> listPartitionHandles(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        int bucketCount = handle.getBucketCount();
        return (List)IntStream.range(0, bucketCount).mapToObj(HivePartitionHandle::new).collect(ImmutableList.toImmutableList());
    }

    private static <T> List<T> shuffle(Collection<T> items) {
        ArrayList<T> list = new ArrayList<T>(items);
        Collections.shuffle(list);
        return list;
    }
}

