/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.ColumnarArray;
import com.facebook.presto.spi.block.ColumnarMap;
import com.facebook.presto.spi.block.ColumnarRow;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.RowBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.joda.time.DateTimeZone;

public class HivePageSource
implements ConnectorPageSource {
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Optional<BucketAdapter> bucketAdapter;
    private final Object[] prefilledValues;
    private final Type[] types;
    private final Function<Block, Block>[] coercers;
    private final ConnectorPageSource delegate;

    public HivePageSource(List<HivePageSourceProvider.ColumnMapping> columnMappings, Optional<HivePageSourceProvider.BucketAdaptation> bucketAdaptation, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, ConnectorPageSource delegate) {
        Objects.requireNonNull(columnMappings, "columnMappings is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        this.bucketAdapter = bucketAdaptation.map(BucketAdapter::new);
        int size = columnMappings.size();
        this.prefilledValues = new Object[size];
        this.types = new Type[size];
        this.coercers = new Function[size];
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            Comparable<Boolean> prefilledValue;
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            HiveColumnHandle column = columnMapping.getHiveColumnHandle();
            String name = column.getName();
            this.types[columnIndex] = type = typeManager.getType(column.getTypeSignature());
            if (columnMapping.getCoercionFrom().isPresent()) {
                this.coercers[columnIndex] = HivePageSource.createCoercer(typeManager, columnMapping.getCoercionFrom().get(), columnMapping.getHiveColumnHandle().getHiveType());
            }
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.PREFILLED) continue;
            String columnValue = columnMapping.getPrefilledValue();
            byte[] bytes = columnValue.getBytes(StandardCharsets.UTF_8);
            if (HiveUtil.isHiveNull(bytes)) {
                prefilledValue = null;
            } else if (type.equals(BooleanType.BOOLEAN)) {
                prefilledValue = HiveUtil.booleanPartitionKey(columnValue, name);
            } else if (type.equals(BigintType.BIGINT)) {
                prefilledValue = HiveUtil.bigintPartitionKey(columnValue, name);
            } else if (type.equals(IntegerType.INTEGER)) {
                prefilledValue = HiveUtil.integerPartitionKey(columnValue, name);
            } else if (type.equals(SmallintType.SMALLINT)) {
                prefilledValue = HiveUtil.smallintPartitionKey(columnValue, name);
            } else if (type.equals(TinyintType.TINYINT)) {
                prefilledValue = HiveUtil.tinyintPartitionKey(columnValue, name);
            } else if (type.equals(RealType.REAL)) {
                prefilledValue = HiveUtil.floatPartitionKey(columnValue, name);
            } else if (type.equals(DoubleType.DOUBLE)) {
                prefilledValue = HiveUtil.doublePartitionKey(columnValue, name);
            } else if (Varchars.isVarcharType((Type)type)) {
                prefilledValue = HiveUtil.varcharPartitionKey(columnValue, name, type);
            } else if (Chars.isCharType((Type)type)) {
                prefilledValue = HiveUtil.charPartitionKey(columnValue, name, type);
            } else if (type.equals(DateType.DATE)) {
                prefilledValue = HiveUtil.datePartitionKey(columnValue, name);
            } else if (type.equals(TimestampType.TIMESTAMP)) {
                prefilledValue = HiveUtil.timestampPartitionKey(columnValue, hiveStorageTimeZone, name);
            } else if (Decimals.isShortDecimal((Type)type)) {
                prefilledValue = HiveUtil.shortDecimalPartitionKey(columnValue, (DecimalType)type, name);
            } else if (Decimals.isLongDecimal((Type)type)) {
                prefilledValue = HiveUtil.longDecimalPartitionKey(columnValue, (DecimalType)type, name);
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for prefilled column: %s", type.getDisplayName(), name));
            }
            this.prefilledValues[columnIndex] = prefilledValue;
        }
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            if (this.bucketAdapter.isPresent()) {
                IntArrayList rowsToKeep = this.bucketAdapter.get().computeEligibleRowIds(dataPage);
                Block[] adaptedBlocks = new Block[dataPage.getChannelCount()];
                for (int i = 0; i < adaptedBlocks.length; ++i) {
                    Block block = dataPage.getBlock(i);
                    adaptedBlocks[i] = block instanceof LazyBlock && !((LazyBlock)block).isLoaded() ? new LazyBlock(rowsToKeep.size(), (LazyBlockLoader)new RowFilterLazyBlockLoader(dataPage.getBlock(i), rowsToKeep)) : block.getPositions(rowsToKeep.elements(), 0, rowsToKeep.size());
                }
                dataPage = new Page(rowsToKeep.size(), adaptedBlocks);
            }
            int batchSize = dataPage.getPositionCount();
            ArrayList<Block> blocks = new ArrayList<Block>();
            block9: for (int fieldId = 0; fieldId < this.columnMappings.size(); ++fieldId) {
                HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(fieldId);
                switch (columnMapping.getKind()) {
                    case PREFILLED: {
                        blocks.add(RunLengthEncodedBlock.create((Type)this.types[fieldId], (Object)this.prefilledValues[fieldId], (int)batchSize));
                        continue block9;
                    }
                    case REGULAR: {
                        Block block = dataPage.getBlock(columnMapping.getIndex());
                        if (this.coercers[fieldId] != null) {
                            block = new LazyBlock(batchSize, (LazyBlockLoader)new CoercionLazyBlockLoader(block, this.coercers[fieldId]));
                        }
                        blocks.add(block);
                        continue block9;
                    }
                    case INTERIM: {
                        continue block9;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            return new Page(batchSize, blocks.toArray(new Block[0]));
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public ConnectorPageSource getPageSource() {
        return this.delegate;
    }

    private static Function<Block, Block> createCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
        Type fromType = typeManager.getType(fromHiveType.getTypeSignature());
        Type toType = typeManager.getType(toHiveType.getTypeSignature());
        if (toType instanceof VarcharType && (fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG))) {
            return new IntegerNumberToVarcharCoercer(fromType, toType);
        }
        if (fromType instanceof VarcharType && (toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return new VarcharToIntegerNumberCoercer(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE) && toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT) && toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_INT) && toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT) && toHiveType.equals(HiveType.HIVE_DOUBLE)) {
            return new FloatToDoubleCoercer();
        }
        if (HiveUtil.isArrayType(fromType) && HiveUtil.isArrayType(toType)) {
            return new ListCoercer(typeManager, fromHiveType, toHiveType);
        }
        if (HiveUtil.isMapType(fromType) && HiveUtil.isMapType(toType)) {
            return new MapCoercer(typeManager, fromHiveType, toHiveType);
        }
        if (HiveUtil.isRowType(fromType) && HiveUtil.isRowType(toType)) {
            return new StructCoercer(typeManager, fromHiveType, toHiveType);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromHiveType, toHiveType));
    }

    private static Page extractColumns(Page page, int[] columns) {
        Block[] blocks = new Block[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dataColumn = columns[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    public static class BucketAdapter {
        public final int[] bucketColumns;
        public final int bucketToKeep;
        public final int tableBucketCount;
        public final int partitionBucketCount;
        private final List<TypeInfo> typeInfoList;

        public BucketAdapter(HivePageSourceProvider.BucketAdaptation bucketAdaptation) {
            this.bucketColumns = bucketAdaptation.getBucketColumnIndices();
            this.bucketToKeep = bucketAdaptation.getBucketToKeep();
            this.typeInfoList = (List)bucketAdaptation.getBucketColumnHiveTypes().stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
            this.tableBucketCount = bucketAdaptation.getTableBucketCount();
            this.partitionBucketCount = bucketAdaptation.getPartitionBucketCount();
        }

        public IntArrayList computeEligibleRowIds(Page page) {
            IntArrayList ids = new IntArrayList(page.getPositionCount());
            Page bucketColumnsPage = HivePageSource.extractColumns(page, this.bucketColumns);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int bucket = HiveBucketing.getHiveBucket(this.tableBucketCount, this.typeInfoList, bucketColumnsPage, position);
                if ((bucket - this.bucketToKeep) % this.partitionBucketCount != 0) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("A row that is supposed to be in bucket %s is encountered. Only rows in bucket %s (modulo %s) are expected", bucket, this.bucketToKeep % this.partitionBucketCount, this.partitionBucketCount));
                }
                if (bucket != this.bucketToKeep) continue;
                ids.add(position);
            }
            return ids;
        }
    }

    private static final class RowFilterLazyBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private Block block;
        private final IntArrayList rowsToKeep;

        public RowFilterLazyBlockLoader(Block block, IntArrayList rowsToKeep) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.rowsToKeep = Objects.requireNonNull(rowsToKeep, "rowsToKeep is null");
        }

        public void load(LazyBlock lazyBlock) {
            if (this.block == null) {
                return;
            }
            if (this.block instanceof LazyBlock) {
                this.block = ((LazyBlock)this.block).getBlock();
            }
            lazyBlock.setBlock(this.block.getPositions(this.rowsToKeep.elements(), 0, this.rowsToKeep.size()));
            this.block = null;
        }
    }

    private static final class CoercionLazyBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final Function<Block, Block> coercer;
        private Block block;

        public CoercionLazyBlockLoader(Block block, Function<Block, Block> coercer) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.coercer = Objects.requireNonNull(coercer, "coercer is null");
        }

        public void load(LazyBlock lazyBlock) {
            if (this.block == null) {
                return;
            }
            if (this.block instanceof LazyBlock) {
                this.block = ((LazyBlock)this.block).getBlock();
            }
            lazyBlock.setBlock(this.coercer.apply(this.block));
            this.block = null;
        }
    }

    private static class StructCoercer
    implements Function<Block, Block> {
        private final Function<Block, Block>[] coercers;
        private final Block[] nullBlocks;

        public StructCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            List<HiveType> fromFieldTypes = HiveUtil.extractStructFieldTypes(fromHiveType);
            List<HiveType> toFieldTypes = HiveUtil.extractStructFieldTypes(toHiveType);
            this.coercers = new Function[toFieldTypes.size()];
            this.nullBlocks = new Block[toFieldTypes.size()];
            for (int i = 0; i < this.coercers.length; ++i) {
                if (i >= fromFieldTypes.size()) {
                    this.nullBlocks[i] = toFieldTypes.get(i).getType(typeManager).createBlockBuilder(null, 1).appendNull().build();
                    continue;
                }
                if (fromFieldTypes.get(i).equals(toFieldTypes.get(i))) continue;
                this.coercers[i] = HivePageSource.createCoercer(typeManager, fromFieldTypes.get(i), toFieldTypes.get(i));
            }
        }

        @Override
        public Block apply(Block block) {
            ColumnarRow rowBlock = ColumnarRow.toColumnarRow((Block)block);
            Block[] fields = new Block[this.coercers.length];
            int[] ids = new int[rowBlock.getField(0).getPositionCount()];
            for (int i = 0; i < this.coercers.length; ++i) {
                fields[i] = this.coercers[i] != null ? this.coercers[i].apply(rowBlock.getField(i)) : (i < rowBlock.getFieldCount() ? rowBlock.getField(i) : new DictionaryBlock(this.nullBlocks[i], ids));
            }
            boolean[] valueIsNull = new boolean[rowBlock.getPositionCount()];
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                valueIsNull[i] = rowBlock.isNull(i);
            }
            return RowBlock.fromFieldBlocks((boolean[])valueIsNull, (Block[])fields);
        }
    }

    private static class MapCoercer
    implements Function<Block, Block> {
        private final Type toType;
        private final Function<Block, Block> keyCoercer;
        private final Function<Block, Block> valueCoercer;

        public MapCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            this.toType = Objects.requireNonNull(toHiveType, "toHiveType is null").getType(typeManager);
            HiveType fromKeyHiveType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType fromValueHiveType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            HiveType toKeyHiveType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType toValueHiveType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            this.keyCoercer = fromKeyHiveType.equals(toKeyHiveType) ? null : HivePageSource.createCoercer(typeManager, fromKeyHiveType, toKeyHiveType);
            this.valueCoercer = fromValueHiveType.equals(toValueHiveType) ? null : HivePageSource.createCoercer(typeManager, fromValueHiveType, toValueHiveType);
        }

        @Override
        public Block apply(Block block) {
            ColumnarMap mapBlock = ColumnarMap.toColumnarMap((Block)block);
            Block keysBlock = this.keyCoercer == null ? mapBlock.getKeysBlock() : this.keyCoercer.apply(mapBlock.getKeysBlock());
            Block valuesBlock = this.valueCoercer == null ? mapBlock.getValuesBlock() : this.valueCoercer.apply(mapBlock.getValuesBlock());
            boolean[] valueIsNull = new boolean[mapBlock.getPositionCount()];
            int[] offsets = new int[mapBlock.getPositionCount() + 1];
            for (int i = 0; i < mapBlock.getPositionCount(); ++i) {
                valueIsNull[i] = mapBlock.isNull(i);
                offsets[i + 1] = offsets[i] + mapBlock.getEntryCount(i);
            }
            return ((MapType)this.toType).createBlockFromKeyValue(valueIsNull, offsets, keysBlock, valuesBlock);
        }
    }

    private static class ListCoercer
    implements Function<Block, Block> {
        private final Function<Block, Block> elementCoercer;

        public ListCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            HiveType fromElementHiveType = HiveType.valueOf(((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            HiveType toElementHiveType = HiveType.valueOf(((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            this.elementCoercer = fromElementHiveType.equals(toElementHiveType) ? null : HivePageSource.createCoercer(typeManager, fromElementHiveType, toElementHiveType);
        }

        @Override
        public Block apply(Block block) {
            if (this.elementCoercer == null) {
                return block;
            }
            ColumnarArray arrayBlock = ColumnarArray.toColumnarArray((Block)block);
            Block elementsBlock = this.elementCoercer.apply(arrayBlock.getElementsBlock());
            boolean[] valueIsNull = new boolean[arrayBlock.getPositionCount()];
            int[] offsets = new int[arrayBlock.getPositionCount() + 1];
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                valueIsNull[i] = arrayBlock.isNull(i);
                offsets[i + 1] = offsets[i] + arrayBlock.getLength(i);
            }
            return ArrayBlock.fromElementBlock((int)arrayBlock.getPositionCount(), (boolean[])valueIsNull, (int[])offsets, (Block)elementsBlock);
        }
    }

    private static class FloatToDoubleCoercer
    implements Function<Block, Block> {
        private FloatToDoubleCoercer() {
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                DoubleType.DOUBLE.writeDouble(blockBuilder, (double)Float.intBitsToFloat((int)RealType.REAL.getLong(block, i)));
            }
            return blockBuilder.build();
        }
    }

    private static class VarcharToIntegerNumberCoercer
    implements Function<Block, Block> {
        private final Type fromType;
        private final Type toType;
        private final long minValue;
        private final long maxValue;

        public VarcharToIntegerNumberCoercer(Type fromType, Type toType) {
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
            if (toType.equals(TinyintType.TINYINT)) {
                this.minValue = -128L;
                this.maxValue = 127L;
            } else if (toType.equals(SmallintType.SMALLINT)) {
                this.minValue = -32768L;
                this.maxValue = 32767L;
            } else if (toType.equals(IntegerType.INTEGER)) {
                this.minValue = Integer.MIN_VALUE;
                this.maxValue = Integer.MAX_VALUE;
            } else if (toType.equals(BigintType.BIGINT)) {
                this.minValue = Long.MIN_VALUE;
                this.maxValue = Long.MAX_VALUE;
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not create Coercer from from varchar to %s", toType));
            }
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = this.toType.createBlockBuilder(null, block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                try {
                    long value = Long.parseLong(this.fromType.getSlice(block, i).toStringUtf8());
                    if (this.minValue <= value && value <= this.maxValue) {
                        this.toType.writeLong(blockBuilder, value);
                        continue;
                    }
                    blockBuilder.appendNull();
                    continue;
                }
                catch (NumberFormatException e) {
                    blockBuilder.appendNull();
                }
            }
            return blockBuilder.build();
        }
    }

    private static class IntegerNumberToVarcharCoercer
    implements Function<Block, Block> {
        private final Type fromType;
        private final Type toType;

        public IntegerNumberToVarcharCoercer(Type fromType, Type toType) {
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = this.toType.createBlockBuilder(null, block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                this.toType.writeSlice(blockBuilder, Slices.utf8Slice((String)String.valueOf(this.fromType.getLong(block, i))));
            }
            return blockBuilder.build();
        }
    }

    private static class IntegerNumberUpscaleCoercer
    implements Function<Block, Block> {
        private final Type fromType;
        private final Type toType;

        public IntegerNumberUpscaleCoercer(Type fromType, Type toType) {
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = this.toType.createBlockBuilder(null, block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                this.toType.writeLong(blockBuilder, this.fromType.getLong(block, i));
            }
            return blockBuilder.build();
        }
    }
}

