/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class HivePartitionManager {
    private static final String PARTITION_VALUE_WILDCARD = "";
    private final DateTimeZone timeZone;
    private final boolean assumeCanonicalPartitionKeys;
    private final int domainCompactionThreshold;
    private final TypeManager typeManager;

    @Inject
    public HivePartitionManager(TypeManager typeManager, HiveClientConfig hiveClientConfig) {
        this(typeManager, hiveClientConfig.getDateTimeZone(), hiveClientConfig.isAssumeCanonicalPartitionKeys(), hiveClientConfig.getDomainCompactionThreshold());
    }

    public HivePartitionManager(TypeManager typeManager, DateTimeZone timeZone, boolean assumeCanonicalPartitionKeys, int domainCompactionThreshold) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicate = constraint.getSummary();
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(metastore, tableName);
        if (!table.getParameters().getOrDefault("skip.footer.line.count", "0").equals("0")) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Table with 'skip.footer.line.count' is not supported");
        }
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(table);
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        if (effectivePredicate.isNone()) {
            return new HivePartitionResult(partitionColumns, (Iterable<HivePartition>)ImmutableList.of(), (TupleDomain<? extends ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), hiveBucketHandle, Optional.empty());
        }
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = HiveBucketing.getHiveBucketFilter(table, (TupleDomain<ColumnHandle>)effectivePredicate);
        TupleDomain<HiveColumnHandle> compactEffectivePredicate = HivePartitionManager.toCompactTupleDomain((TupleDomain<ColumnHandle>)effectivePredicate, this.domainCompactionThreshold);
        if (partitionColumns.isEmpty()) {
            return new HivePartitionResult(partitionColumns, (Iterable<HivePartition>)ImmutableList.of((Object)new HivePartition(tableName)), compactEffectivePredicate, (TupleDomain<ColumnHandle>)effectivePredicate, (TupleDomain<ColumnHandle>)TupleDomain.none(), hiveBucketHandle, bucketFilter);
        }
        List partitionTypes = partitionColumns.stream().map(column -> this.typeManager.getType(column.getTypeSignature())).collect(Collectors.toList());
        List<String> partitionNames = this.getFilteredPartitionNames(metastore, tableName, partitionColumns, (TupleDomain<ColumnHandle>)effectivePredicate);
        Iterable<HivePartition> partitionsIterable = () -> partitionNames.stream().map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionTypes, constraint)).filter(Optional::isPresent).map(Optional::get).iterator();
        TupleDomain remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(partitionColumns))));
        TupleDomain enforcedTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (Predicate)Predicates.in(partitionColumns)));
        return new HivePartitionResult(partitionColumns, partitionsIterable, compactEffectivePredicate, (TupleDomain<ColumnHandle>)remainingTupleDomain, (TupleDomain<ColumnHandle>)enforcedTupleDomain, hiveBucketHandle, bucketFilter);
    }

    private static TupleDomain<HiveColumnHandle> toCompactTupleDomain(TupleDomain<ColumnHandle> effectivePredicate, int threshold) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        effectivePredicate.getDomains().ifPresent(domains -> {
            for (Map.Entry entry : domains.entrySet()) {
                HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)entry.getKey();
                ValueSet values = ((Domain)entry.getValue()).getValues();
                ValueSet compactValueSet = ((Optional)values.getValuesProcessor().transform(ranges -> ranges.getRangeCount() > threshold ? Optional.of(ValueSet.ofRanges((Range)ranges.getSpan(), (Range[])new Range[0])) : Optional.empty(), discreteValues -> discreteValues.getValues().size() > threshold ? Optional.of(ValueSet.all((Type)values.getType())) : Optional.empty(), allOrNone -> Optional.empty())).orElse(values);
                builder.put((Object)hiveColumnHandle, (Object)Domain.create((ValueSet)compactValueSet, (boolean)((Domain)entry.getValue()).isNullAllowed()));
            }
        });
        return TupleDomain.withColumnDomains((Map)builder.build());
    }

    private Optional<HivePartition> parseValuesAndFilterPartition(SchemaTableName tableName, String partitionId, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes, Constraint<ColumnHandle> constraint) {
        List<String> keys = HivePartitionManager.extractPartitionKeyValues(partitionId);
        Map domains = (Map)constraint.getSummary().getDomains().get();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue(partitionId, keys.get(i), partitionColumnTypes.get(i), this.timeZone);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain != null && !allowedDomain.includesNullableValue(parsedValue.getValue())) {
                return Optional.empty();
            }
            builder.put((Object)column, (Object)parsedValue);
        }
        ImmutableMap values = builder.build();
        if (!constraint.predicate().test(values)) {
            return Optional.empty();
        }
        return Optional.of(new HivePartition(tableName, partitionId, (Map<ColumnHandle, NullableValue>)values));
    }

    private Table getTable(SemiTransactionalHiveMetastore metastore, SchemaTableName tableName) {
        Optional<Table> target = metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        Table table = target.get();
        MetastoreUtil.verifyOnline(tableName, Optional.empty(), MetastoreUtil.getProtectMode(table), table.getParameters());
        return table;
    }

    private List<String> getFilteredPartitionNames(SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, List<HiveColumnHandle> partitionKeys, TupleDomain<ColumnHandle> effectivePredicate) {
        Preconditions.checkArgument((boolean)effectivePredicate.getDomains().isPresent());
        ArrayList<String> filter = new ArrayList<String>();
        for (HiveColumnHandle partitionKey : partitionKeys) {
            Domain domain = (Domain)((Map)effectivePredicate.getDomains().get()).get(partitionKey);
            if (domain != null && domain.isNullableSingleValue()) {
                Slice slice;
                Object value = domain.getNullableSingleValue();
                Type type = domain.getType();
                if (value == null) {
                    filter.add("__HIVE_DEFAULT_PARTITION__");
                    continue;
                }
                if (type instanceof CharType) {
                    slice = (Slice)value;
                    filter.add(Chars.padSpaces((Slice)slice, (Type)type).toStringUtf8());
                    continue;
                }
                if (type instanceof VarcharType) {
                    slice = (Slice)value;
                    filter.add(slice.toStringUtf8());
                    continue;
                }
                if (!this.assumeCanonicalPartitionKeys) {
                    filter.add(PARTITION_VALUE_WILDCARD);
                    continue;
                }
                if (type instanceof DecimalType && !((DecimalType)type).isShort()) {
                    slice = (Slice)value;
                    filter.add(Decimals.toString((Slice)slice, (int)((DecimalType)type).getScale()));
                    continue;
                }
                if (type instanceof DecimalType && ((DecimalType)type).isShort()) {
                    filter.add(Decimals.toString((long)((Long)value), (int)((DecimalType)type).getScale()));
                    continue;
                }
                if (type instanceof DateType) {
                    DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.date().withZoneUTC();
                    filter.add(dateTimeFormatter.print(TimeUnit.DAYS.toMillis((Long)value)));
                    continue;
                }
                if (type instanceof TimestampType) {
                    filter.add(PARTITION_VALUE_WILDCARD);
                    continue;
                }
                if (type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof DoubleType || type instanceof RealType || type instanceof BooleanType) {
                    filter.add(value.toString());
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported partition key type: %s", type.getDisplayName()));
            }
            filter.add(PARTITION_VALUE_WILDCARD);
        }
        return metastore.getPartitionNamesByParts(tableName.getSchemaName(), tableName.getTableName(), filter).orElseThrow(() -> new TableNotFoundException(tableName));
    }

    public static List<String> extractPartitionKeyValues(String partitionName) {
        ImmutableList.Builder values = ImmutableList.builder();
        boolean inKey = true;
        int valueStart = -1;
        for (int i = 0; i < partitionName.length(); ++i) {
            char current = partitionName.charAt(i);
            if (inKey) {
                Preconditions.checkArgument((current != '/' ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
                if (current != '=') continue;
                inKey = false;
                valueStart = i + 1;
                continue;
            }
            if (current != '/') continue;
            Preconditions.checkArgument((valueStart != -1 ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
            values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, i)));
            inKey = true;
            valueStart = -1;
        }
        Preconditions.checkArgument((!inKey ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
        values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, partitionName.length())));
        return values.build();
    }
}

