/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;

public final class HiveSessionProperties {
    private static final String BUCKET_EXECUTION_ENABLED = "bucket_execution_enabled";
    private static final String FORCE_LOCAL_SCHEDULING = "force_local_scheduling";
    private static final String ORC_BLOOM_FILTERS_ENABLED = "orc_bloom_filters_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String ORC_TINY_STRIPE_THRESHOLD = "orc_tiny_stripe_threshold";
    private static final String ORC_MAX_READ_BLOCK_SIZE = "orc_max_read_block_size";
    private static final String ORC_LAZY_READ_SMALL_RANGES = "orc_lazy_read_small_ranges";
    private static final String ORC_STRING_STATISTICS_LIMIT = "orc_string_statistics_limit";
    private static final String ORC_OPTIMIZED_WRITER_ENABLED = "orc_optimized_writer_enabled";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE = "orc_optimized_writer_validate";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_MODE = "orc_optimized_writer_validate_mode";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE = "orc_optimized_writer_max_stripe_size";
    private static final String HIVE_STORAGE_FORMAT = "hive_storage_format";
    private static final String RESPECT_TABLE_FORMAT = "respect_table_format";
    private static final String PARQUET_PREDICATE_PUSHDOWN_ENABLED = "parquet_predicate_pushdown_enabled";
    private static final String PARQUET_OPTIMIZED_READER_ENABLED = "parquet_optimized_reader_enabled";
    private static final String MAX_SPLIT_SIZE = "max_split_size";
    private static final String MAX_INITIAL_SPLIT_SIZE = "max_initial_split_size";
    public static final String RCFILE_OPTIMIZED_WRITER_ENABLED = "rcfile_optimized_writer_enabled";
    private static final String RCFILE_OPTIMIZED_WRITER_VALIDATE = "rcfile_optimized_writer_validate";
    private static final String SORTED_WRITING_ENABLED = "sorted_writing_enabled";
    private static final String WRITER_SORT_BUFFER_SIZE = "writer_sort_buffer_size";
    private static final String STATISTICS_ENABLED = "statistics_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public HiveSessionProperties(HiveClientConfig hiveClientConfig, OrcFileWriterConfig orcFileWriterConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanSessionProperty((String)BUCKET_EXECUTION_ENABLED, (String)"Enable bucket-aware execution: only use a single worker per bucket", (Boolean)hiveClientConfig.isBucketExecutionEnabled(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)FORCE_LOCAL_SCHEDULING, (String)"Only schedule splits on workers colocated with data node", (Boolean)hiveClientConfig.isForceLocalScheduling(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)ORC_BLOOM_FILTERS_ENABLED, (String)"ORC: Enable bloom filters for predicate pushdown", (Boolean)hiveClientConfig.isOrcBloomFiltersEnabled(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_MERGE_DISTANCE, "ORC: Maximum size of gap between two reads to merge into a single read", hiveClientConfig.getOrcMaxMergeDistance(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_BUFFER_SIZE, "ORC: Maximum size of a single read", hiveClientConfig.getOrcMaxBufferSize(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_STREAM_BUFFER_SIZE, "ORC: Size of buffer for streaming reads", hiveClientConfig.getOrcStreamBufferSize(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_TINY_STRIPE_THRESHOLD, "ORC: Threshold below which an ORC stripe or file will read in its entirety", hiveClientConfig.getOrcTinyStripeThreshold(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_READ_BLOCK_SIZE, "ORC: Soft max size of Presto blocks produced by ORC reader", hiveClientConfig.getOrcMaxReadBlockSize(), false), (Object)PropertyMetadata.booleanSessionProperty((String)ORC_LAZY_READ_SMALL_RANGES, (String)"Experimental: ORC: Read small file segments lazily", (Boolean)hiveClientConfig.isOrcLazyReadSmallRanges(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(ORC_STRING_STATISTICS_LIMIT, "ORC: Maximum size of string statistics; drop if exceeding", orcFileWriterConfig.getStringStatisticsLimit(), false), (Object)PropertyMetadata.booleanSessionProperty((String)ORC_OPTIMIZED_WRITER_ENABLED, (String)"Experimental: ORC: Enable optimized writer", (Boolean)hiveClientConfig.isOrcOptimizedWriterEnabled(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: ORC: Force all validation for files", (Boolean)(hiveClientConfig.getOrcWriterValidationPercentage() > 0.0 ? 1 : 0), (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.stringSessionProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE_MODE, (String)"Experimental: ORC: Level of detail in ORC validation", (String)hiveClientConfig.getOrcWriterValidationMode().toString(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, "Experimental: ORC: Max stripe size", orcFileWriterConfig.getStripeMaxSize(), false), PropertyMetadata.stringSessionProperty((String)HIVE_STORAGE_FORMAT, (String)"Default storage format for new tables or partitions", (String)hiveClientConfig.getHiveStorageFormat().toString(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)RESPECT_TABLE_FORMAT, (String)"Write new partitions using table format rather than default storage format", (Boolean)hiveClientConfig.isRespectTableFormat(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)PARQUET_OPTIMIZED_READER_ENABLED, (String)"Experimental: Parquet: Enable optimized reader", (Boolean)hiveClientConfig.isParquetOptimizedReaderEnabled(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)PARQUET_PREDICATE_PUSHDOWN_ENABLED, (String)"Experimental: Parquet: Enable predicate pushdown for Parquet", (Boolean)hiveClientConfig.isParquetPredicatePushdownEnabled(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(MAX_SPLIT_SIZE, "Max split size", hiveClientConfig.getMaxSplitSize(), true), HiveSessionProperties.dataSizeSessionProperty(MAX_INITIAL_SPLIT_SIZE, "Max initial split size", hiveClientConfig.getMaxInitialSplitSize(), true), PropertyMetadata.booleanSessionProperty((String)RCFILE_OPTIMIZED_WRITER_ENABLED, (String)"Experimental: RCFile: Enable optimized writer", (Boolean)hiveClientConfig.isRcfileOptimizedWriterEnabled(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)RCFILE_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: RCFile: Validate writer files", (Boolean)hiveClientConfig.isRcfileWriterValidate(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)SORTED_WRITING_ENABLED, (String)"Enable writing to bucketed sorted tables", (Boolean)hiveClientConfig.isSortedWritingEnabled(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(WRITER_SORT_BUFFER_SIZE, "Writer sort buffer size", hiveClientConfig.getWriterSortBufferSize(), false), PropertyMetadata.booleanSessionProperty((String)STATISTICS_ENABLED, (String)"Experimental: Expose table statistics", (Boolean)hiveClientConfig.isTableStatisticsEnabled(), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isBucketExecutionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(BUCKET_EXECUTION_ENABLED, Boolean.class);
    }

    public static boolean isForceLocalScheduling(ConnectorSession session) {
        return (Boolean)session.getProperty(FORCE_LOCAL_SCHEDULING, Boolean.class);
    }

    public static boolean isParquetOptimizedReaderEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_OPTIMIZED_READER_ENABLED, Boolean.class);
    }

    public static boolean isOrcBloomFiltersEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_ENABLED, Boolean.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcTinyStripeThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_TINY_STRIPE_THRESHOLD, DataSize.class);
    }

    public static DataSize getOrcMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean getOrcLazyReadSmallRanges(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_LAZY_READ_SMALL_RANGES, Boolean.class);
    }

    public static DataSize getOrcStringStatisticsLimit(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STRING_STATISTICS_LIMIT, DataSize.class);
    }

    public static boolean isOrcOptimizedWriterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_ENABLED, Boolean.class);
    }

    public static boolean isOrcOptimizedWriterValidate(ConnectorSession session, double orcWriterValidationPercentage) {
        boolean validate = (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
        if (orcWriterValidationPercentage <= 0.0) {
            return validate;
        }
        if (!validate) {
            return false;
        }
        return ThreadLocalRandom.current().nextDouble() < orcWriterValidationPercentage;
    }

    public static OrcWriteValidation.OrcWriteValidationMode getOrcOptimizedWriterValidateMode(ConnectorSession session) {
        return OrcWriteValidation.OrcWriteValidationMode.valueOf((String)((String)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_MODE, String.class)).toUpperCase(Locale.ENGLISH));
    }

    public static DataSize getOrcOptimizedWriterMaxStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, DataSize.class);
    }

    public static HiveStorageFormat getHiveStorageFormat(ConnectorSession session) {
        return HiveStorageFormat.valueOf(((String)session.getProperty(HIVE_STORAGE_FORMAT, String.class)).toUpperCase(Locale.ENGLISH));
    }

    public static boolean isRespectTableFormat(ConnectorSession session) {
        return (Boolean)session.getProperty(RESPECT_TABLE_FORMAT, Boolean.class);
    }

    public static boolean isParquetPredicatePushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_PREDICATE_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static DataSize getMaxSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_SPLIT_SIZE, DataSize.class);
    }

    public static DataSize getMaxInitialSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_INITIAL_SPLIT_SIZE, DataSize.class);
    }

    public static boolean isRcfileOptimizedWriterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(RCFILE_OPTIMIZED_WRITER_ENABLED, Boolean.class);
    }

    public static boolean isRcfileOptimizedWriterValidate(ConnectorSession session) {
        return (Boolean)session.getProperty(RCFILE_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
    }

    public static boolean isSortedWritingEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SORTED_WRITING_ENABLED, Boolean.class);
    }

    public static DataSize getWriterSortBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(WRITER_SORT_BUFFER_SIZE, DataSize.class);
    }

    public static boolean isStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(STATISTICS_ENABLED, Boolean.class);
    }

    public static PropertyMetadata<DataSize> dataSizeSessionProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.createUnboundedVarcharType(), DataSize.class, (Object)defaultValue, hidden, value -> DataSize.valueOf((String)((String)value)), DataSize::toString);
    }
}

