/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.BackgroundHiveSplitLoader;
import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveNotReadableException;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HiveSplitManager
implements ConnectorSplitManager {
    public static final String PRESTO_OFFLINE = "presto_offline";
    public static final String OBJECT_NOT_READABLE = "object_not_readable";
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;
    private final NamenodeStats namenodeStats;
    private final HdfsEnvironment hdfsEnvironment;
    private final DirectoryLister directoryLister;
    private final Executor executor;
    private final CoercionPolicy coercionPolicy;
    private final int maxOutstandingSplits;
    private final DataSize maxOutstandingSplitsSize;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final int maxInitialSplits;
    private final int splitLoaderConcurrency;
    private final boolean recursiveDfsWalkerEnabled;
    private final CounterStat highMemorySplitSourceCounter;

    @Inject
    public HiveSplitManager(HiveClientConfig hiveClientConfig, Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, @ForHiveClient ExecutorService executorService, CoercionPolicy coercionPolicy) {
        this(metastoreProvider, namenodeStats, hdfsEnvironment, directoryLister, (Executor)new BoundedExecutor((Executor)executorService, hiveClientConfig.getMaxSplitIteratorThreads()), coercionPolicy, new CounterStat(), hiveClientConfig.getMaxOutstandingSplits(), hiveClientConfig.getMaxOutstandingSplitsSize(), hiveClientConfig.getMinPartitionBatchSize(), hiveClientConfig.getMaxPartitionBatchSize(), hiveClientConfig.getMaxInitialSplits(), hiveClientConfig.getSplitLoaderConcurrency(), hiveClientConfig.getRecursiveDirWalkerEnabled());
    }

    public HiveSplitManager(Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, Executor executor, CoercionPolicy coercionPolicy, CounterStat highMemorySplitSourceCounter, int maxOutstandingSplits, DataSize maxOutstandingSplitsSize, int minPartitionBatchSize, int maxPartitionBatchSize, int maxInitialSplits, int splitLoaderConcurrency, boolean recursiveDfsWalkerEnabled) {
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastore is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.executor = new ErrorCodedExecutor(executor);
        this.coercionPolicy = Objects.requireNonNull(coercionPolicy, "coercionPolicy is null");
        this.highMemorySplitSourceCounter = Objects.requireNonNull(highMemorySplitSourceCounter, "highMemorySplitSourceCounter is null");
        Preconditions.checkArgument((maxOutstandingSplits >= 1 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.maxOutstandingSplitsSize = maxOutstandingSplitsSize;
        this.minPartitionBatchSize = minPartitionBatchSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.maxInitialSplits = maxInitialSplits;
        this.splitLoaderConcurrency = splitLoaderConcurrency;
        this.recursiveDfsWalkerEnabled = recursiveDfsWalkerEnabled;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layoutHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        HiveSplitSource splitSource;
        HiveTableLayoutHandle layout = (HiveTableLayoutHandle)layoutHandle;
        SchemaTableName tableName = layout.getSchemaTableName();
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        Table table = metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        String tableNotReadable = table.getParameters().get(OBJECT_NOT_READABLE);
        if (!Strings.isNullOrEmpty((String)tableNotReadable)) {
            throw new HiveNotReadableException(tableName, Optional.empty(), tableNotReadable);
        }
        List partitions = layout.getPartitions().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Layout does not contain partitions"));
        HivePartition partition = (HivePartition)Iterables.getFirst(partitions, null);
        if (partition == null) {
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = layout.getBucketFilter();
        Optional<HiveBucketHandle> bucketHandle = layout.getBucketHandle();
        if (splitSchedulingStrategy == ConnectorSplitManager.SplitSchedulingStrategy.GROUPED_SCHEDULING && !bucketHandle.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "SchedulingPolicy is bucketed, but BucketHandle is not present");
        }
        partitions = Ordering.natural().onResultOf(HivePartition::getPartitionId).reverse().sortedCopy(partitions);
        Iterable<HivePartitionMetadata> hivePartitions = this.getPartitionMetadata(metastore, table, tableName, partitions, bucketHandle.map(HiveBucketHandle::toBucketProperty));
        BackgroundHiveSplitLoader hiveSplitLoader = new BackgroundHiveSplitLoader(table, hivePartitions, layout.getCompactEffectivePredicate(), BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(bucketHandle, bucketFilter), session, this.hdfsEnvironment, this.namenodeStats, this.directoryLister, this.executor, this.splitLoaderConcurrency, this.recursiveDfsWalkerEnabled);
        switch (splitSchedulingStrategy) {
            case UNGROUPED_SCHEDULING: {
                splitSource = HiveSplitSource.allAtOnce(session, table.getDatabaseName(), table.getTableName(), layout.getCompactEffectivePredicate(), this.maxInitialSplits, this.maxOutstandingSplits, this.maxOutstandingSplitsSize, hiveSplitLoader, this.executor, new CounterStat());
                break;
            }
            case GROUPED_SCHEDULING: {
                splitSource = HiveSplitSource.bucketed(session, table.getDatabaseName(), table.getTableName(), layout.getCompactEffectivePredicate(), this.maxInitialSplits, this.maxOutstandingSplits, this.maxOutstandingSplitsSize, hiveSplitLoader, this.executor, new CounterStat());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown splitSchedulingStrategy: " + splitSchedulingStrategy);
            }
        }
        hiveSplitLoader.start(splitSource);
        return splitSource;
    }

    @Managed
    @Nested
    public CounterStat getHighMemorySplitSource() {
        return this.highMemorySplitSourceCounter;
    }

    private Iterable<HivePartitionMetadata> getPartitionMetadata(SemiTransactionalHiveMetastore metastore, Table table, SchemaTableName tableName, List<HivePartition> hivePartitions, Optional<HiveBucketProperty> bucketProperty) {
        HivePartition firstPartition;
        if (hivePartitions.isEmpty()) {
            return ImmutableList.of();
        }
        if (hivePartitions.size() == 1 && (firstPartition = (HivePartition)Iterables.getOnlyElement(hivePartitions)).getPartitionId().equals("<UNPARTITIONED>")) {
            return ImmutableList.of((Object)new HivePartitionMetadata(firstPartition, Optional.empty(), (Map<Integer, HiveTypeName>)ImmutableMap.of()));
        }
        Iterable<List<HivePartition>> partitionNameBatches = HiveSplitManager.partitionExponentially(hivePartitions, this.minPartitionBatchSize, this.maxPartitionBatchSize);
        Iterable partitionBatches = Iterables.transform(partitionNameBatches, partitionBatch -> {
            Map<String, Optional<Partition>> batch = metastore.getPartitionsByNames(tableName.getSchemaName(), tableName.getTableName(), Lists.transform((List)partitionBatch, HivePartition::getPartitionId));
            ImmutableMap.Builder partitionBuilder = ImmutableMap.builder();
            for (Map.Entry<String, Optional<Partition>> entry : batch.entrySet()) {
                if (!entry.getValue().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Partition no longer exists: " + entry.getKey());
                }
                partitionBuilder.put((Object)entry.getKey(), (Object)entry.getValue().get());
            }
            ImmutableMap partitions = partitionBuilder.build();
            if (partitionBatch.size() != partitions.size()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Expected %s partitions but found %s", partitionBatch.size(), partitions.size()));
            }
            ImmutableList.Builder results = ImmutableList.builder();
            for (HivePartition hivePartition : partitionBatch) {
                Partition partition = (Partition)partitions.get(hivePartition.getPartitionId());
                if (partition == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Partition not loaded: " + hivePartition);
                }
                String partName = MetastoreUtil.makePartName(table.getPartitionColumns(), partition.getValues());
                MetastoreUtil.verifyOnline(tableName, Optional.of(partName), MetastoreUtil.getProtectMode(partition), partition.getParameters());
                String partitionNotReadable = partition.getParameters().get(OBJECT_NOT_READABLE);
                if (!Strings.isNullOrEmpty((String)partitionNotReadable)) {
                    throw new HiveNotReadableException(tableName, Optional.of(partName), partitionNotReadable);
                }
                List<Column> tableColumns = table.getDataColumns();
                List<Column> partitionColumns = partition.getColumns();
                if (tableColumns == null || partitionColumns == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s' or partition '%s' has null columns", tableName, partName));
                }
                ImmutableMap.Builder columnCoercions = ImmutableMap.builder();
                for (int i = 0; i < Math.min(partitionColumns.size(), tableColumns.size()); ++i) {
                    HiveType partitionType;
                    HiveType tableType = tableColumns.get(i).getType();
                    if (tableType.equals(partitionType = partitionColumns.get(i).getType())) continue;
                    if (!this.coercionPolicy.canCoerce(partitionType, tableType)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The types are incompatible and cannot be coerced. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumns.get(i).getName(), tableName, tableType, partName, partitionColumns.get(i).getName(), partitionType));
                    }
                    columnCoercions.put((Object)i, (Object)partitionType.getHiveTypeName());
                }
                if (bucketProperty.isPresent()) {
                    List<String> partitionBucketColumns;
                    Optional<HiveBucketProperty> partitionBucketProperty = partition.getStorage().getBucketProperty();
                    if (!partitionBucketProperty.isPresent()) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) is bucketed but partition (%s) is not bucketed", hivePartition.getTableName(), hivePartition.getPartitionId()));
                    }
                    int tableBucketCount = ((HiveBucketProperty)bucketProperty.get()).getBucketCount();
                    int partitionBucketCount = partitionBucketProperty.get().getBucketCount();
                    List<String> tableBucketColumns = ((HiveBucketProperty)bucketProperty.get()).getBucketedBy();
                    if (!tableBucketColumns.equals(partitionBucketColumns = partitionBucketProperty.get().getBucketedBy()) || !HiveSplitManager.isBucketCountCompatible(tableBucketCount, partitionBucketCount)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) bucketing (columns=%s, buckets=%s) is not compatible with partition (%s) bucketing (columns=%s, buckets=%s)", hivePartition.getTableName(), tableBucketColumns, tableBucketCount, hivePartition.getPartitionId(), partitionBucketColumns, partitionBucketCount));
                    }
                }
                results.add((Object)new HivePartitionMetadata(hivePartition, Optional.of(partition), (Map<Integer, HiveTypeName>)columnCoercions.build()));
            }
            return results.build();
        });
        return Iterables.concat((Iterable)partitionBatches);
    }

    private static boolean isBucketCountCompatible(int tableBucketCount, int partitionBucketCount) {
        Preconditions.checkArgument((tableBucketCount > 0 && partitionBucketCount > 0 ? 1 : 0) != 0);
        int larger = Math.max(tableBucketCount, partitionBucketCount);
        int smaller = Math.min(tableBucketCount, partitionBucketCount);
        if (larger % smaller != 0) {
            return false;
        }
        return Integer.bitCount(larger / smaller) == 1;
    }

    private static <T> Iterable<List<T>> partitionExponentially(final List<T> values, final int minBatchSize, final int maxBatchSize) {
        return () -> new AbstractIterator<List<T>>(){
            private int currentSize;
            private final Iterator iterator;
            {
                this.currentSize = minBatchSize;
                this.iterator = values.iterator();
            }

            protected List<T> computeNext() {
                if (!this.iterator.hasNext()) {
                    return (List)this.endOfData();
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int count = 0; this.iterator.hasNext() && count < this.currentSize; ++count) {
                    builder.add(this.iterator.next());
                }
                this.currentSize = Math.min(maxBatchSize, this.currentSize * 2);
                return builder.build();
            }
        };
    }

    private static class ErrorCodedExecutor
    implements Executor {
        private final Executor delegate;

        private ErrorCodedExecutor(Executor delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void execute(Runnable command) {
            try {
                this.delegate.execute(command);
            }
            catch (RejectedExecutionException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, "Server is shutting down", (Throwable)e);
            }
        }
    }
}

