/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class HiveTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final SchemaTableName schemaTableName;
    private final List<ColumnHandle> partitionColumns;
    private final List<HivePartition> partitions;
    private final TupleDomain<? extends ColumnHandle> compactEffectivePredicate;
    private final TupleDomain<ColumnHandle> promisedPredicate;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;

    @JsonCreator
    public HiveTableLayoutHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="partitionColumns") List<ColumnHandle> partitionColumns, @JsonProperty(value="compactEffectivePredicate") TupleDomain<ColumnHandle> compactEffectivePredicate, @JsonProperty(value="promisedPredicate") TupleDomain<ColumnHandle> promisedPredicate, @JsonProperty(value="bucketHandle") Optional<HiveBucketHandle> bucketHandle, @JsonProperty(value="bucketFilter") Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "table is null");
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.partitions = null;
        this.promisedPredicate = Objects.requireNonNull(promisedPredicate, "promisedPredicate is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
    }

    public HiveTableLayoutHandle(SchemaTableName schemaTableName, List<ColumnHandle> partitionColumns, List<HivePartition> partitions, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, TupleDomain<ColumnHandle> promisedPredicate, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "table is null");
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.promisedPredicate = Objects.requireNonNull(promisedPredicate, "promisedPredicate is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public List<ColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonIgnore
    public Optional<List<HivePartition>> getPartitions() {
        return Optional.ofNullable(this.partitions);
    }

    @JsonProperty
    public TupleDomain<? extends ColumnHandle> getCompactEffectivePredicate() {
        return this.compactEffectivePredicate;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getPromisedPredicate() {
        return this.promisedPredicate;
    }

    @JsonProperty
    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    @JsonProperty
    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }

    public String toString() {
        return this.schemaTableName.toString();
    }
}

