/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.spi.Page;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class HiveWriter {
    private final HiveFileWriter fileWriter;
    private final Optional<String> partitionName;
    private final boolean isNew;
    private final String fileName;
    private final String writePath;
    private final String targetPath;
    private final Consumer<HiveWriter> onCommit;
    private final HiveWriterStats hiveWriterStats;
    private long rowCount;
    private long inputSizeInBytes;

    public HiveWriter(HiveFileWriter fileWriter, Optional<String> partitionName, boolean isNew, String fileName, String writePath, String targetPath, Consumer<HiveWriter> onCommit, HiveWriterStats hiveWriterStats) {
        this.fileWriter = fileWriter;
        this.partitionName = partitionName;
        this.isNew = isNew;
        this.fileName = fileName;
        this.writePath = writePath;
        this.targetPath = targetPath;
        this.onCommit = onCommit;
        this.hiveWriterStats = hiveWriterStats;
    }

    public long getWrittenBytes() {
        return this.fileWriter.getWrittenBytes();
    }

    public long getSystemMemoryUsage() {
        return this.fileWriter.getSystemMemoryUsage();
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void append(Page dataPage) {
        this.hiveWriterStats.addInputPageSizesInBytes(dataPage.getRetainedSizeInBytes());
        this.fileWriter.appendRows(dataPage);
        this.rowCount += (long)dataPage.getPositionCount();
        this.inputSizeInBytes += dataPage.getSizeInBytes();
    }

    public void commit() {
        this.fileWriter.commit();
        this.onCommit.accept(this);
    }

    public Optional<Runnable> getVerificationTask() {
        return this.fileWriter.getVerificationTask();
    }

    public void rollback() {
        this.fileWriter.rollback();
    }

    public PartitionUpdate getPartitionUpdate() {
        return new PartitionUpdate(this.partitionName.orElse(""), this.isNew, this.writePath, this.targetPath, (List<String>)ImmutableList.of((Object)this.fileName), this.rowCount, this.inputSizeInBytes, this.fileWriter.getWrittenBytes());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileWriter", (Object)this.fileWriter).add("filePath", (Object)(this.writePath + "/" + this.fileName)).toString();
    }
}

