/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.rcfile.AircompressorCodecFactory;
import com.facebook.presto.rcfile.HadoopCodecFactory;
import com.facebook.presto.rcfile.RcFileCodecFactory;
import com.facebook.presto.rcfile.RcFileDataSource;
import com.facebook.presto.rcfile.RcFileEncoding;
import com.facebook.presto.rcfile.RcFileWriter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CountingOutputStream;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;

public class RcFileFileWriter
implements HiveFileWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RcFileFileWriter.class).instanceSize();
    private final CountingOutputStream outputStream;
    private final RcFileWriter rcFileWriter;
    private final Callable<Void> rollbackAction;
    private final int[] fileInputColumnIndexes;
    private final List<Block> nullBlocks;
    private final Optional<Supplier<RcFileDataSource>> validationInputFactory;

    public RcFileFileWriter(OutputStream outputStream, Callable<Void> rollbackAction, RcFileEncoding rcFileEncoding, List<Type> fileColumnTypes, Optional<String> codecName, int[] fileInputColumnIndexes, Map<String, String> metadata, Optional<Supplier<RcFileDataSource>> validationInputFactory) throws IOException {
        this.outputStream = new CountingOutputStream(outputStream);
        this.rcFileWriter = new RcFileWriter((SliceOutput)new OutputStreamSliceOutput((OutputStream)this.outputStream), fileColumnTypes, rcFileEncoding, codecName, (RcFileCodecFactory)new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(this.getClass().getClassLoader())), metadata, validationInputFactory.isPresent());
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
        this.fileInputColumnIndexes = Objects.requireNonNull(fileInputColumnIndexes, "outputColumnInputIndexes is null");
        ImmutableList.Builder nullBlocks = ImmutableList.builder();
        for (Type fileColumnType : fileColumnTypes) {
            BlockBuilder blockBuilder = fileColumnType.createBlockBuilder(null, 1, 0);
            blockBuilder.appendNull();
            nullBlocks.add((Object)blockBuilder.build());
        }
        this.nullBlocks = nullBlocks.build();
        this.validationInputFactory = validationInputFactory;
    }

    @Override
    public long getWrittenBytes() {
        return this.outputStream.getCount();
    }

    @Override
    public long getSystemMemoryUsage() {
        return (long)INSTANCE_SIZE + this.rcFileWriter.getRetainedSizeInBytes();
    }

    @Override
    public void appendRows(Page dataPage) {
        Block[] blocks = new Block[this.fileInputColumnIndexes.length];
        for (int i = 0; i < this.fileInputColumnIndexes.length; ++i) {
            int inputColumnIndex = this.fileInputColumnIndexes[i];
            blocks[i] = inputColumnIndex < 0 ? new RunLengthEncodedBlock(this.nullBlocks.get(i), dataPage.getPositionCount()) : dataPage.getBlock(inputColumnIndex);
        }
        Page page = new Page(dataPage.getPositionCount(), blocks);
        try {
            this.rcFileWriter.write(page);
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    @Override
    public void commit() {
        try {
            this.rcFileWriter.close();
        }
        catch (IOException | UncheckedIOException e) {
            try {
                this.rollbackAction.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
        if (this.validationInputFactory.isPresent()) {
            try (RcFileDataSource input = this.validationInputFactory.get().get();){
                this.rcFileWriter.validate(input);
            }
            catch (IOException | UncheckedIOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
            }
        }
    }

    @Override
    public void rollback() {
        try {
            try {
                this.rcFileWriter.close();
            }
            finally {
                this.rollbackAction.call();
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("writer", (Object)this.rcFileWriter).toString();
    }
}

