/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.util.MergingPageIterator;
import com.facebook.presto.hive.util.SortBuffer;
import com.facebook.presto.hive.util.TempFileReader;
import com.facebook.presto.hive.util.TempFileWriter;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.openjdk.jol.info.ClassLayout;

public class SortingFileWriter
implements HiveFileWriter {
    private static final Logger log = Logger.get(SortingFileWriter.class);
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SortingFileWriter.class).instanceSize();
    private final FileSystem fileSystem;
    private final Path tempFilePrefix;
    private final int maxTempFiles;
    private final List<Type> types;
    private final List<Integer> sortFields;
    private final List<SortOrder> sortOrders;
    private final HiveFileWriter outputWriter;
    private final SortBuffer sortBuffer;
    private final List<Path> tempFiles = new ArrayList<Path>();

    public SortingFileWriter(FileSystem fileSystem, Path tempFilePrefix, HiveFileWriter outputWriter, DataSize maxMemory, int maxTempFiles, List<Type> types, List<Integer> sortFields, List<SortOrder> sortOrders, PageSorter pageSorter) {
        Preconditions.checkArgument((maxTempFiles > 0 ? 1 : 0) != 0, (Object)"maxTempFiles must be greater than zero");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.tempFilePrefix = Objects.requireNonNull(tempFilePrefix, "tempFilePrefix is null");
        this.maxTempFiles = maxTempFiles;
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.sortFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortFields, "sortFields is null"));
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        this.outputWriter = Objects.requireNonNull(outputWriter, "outputWriter is null");
        this.sortBuffer = new SortBuffer(maxMemory, types, sortFields, sortOrders, pageSorter);
    }

    @Override
    public long getWrittenBytes() {
        return this.outputWriter.getWrittenBytes();
    }

    @Override
    public long getSystemMemoryUsage() {
        return (long)INSTANCE_SIZE + this.sortBuffer.getRetainedBytes();
    }

    @Override
    public void appendRows(Page page) {
        if (!this.sortBuffer.canAdd(page)) {
            this.flushToTempFile();
        }
        this.sortBuffer.add(page);
    }

    @Override
    public void commit() {
        if (!this.sortBuffer.isEmpty()) {
            if (this.tempFiles.isEmpty()) {
                this.sortBuffer.flushTo(this.outputWriter::appendRows);
                this.outputWriter.commit();
                return;
            }
            this.flushToTempFile();
        }
        try {
            this.writeSorted();
            this.outputWriter.commit();
            for (Path file : this.tempFiles) {
                this.fileSystem.delete(file, false);
                if (!this.fileSystem.exists(file)) continue;
                throw new IOException("Failed to delete temporary file: " + file);
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
    }

    @Override
    public void rollback() {
        for (Path file : this.tempFiles) {
            try {
                this.fileSystem.delete(file, false);
                if (!this.fileSystem.exists(file)) continue;
                throw new IOException("Delete failed");
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Failed to delete temporary file: " + file);
            }
        }
        this.outputWriter.rollback();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tempFilePrefix", (Object)this.tempFilePrefix).add("outputWriter", (Object)this.outputWriter).toString();
    }

    @Override
    public Optional<Runnable> getVerificationTask() {
        return this.outputWriter.getVerificationTask();
    }

    private void writeSorted() throws IOException {
        try (Closer closer = Closer.create();){
            ArrayList<Iterator<Page>> iterators = new ArrayList<Iterator<Page>>();
            for (Path file : this.tempFiles) {
                HdfsOrcDataSource dataSource = new HdfsOrcDataSource(new OrcDataSourceId(file.toString()), this.fileSystem.getFileStatus(file).getLen(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), false, this.fileSystem.open(file), new FileFormatDataSourceStats());
                closer.register((Closeable)((Object)dataSource));
                iterators.add((Iterator<Page>)((Object)new TempFileReader(this.types, (OrcDataSource)dataSource)));
            }
            new MergingPageIterator(iterators, this.types, this.sortFields, this.sortOrders).forEachRemaining(this.outputWriter::appendRows);
        }
    }

    private void flushToTempFile() {
        if (this.tempFiles.size() == this.maxTempFiles) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TOO_MANY_BUCKET_SORT_FILES, "Too many temporary files for sorted bucket writer");
        }
        Path tempFile = new Path(this.tempFilePrefix + "." + this.tempFiles.size());
        this.tempFiles.add(tempFile);
        try (TempFileWriter writer = new TempFileWriter(this.types, (OutputStream)this.fileSystem.create(tempFile));){
            this.sortBuffer.flushTo(writer::writePage);
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to write temporary file: " + tempFile, (Throwable)e);
        }
    }
}

