/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.authentication;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.authentication.AuthenticationModules;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import java.util.function.Predicate;

public class HiveAuthenticationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindAuthenticationModule(config -> config.getHiveMetastoreAuthenticationType() == HiveClientConfig.HiveMetastoreAuthenticationType.NONE, AuthenticationModules.noHiveMetastoreAuthenticationModule());
        this.bindAuthenticationModule(config -> config.getHiveMetastoreAuthenticationType() == HiveClientConfig.HiveMetastoreAuthenticationType.KERBEROS, AuthenticationModules.kerberosHiveMetastoreAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.noHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.noHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.noHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.simpleImpersonatingHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.kerberosHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.kerberosHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosImpersonatingHdfsAuthenticationModule());
    }

    private void bindAuthenticationModule(Predicate<HiveClientConfig> predicate, Module module) {
        this.install(ConditionalModule.installModuleIf(HiveClientConfig.class, predicate, (Module)module));
    }

    private static boolean noHdfsAuth(HiveClientConfig config) {
        return config.getHdfsAuthenticationType() == HiveClientConfig.HdfsAuthenticationType.NONE;
    }

    private static boolean kerberosHdfsAuth(HiveClientConfig config) {
        return config.getHdfsAuthenticationType() == HiveClientConfig.HdfsAuthenticationType.KERBEROS;
    }
}

