/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.authentication;

import com.facebook.presto.hive.ForHiveMetastore;
import com.facebook.presto.hive.authentication.HadoopAuthentication;
import com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import com.facebook.presto.hive.authentication.MetastoreKerberosConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.hive.thrift.client.TUGIAssumingTransport;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TTransport;

public class KerberosHiveMetastoreAuthentication
implements HiveMetastoreAuthentication {
    private final String hiveMetastoreServicePrincipal;
    private final HadoopAuthentication authentication;

    @Inject
    public KerberosHiveMetastoreAuthentication(MetastoreKerberosConfig config, @ForHiveMetastore HadoopAuthentication authentication) {
        this(config.getHiveMetastoreServicePrincipal(), authentication);
    }

    public KerberosHiveMetastoreAuthentication(String hiveMetastoreServicePrincipal, HadoopAuthentication authentication) {
        this.hiveMetastoreServicePrincipal = Objects.requireNonNull(hiveMetastoreServicePrincipal, "hiveMetastoreServicePrincipal is null");
        this.authentication = Objects.requireNonNull(authentication, "authentication is null");
    }

    @Override
    public TTransport authenticate(TTransport rawTransport, String hiveMetastoreHost) {
        try {
            String serverPrincipal = SecurityUtil.getServerPrincipal((String)this.hiveMetastoreServicePrincipal, (String)hiveMetastoreHost);
            String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
            Preconditions.checkState((names.length == 3 ? 1 : 0) != 0, (String)"Kerberos principal name does NOT have the expected hostname part: %s", (Object)serverPrincipal);
            ImmutableMap saslProps = ImmutableMap.of((Object)"javax.security.sasl.qop", (Object)"auth", (Object)"javax.security.sasl.server.authentication", (Object)"true");
            TSaslClientTransport saslTransport = new TSaslClientTransport(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), null, names[0], names[1], (Map)saslProps, null, rawTransport);
            return new TUGIAssumingTransport((TTransport)saslTransport, this.authentication.getUserGroupInformation());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

