/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.file;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.TableType;

public class PartitionMetadata {
    private final List<Column> columns;
    private final Map<String, String> parameters;
    private final Optional<HiveStorageFormat> storageFormat;
    private final Optional<HiveBucketProperty> bucketProperty;
    private final Map<String, String> serdeParameters;
    private final Optional<String> externalLocation;

    @JsonCreator
    public PartitionMetadata(@JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="parameters") Map<String, String> parameters, @JsonProperty(value="storageFormat") Optional<HiveStorageFormat> storageFormat, @JsonProperty(value="bucketProperty") Optional<HiveBucketProperty> bucketProperty, @JsonProperty(value="serdeParameters") Map<String, String> serdeParameters, @JsonProperty(value="externalLocation") Optional<String> externalLocation) {
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
        this.bucketProperty = Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.serdeParameters = Objects.requireNonNull(serdeParameters, "serdeParameters is null");
        this.externalLocation = Objects.requireNonNull(externalLocation, "externalLocation is null");
    }

    public PartitionMetadata(Table table, Partition partition) {
        this.columns = partition.getColumns();
        this.parameters = partition.getParameters();
        StorageFormat tableFormat = partition.getStorage().getStorageFormat();
        this.storageFormat = Arrays.stream(HiveStorageFormat.values()).filter(format -> tableFormat.equals(StorageFormat.fromHiveStorageFormat(format))).findFirst();
        this.externalLocation = table.getTableType().equals(TableType.EXTERNAL_TABLE.name()) ? Optional.of(partition.getStorage().getLocation()) : Optional.empty();
        this.bucketProperty = partition.getStorage().getBucketProperty();
        this.serdeParameters = partition.getStorage().getSerdeParameters();
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonProperty
    public Optional<HiveStorageFormat> getStorageFormat() {
        return this.storageFormat;
    }

    @JsonProperty
    public Optional<HiveBucketProperty> getBucketProperty() {
        return this.bucketProperty;
    }

    @JsonProperty
    public Map<String, String> getSerdeParameters() {
        return this.serdeParameters;
    }

    @JsonProperty
    public Optional<String> getExternalLocation() {
        return this.externalLocation;
    }

    public PartitionMetadata withParameters(Map<String, String> parameters) {
        Objects.requireNonNull(parameters, "parameters is null");
        return new PartitionMetadata(this.columns, parameters, this.storageFormat, this.bucketProperty, this.serdeParameters, this.externalLocation);
    }

    public Partition toPartition(String databaseName, String tableName, List<String> values, String location) {
        return new Partition(databaseName, tableName, values, Storage.builder().setLocation(this.externalLocation.orElse(location)).setStorageFormat(this.storageFormat.map(StorageFormat::fromHiveStorageFormat).orElse(StorageFormat.VIEW_STORAGE_FORMAT)).setBucketProperty(this.bucketProperty).setSerdeParameters(this.serdeParameters).build(), this.columns, this.parameters);
    }
}

