/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.BatchCreatePartitionRequest;
import com.amazonaws.services.glue.model.BatchCreatePartitionResult;
import com.amazonaws.services.glue.model.BatchGetPartitionRequest;
import com.amazonaws.services.glue.model.BatchGetPartitionResult;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeletePartitionRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.ErrorDetail;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabaseResult;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetPartitionRequest;
import com.amazonaws.services.glue.model.GetPartitionResult;
import com.amazonaws.services.glue.model.GetPartitionsRequest;
import com.amazonaws.services.glue.model.GetPartitionsResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTableResult;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.PartitionError;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.PartitionValueList;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateDatabaseRequest;
import com.amazonaws.services.glue.model.UpdatePartitionRequest;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.PartitionNotFoundException;
import com.facebook.presto.hive.SchemaAlreadyExistsException;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.glue.GlueExpressionUtil;
import com.facebook.presto.hive.metastore.glue.GlueHiveMetastoreConfig;
import com.facebook.presto.hive.metastore.glue.converter.GlueInputConverter;
import com.facebook.presto.hive.metastore.glue.converter.GlueToPrestoConverter;
import com.facebook.presto.spi.ColumnNotFoundException;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.Identity;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.airlift.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;

public class GlueHiveMetastore
implements ExtendedHiveMetastore {
    private static final Logger log = Logger.get(GlueHiveMetastore.class);
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String DEFAULT_METASTORE_USER = "presto";
    private static final String WILDCARD_EXPRESSION = "";
    private static final int BATCH_GET_PARTITION_MAX_PAGE_SIZE = 1000;
    private static final int BATCH_CREATE_PARTITION_MAX_PAGE_SIZE = 100;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final AWSGlueAsync glueClient;
    private final Optional<String> defaultDir;

    @Inject
    public GlueHiveMetastore(HdfsEnvironment hdfsEnvironment, GlueHiveMetastoreConfig glueConfig) {
        this(hdfsEnvironment, glueConfig, GlueHiveMetastore.createAsyncGlueClient(glueConfig));
    }

    public GlueHiveMetastore(HdfsEnvironment hdfsEnvironment, GlueHiveMetastoreConfig glueConfig, AWSGlueAsync glueClient) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hdfsContext = new HdfsEnvironment.HdfsContext(new Identity(DEFAULT_METASTORE_USER, Optional.empty()));
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.defaultDir = glueConfig.getDefaultWarehouseDir();
    }

    private static AWSGlueAsync createAsyncGlueClient(GlueHiveMetastoreConfig config) {
        Region currentRegion;
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxConnections(config.getMaxGlueConnections());
        AWSGlueAsyncClientBuilder asyncGlueClientBuilder = (AWSGlueAsyncClientBuilder)AWSGlueAsyncClientBuilder.standard().withClientConfiguration(clientConfig);
        if (config.getGlueRegion().isPresent()) {
            asyncGlueClientBuilder.setRegion(config.getGlueRegion().get());
        } else if (config.getPinGlueClientToCurrentRegion() && (currentRegion = Regions.getCurrentRegion()) != null) {
            asyncGlueClientBuilder.setRegion(currentRegion.getName());
        }
        return (AWSGlueAsync)asyncGlueClientBuilder.build();
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            GetDatabaseResult result = this.glueClient.getDatabase(new GetDatabaseRequest().withName(databaseName));
            return Optional.of(GlueToPrestoConverter.convertDatabase(result.getDatabase()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            ArrayList<String> databaseNames = new ArrayList<String>();
            String nextToken = null;
            do {
                GetDatabasesResult result = this.glueClient.getDatabases(new GetDatabasesRequest().withNextToken(nextToken));
                nextToken = result.getNextToken();
                result.getDatabaseList().forEach(database -> databaseNames.add(database.getName()));
            } while (nextToken != null);
            return databaseNames;
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        try {
            GetTableResult result = this.glueClient.getTable(new GetTableRequest().withDatabaseName(databaseName).withName(tableName));
            return Optional.of(GlueToPrestoConverter.convertTable(result.getTable(), databaseName));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private Table getTableOrElseThrow(String databaseName, String tableName) {
        return this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    @Override
    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName) {
        return ImmutableMap.of();
    }

    @Override
    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        return ImmutableMap.of();
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        try {
            GetTablesResult result;
            ArrayList tableNames = new ArrayList();
            String nextToken = null;
            do {
                result = this.glueClient.getTables(new GetTablesRequest().withDatabaseName(databaseName).withNextToken(nextToken));
                result.getTableList().forEach(table -> tableNames.add(table.getName()));
            } while ((nextToken = result.getNextToken()) != null);
            return Optional.of(tableNames);
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        try {
            GetTablesResult result;
            ArrayList views = new ArrayList();
            String nextToken = null;
            do {
                result = this.glueClient.getTables(new GetTablesRequest().withDatabaseName(databaseName).withNextToken(nextToken));
                result.getTableList().stream().filter(table -> TableType.VIRTUAL_VIEW.name().equals(table.getTableType())).forEach(table -> views.add(table.getName()));
            } while ((nextToken = result.getNextToken()) != null);
            return Optional.of(views);
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createDatabase(Database database) {
        if (!database.getLocation().isPresent() && this.defaultDir.isPresent()) {
            String databaseLocation = new Path(this.defaultDir.get(), database.getDatabaseName()).toString();
            database = Database.builder(database).setLocation(Optional.of(databaseLocation)).build();
        }
        try {
            DatabaseInput databaseInput = GlueInputConverter.convertDatabase(database);
            this.glueClient.createDatabase(new CreateDatabaseRequest().withDatabaseInput(databaseInput));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getDatabaseName());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        if (database.getLocation().isPresent()) {
            HiveWriteUtils.createDirectory(this.hdfsContext, this.hdfsEnvironment, new Path(database.getLocation().get()));
        }
    }

    @Override
    public void dropDatabase(String databaseName) {
        try {
            this.glueClient.deleteDatabase(new DeleteDatabaseRequest().withName(databaseName));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            Database database = this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
            DatabaseInput renamedDatabase = GlueInputConverter.convertDatabase(database).withName(newDatabaseName);
            this.glueClient.updateDatabase(new UpdateDatabaseRequest().withName(databaseName).withDatabaseInput(renamedDatabase));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        try {
            TableInput input = GlueInputConverter.convertTable(table);
            this.glueClient.createTable(new CreateTableRequest().withDatabaseName(table.getDatabaseName()).withTableInput(input));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDatabaseName(), table.getTableName()));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(table.getDatabaseName());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        try {
            this.glueClient.deleteTable(new DeleteTableRequest().withDatabaseName(databaseName).withName(tableName));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        String tableLocation = table.getStorage().getLocation();
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)tableLocation)) {
            GlueHiveMetastore.deleteDir(this.hdfsContext, this.hdfsEnvironment, new Path(tableLocation), true);
        }
    }

    private static boolean isManagedTable(Table table) {
        return table.getTableType().equals(TableType.MANAGED_TABLE.name());
    }

    private static void deleteDir(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path, boolean recursive) {
        try {
            hdfsEnvironment.getFileSystem(context, path).delete(path, recursive);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to delete path: " + path.toString());
        }
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        try {
            TableInput newTableInput = GlueInputConverter.convertTable(newTable);
            this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(databaseName).withTableInput(newTableInput));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename is not yet supported by Glue service");
    }

    @Override
    public synchronized void updateTableParameters(String databaseName, String tableName, Function<Map<String, String>, Map<String, String>> update) {
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        try {
            Map<String, String> parameters = table.getParameters();
            Map<String, String> updatedParameters = Objects.requireNonNull(update.apply(parameters), "updatedParameters is null");
            if (!parameters.equals(updatedParameters)) {
                TableInput tableInput = GlueInputConverter.convertTable(table);
                tableInput.setParameters(updatedParameters);
                this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(databaseName).withTableInput(tableInput));
            }
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Table oldTable = this.getTableOrElseThrow(databaseName, tableName);
        Table newTable = Table.builder(oldTable).addDataColumn(new Column(columnName, columnType, Optional.ofNullable(columnComment))).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Table oldTable = this.getTableOrElseThrow(databaseName, tableName);
        if (oldTable.getPartitionColumns().stream().anyMatch(c -> c.getName().equals(oldColumnName))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        for (Column column : oldTable.getDataColumns()) {
            if (column.getName().equals(oldColumnName)) {
                newDataColumns.add((Object)new Column(newColumnName, column.getType(), column.getComment()));
                continue;
            }
            newDataColumns.add((Object)column);
        }
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, databaseName, tableName, columnName);
        Table oldTable = this.getTableOrElseThrow(databaseName, tableName);
        if (!oldTable.getColumn(columnName).isPresent()) {
            SchemaTableName name = new SchemaTableName(databaseName, tableName);
            throw new ColumnNotFoundException(name, columnName);
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        oldTable.getDataColumns().stream().filter(fieldSchema -> !fieldSchema.getName().equals(columnName)).forEach(arg_0 -> ((ImmutableList.Builder)newDataColumns).add(arg_0));
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        try {
            GetPartitionResult result = this.glueClient.getPartition(new GetPartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionValues(partitionValues));
            return Optional.of(GlueToPrestoConverter.convertPartition(result.getPartition()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        List<Partition> partitions = this.getPartitions(databaseName, tableName, WILDCARD_EXPRESSION);
        return Optional.of(GlueHiveMetastore.buildPartitionNames(table.getPartitionColumns(), partitions));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) {
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        String expression = GlueExpressionUtil.buildGlueExpression(table.getPartitionColumns(), parts);
        List<Partition> partitions = this.getPartitions(databaseName, tableName, expression);
        return Optional.of(GlueHiveMetastore.buildPartitionNames(table.getPartitionColumns(), partitions));
    }

    private List<Partition> getPartitions(String databaseName, String tableName, String expression) {
        try {
            GetPartitionsResult result;
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            String nextToken = null;
            do {
                result = this.glueClient.getPartitions(new GetPartitionsRequest().withDatabaseName(databaseName).withTableName(tableName).withExpression(expression).withNextToken(nextToken));
                result.getPartitions().forEach(partition -> partitions.add(GlueToPrestoConverter.convertPartition(partition)));
            } while ((nextToken = result.getNextToken()) != null);
            return partitions;
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private static List<String> buildPartitionNames(List<Column> partitionColumns, List<Partition> partitions) {
        return partitions.stream().map(partition -> MetastoreUtil.makePartName(partitionColumns, partition.getValues())).collect(Collectors.toList());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        List<Partition> partitions = this.batchGetPartition(databaseName, tableName, partitionNames);
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), HiveUtil::toPartitionValues));
        Map partitionValuesToPartitionMap = partitions.stream().collect(Collectors.toMap(Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            Partition partition = (Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put(entry.getKey(), Optional.ofNullable(partition));
        }
        return resultBuilder.build();
    }

    private List<Partition> batchGetPartition(String databaseName, String tableName, List<String> partitionNames) {
        try {
            List partitionValueLists = partitionNames.stream().map(partitionName -> new PartitionValueList().withValues(HiveUtil.toPartitionValues(partitionName))).collect(Collectors.toList());
            List batchedPartitionValueLists = Lists.partition(partitionValueLists, (int)1000);
            ArrayList<Future> batchGetPartitionFutures = new ArrayList<Future>();
            ArrayList<Partition> result = new ArrayList<Partition>();
            for (List partitions : batchedPartitionValueLists) {
                batchGetPartitionFutures.add(this.glueClient.batchGetPartitionAsync(new BatchGetPartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionsToGet((Collection)partitions)));
            }
            for (Future future : batchGetPartitionFutures) {
                ((BatchGetPartitionResult)future.get()).getPartitions().forEach(partition -> result.add(GlueToPrestoConverter.convertPartition(partition)));
            }
            return result;
        }
        catch (AmazonServiceException | InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<Partition> partitions) {
        try {
            List batchedPartitions = Lists.partition(partitions, (int)100);
            ArrayList<Future> futures = new ArrayList<Future>();
            for (List partitionBatch : batchedPartitions) {
                List partitionInputs = partitionBatch.stream().map(GlueInputConverter::convertPartition).collect(Collectors.toList());
                futures.add(this.glueClient.batchCreatePartitionAsync(new BatchCreatePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionInputList(partitionInputs)));
            }
            for (Future future : futures) {
                BatchCreatePartitionResult result = (BatchCreatePartitionResult)future.get();
                GlueHiveMetastore.propagatePartitionErrorToPrestoException(databaseName, tableName, result.getErrors());
            }
        }
        catch (AmazonServiceException | InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
    }

    private static void propagatePartitionErrorToPrestoException(String databaseName, String tableName, List<PartitionError> partitionErrors) {
        if (partitionErrors != null && !partitionErrors.isEmpty()) {
            String glueExceptionCode;
            ErrorDetail errorDetail = partitionErrors.get(0).getErrorDetail();
            switch (glueExceptionCode = errorDetail.getErrorCode()) {
                case "AlreadyExistsException": {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, errorDetail.getErrorMessage());
                }
                case "EntityNotFoundException": {
                    throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), errorDetail.getErrorMessage());
                }
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, errorDetail.getErrorCode() + ": " + errorDetail.getErrorMessage());
        }
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        Table table = this.getTableOrElseThrow(databaseName, tableName);
        Partition partition = this.getPartition(databaseName, tableName, parts).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts));
        try {
            this.glueClient.deletePartition(new DeletePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionValues(parts));
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        String partLocation = partition.getStorage().getLocation();
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)partLocation)) {
            GlueHiveMetastore.deleteDir(this.hdfsContext, this.hdfsEnvironment, new Path(partLocation), true);
        }
    }

    @Override
    public void alterPartition(String databaseName, String tableName, Partition partition) {
        try {
            PartitionInput newPartition = GlueInputConverter.convertPartition(partition);
            this.glueClient.updatePartition(new UpdatePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionInput(newPartition).withPartitionValueList(partition.getValues()));
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getValues());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public synchronized void updatePartitionParameters(String databaseName, String tableName, List<String> partitionValues, Function<Map<String, String>, Map<String, String>> update) {
        Partition partition = this.getPartition(databaseName, tableName, partitionValues).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues));
        try {
            Map<String, String> parameters = partition.getParameters();
            Map<String, String> updatedParameters = Objects.requireNonNull(update.apply(parameters), "updatedParameters is null");
            if (!parameters.equals(updatedParameters)) {
                PartitionInput partitionInput = GlueInputConverter.convertPartition(partition);
                partitionInput.setParameters(updatedParameters);
                this.glueClient.updatePartition(new UpdatePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionValueList(partition.getValues()).withPartitionInput(partitionInput));
            }
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getValues());
        }
        catch (AmazonServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Set<String> getRoles(String user) {
        return ImmutableSet.builder().add((Object)PUBLIC_ROLE_NAME).build();
    }

    @Override
    public Set<HivePrivilegeInfo> getDatabasePrivileges(String user, String databaseName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "getDatabasePrivileges is not supported by Glue");
    }

    @Override
    public Set<HivePrivilegeInfo> getTablePrivileges(String user, String databaseName, String tableName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "getTablePrivileges is not supported by Glue");
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String grantee, Set<HivePrivilegeInfo> privileges) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantTablePrivileges is not supported by Glue");
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String grantee, Set<HivePrivilegeInfo> privileges) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeTablePrivileges is not supported by Glue");
    }
}

