/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.PartitionNotFoundException;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;

public class BridgingHiveMetastore
implements ExtendedHiveMetastore {
    private final HiveMetastore delegate;

    @Inject
    public BridgingHiveMetastore(HiveMetastore delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName).map(ThriftMetastoreUtil::fromMetastoreApiDatabase);
    }

    @Override
    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return this.delegate.getTable(databaseName, tableName).map(ThriftMetastoreUtil::fromMetastoreApiTable);
    }

    @Override
    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName) {
        Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        Set dataColumns = (Set)table.getDataColumns().stream().map(Column::getName).collect(ImmutableSet.toImmutableSet());
        return this.groupStatisticsByColumn(this.delegate.getTableColumnStatistics(databaseName, tableName, dataColumns));
    }

    @Override
    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        Set dataColumns = (Set)table.getDataColumns().stream().map(Column::getName).collect(ImmutableSet.toImmutableSet());
        Map<String, Set<ColumnStatisticsObj>> statistics = this.delegate.getPartitionColumnStatistics(databaseName, tableName, partitionNames, dataColumns);
        return (Map)statistics.entrySet().stream().filter(entry -> !((Set)entry.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.groupStatisticsByColumn((Set)entry.getValue())));
    }

    private Map<String, HiveColumnStatistics> groupStatisticsByColumn(Set<ColumnStatisticsObj> statistics) {
        return (Map)statistics.stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsObj::getColName, ThriftMetastoreUtil::fromMetastoreApiColumnStatistics));
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    @Override
    public void createDatabase(Database database) {
        this.delegate.createDatabase(ThriftMetastoreUtil.toMetastoreApiDatabase(database));
    }

    @Override
    public void dropDatabase(String databaseName) {
        this.delegate.dropDatabase(databaseName);
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        org.apache.hadoop.hive.metastore.api.Database database = this.delegate.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
        database.setName(newDatabaseName);
        this.delegate.alterDatabase(databaseName, database);
        this.delegate.getDatabase(databaseName).ifPresent(newDatabase -> {
            if (newDatabase.getName().equals(databaseName)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive metastore does not support renaming schemas");
            }
        });
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        this.delegate.createTable(ThriftMetastoreUtil.toMetastoreApiTable(table, principalPrivileges));
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        this.delegate.dropTable(databaseName, tableName, deleteData);
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.alterTable(databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiTable(newTable, principalPrivileges));
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(databaseName, tableName);
        if (!source.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        table.setDbName(newDatabaseName);
        table.setTableName(newTableName);
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public synchronized void updateTableParameters(String databaseName, String tableName, Function<Map<String, String>, Map<String, String>> update) {
        Map<String, String> updatedParameters;
        org.apache.hadoop.hive.metastore.api.Table table = this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        Map parameters = table.getParameters();
        if (!parameters.equals(updatedParameters = Objects.requireNonNull(update.apply(parameters), "updatedParameters is null"))) {
            table.setParameters(updatedParameters);
            this.alterTable(databaseName, tableName, table);
        }
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(databaseName, tableName);
        if (!source.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        table.getSd().getCols().add(new FieldSchema(columnName, columnType.getHiveTypeName().toString(), columnComment));
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(databaseName, tableName);
        if (!source.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        for (FieldSchema fieldSchema : table.getPartitionKeys()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        for (FieldSchema fieldSchema : table.getSd().getCols()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            fieldSchema.setName(newColumnName);
        }
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, databaseName, tableName, columnName);
        org.apache.hadoop.hive.metastore.api.Table table = this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        table.getSd().getCols().removeIf(fieldSchema -> fieldSchema.getName().equals(columnName));
        this.alterTable(databaseName, tableName, table);
    }

    private void alterTable(String databaseName, String tableName, org.apache.hadoop.hive.metastore.api.Table table) {
        this.delegate.alterTable(databaseName, tableName, table);
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        return this.delegate.getPartition(databaseName, tableName, partitionValues).map(ThriftMetastoreUtil::fromMetastoreApiPartition);
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        return this.delegate.getPartitionNames(databaseName, tableName);
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) {
        return this.delegate.getPartitionNamesByParts(databaseName, tableName, parts);
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), HiveUtil::toPartitionValues));
        Map partitionValuesToPartitionMap = this.delegate.getPartitionsByNames(databaseName, tableName, partitionNames).stream().map(ThriftMetastoreUtil::fromMetastoreApiPartition).collect(Collectors.toMap(Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            Partition partition = (Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put(entry.getKey(), Optional.ofNullable(partition));
        }
        return resultBuilder.build();
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<Partition> partitions) {
        this.delegate.addPartitions(databaseName, tableName, partitions.stream().map(ThriftMetastoreUtil::toMetastoreApiPartition).collect(Collectors.toList()));
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
    }

    @Override
    public void alterPartition(String databaseName, String tableName, Partition partition) {
        this.delegate.alterPartition(databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiPartition(partition));
    }

    @Override
    public synchronized void updatePartitionParameters(String databaseName, String tableName, List<String> partitionValues, Function<Map<String, String>, Map<String, String>> update) {
        Map<String, String> updatedParameters;
        org.apache.hadoop.hive.metastore.api.Partition partition = this.delegate.getPartition(databaseName, tableName, partitionValues).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues));
        Map parameters = partition.getParameters();
        if (!parameters.equals(updatedParameters = Objects.requireNonNull(update.apply(parameters), "updatedParameters is null"))) {
            partition.setParameters(updatedParameters);
            this.delegate.alterPartition(databaseName, tableName, partition);
        }
    }

    @Override
    public Set<String> getRoles(String user) {
        return this.delegate.getRoles(user);
    }

    @Override
    public Set<HivePrivilegeInfo> getDatabasePrivileges(String user, String databaseName) {
        return this.delegate.getDatabasePrivileges(user, databaseName);
    }

    @Override
    public Set<HivePrivilegeInfo> getTablePrivileges(String user, String databaseName, String tableName) {
        return this.delegate.getTablePrivileges(user, databaseName, tableName);
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String grantee, Set<HivePrivilegeInfo> privileges) {
        Set<PrivilegeGrantInfo> privilegeGrantInfos = privileges.stream().map(privilege -> ThriftMetastoreUtil.toMetastoreApiPrivilegeGrantInfo(grantee, privilege)).collect(Collectors.toSet());
        this.delegate.grantTablePrivileges(databaseName, tableName, grantee, privilegeGrantInfos);
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String grantee, Set<HivePrivilegeInfo> privileges) {
        Set<PrivilegeGrantInfo> privilegeGrantInfos = privileges.stream().map(privilege -> ThriftMetastoreUtil.toMetastoreApiPrivilegeGrantInfo(grantee, privilege)).collect(Collectors.toSet());
        this.delegate.revokeTablePrivileges(databaseName, tableName, grantee, privilegeGrantInfos);
    }
}

