/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.parquet.ParquetDataSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsParquetDataSource
implements ParquetDataSource {
    private final String name;
    private final long size;
    private final FSDataInputStream inputStream;
    private long readBytes;
    private final FileFormatDataSourceStats stats;

    public HdfsParquetDataSource(Path path, long size, FSDataInputStream inputStream, FileFormatDataSourceStats stats) {
        this.name = path.toString();
        this.size = size;
        this.inputStream = inputStream;
        this.stats = stats;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public final void readFully(long position, byte[] buffer) {
        this.readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public final void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        this.readInternal(position, buffer, bufferOffset, bufferLength);
        this.readBytes += (long)bufferLength;
    }

    private void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        try {
            long readStart = System.nanoTime();
            this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
            this.stats.readDataBytesPerSecond(bufferLength, System.nanoTime() - readStart);
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error reading from %s at position %s", this.name, position), (Throwable)e);
        }
    }

    public static HdfsParquetDataSource buildHdfsParquetDataSource(FileSystem fileSystem, Path path, long start, long length, long fileSize, FileFormatDataSourceStats stats) {
        try {
            FSDataInputStream inputStream = fileSystem.open(path);
            return new HdfsParquetDataSource(path, fileSize, inputStream, stats);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage()), (Throwable)e);
        }
    }

    public static HdfsParquetDataSource buildHdfsParquetDataSource(FSDataInputStream inputStream, Path path, long fileSize, FileFormatDataSourceStats stats) {
        return new HdfsParquetDataSource(path, fileSize, inputStream, stats);
    }
}

