/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.parquet.Field;
import com.facebook.presto.hive.parquet.ParquetCorruptionException;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import com.facebook.presto.hive.parquet.reader.ParquetReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import parquet.io.ColumnIOConverter;
import parquet.io.MessageColumnIO;
import parquet.schema.MessageType;
import parquet.schema.Type;

public class ParquetPageSource
implements ConnectorPageSource {
    private static final int MAX_VECTOR_LENGTH = 1024;
    private final ParquetReader parquetReader;
    private final MessageType fileSchema;
    private final List<String> columnNames;
    private final List<com.facebook.presto.spi.type.Type> types;
    private final List<Optional<Field>> fields;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int batchId;
    private boolean closed;
    private long readTimeNanos;
    private final boolean useParquetColumnNames;

    public ParquetPageSource(ParquetReader parquetReader, MessageType fileSchema, MessageColumnIO messageColumnIO, TypeManager typeManager, Properties splitSchema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, boolean useParquetColumnNames) {
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.parquetReader = Objects.requireNonNull(parquetReader, "parquetReader is null");
        this.fileSchema = Objects.requireNonNull(fileSchema, "fileSchema is null");
        this.useParquetColumnNames = useParquetColumnNames;
        int size = columns.size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            Preconditions.checkState((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (Object)"column type must be regular");
            String name = column.getName();
            com.facebook.presto.spi.type.Type type = typeManager.getType(column.getTypeSignature());
            namesBuilder.add((Object)name);
            typesBuilder.add((Object)type);
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
            if (ParquetTypeUtils.getParquetType(column, fileSchema, useParquetColumnNames) == null) {
                this.constantBlocks[columnIndex] = RunLengthEncodedBlock.create((com.facebook.presto.spi.type.Type)type, null, (int)1024);
                fieldsBuilder.add(Optional.empty());
                continue;
            }
            String columnName = useParquetColumnNames ? name : ((Type)fileSchema.getFields().get(column.getHiveColumnIndex())).getName();
            fieldsBuilder.add(ColumnIOConverter.constructField(type, messageColumnIO.getChild(columnName)));
        }
        this.types = typesBuilder.build();
        this.fields = fieldsBuilder.build();
        this.columnNames = namesBuilder.build();
    }

    public long getCompletedBytes() {
        return this.parquetReader.getDataSource().getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.closed;
    }

    public long getSystemMemoryUsage() {
        return this.parquetReader.getSystemMemoryContext().getBytes();
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            long start = System.nanoTime();
            int batchSize = this.parquetReader.nextBatch();
            this.readTimeNanos += System.nanoTime() - start;
            if (this.closed || batchSize <= 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                if (this.constantBlocks[fieldId] != null) {
                    blocks[fieldId] = this.constantBlocks[fieldId].getRegion(0, batchSize);
                    continue;
                }
                com.facebook.presto.spi.type.Type type = this.types.get(fieldId);
                Optional<Field> field = this.fields.get(fieldId);
                int fieldIndex = this.useParquetColumnNames ? ParquetTypeUtils.getFieldIndex(this.fileSchema, this.columnNames.get(fieldId)) : this.hiveColumnIndexes[fieldId];
                blocks[fieldId] = fieldIndex != -1 && field.isPresent() ? new LazyBlock(batchSize, (LazyBlockLoader)new ParquetBlockLoader(field.get())) : RunLengthEncodedBlock.create((com.facebook.presto.spi.type.Type)type, null, (int)batchSize);
            }
            return new Page(batchSize, blocks);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (e == throwable) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final class ParquetBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final Field field;
        private boolean loaded;

        public ParquetBlockLoader(Field field) {
            this.expectedBatchId = ParquetPageSource.this.batchId;
            this.field = Objects.requireNonNull(field, "field is null");
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((ParquetPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                Block block = ParquetPageSource.this.parquetReader.readBlock(this.field);
                lazyBlock.setBlock(block);
            }
            catch (ParquetCorruptionException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

