/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetPageSource;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import com.facebook.presto.hive.parquet.RichColumnDescriptor;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicate;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicateUtils;
import com.facebook.presto.hive.parquet.reader.ParquetMetadataReader;
import com.facebook.presto.hive.parquet.reader.ParquetReader;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;
import parquet.column.ColumnDescriptor;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.io.MessageColumnIO;
import parquet.schema.MessageType;

public class ParquetPageSourceFactory
implements HivePageSourceFactory {
    private static final Set<String> PARQUET_SERDE_CLASS_NAMES = ImmutableSet.builder().add((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").add((Object)"parquet.hive.serde.ParquetHiveSerDe").build();
    private final TypeManager typeManager;
    private final boolean useParquetColumnNames;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;

    @Inject
    public ParquetPageSourceFactory(TypeManager typeManager, HiveClientConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats) {
        this(typeManager, Objects.requireNonNull(config, "hiveClientConfig is null").isUseParquetColumnNames(), hdfsEnvironment, stats);
    }

    public ParquetPageSourceFactory(TypeManager typeManager, boolean useParquetColumnNames, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.useParquetColumnNames = useParquetColumnNames;
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone) {
        if (!HiveSessionProperties.isParquetOptimizedReaderEnabled(session)) {
            return Optional.empty();
        }
        if (!PARQUET_SERDE_CLASS_NAMES.contains(HiveUtil.getDeserializerClassName(schema))) {
            return Optional.empty();
        }
        return Optional.of(ParquetPageSourceFactory.createParquetPageSource(this.hdfsEnvironment, session.getUser(), configuration, path, start, length, fileSize, schema, columns, this.useParquetColumnNames, this.typeManager, HiveSessionProperties.isParquetPredicatePushdownEnabled(session), effectivePredicate, this.stats));
    }

    public static ParquetPageSource createParquetPageSource(HdfsEnvironment hdfsEnvironment, String user, Configuration configuration, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, boolean useParquetColumnNames, TypeManager typeManager, boolean predicatePushdownEnabled, TupleDomain<HiveColumnHandle> effectivePredicate, FileFormatDataSourceStats stats) {
        AggregatedMemoryContext systemMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        ParquetDataSource dataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FSDataInputStream inputStream = fileSystem.open(path);
            ParquetMetadata parquetMetadata = ParquetMetadataReader.readFooter(inputStream, path, fileSize);
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            dataSource = HdfsParquetDataSource.buildHdfsParquetDataSource(inputStream, path, fileSize, stats);
            List fields = columns.stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).map(column -> ParquetTypeUtils.getParquetType(column, fileSchema, useParquetColumnNames)).filter(Objects::nonNull).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), fields);
            List<Object> blocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block2 : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block2.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < start || firstDataPage >= start + length) continue;
                blocks.add(block2);
            }
            if (predicatePushdownEnabled) {
                Map<List<String>, RichColumnDescriptor> descriptorsByPath = ParquetTypeUtils.getDescriptors(fileSchema, requestedSchema);
                TupleDomain<ColumnDescriptor> parquetTupleDomain = ParquetPredicateUtils.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
                ParquetPredicate parquetPredicate = ParquetPredicateUtils.buildParquetPredicate(requestedSchema, parquetTupleDomain, descriptorsByPath);
                ParquetDataSource finalDataSource = dataSource;
                blocks = blocks.stream().filter(block -> ParquetPredicateUtils.predicateMatches(parquetPredicate, block, finalDataSource, descriptorsByPath, parquetTupleDomain)).collect(Collectors.toList());
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO(fileSchema, requestedSchema);
            ParquetReader parquetReader = new ParquetReader(messageColumnIO, blocks, dataSource, systemMemoryContext);
            return new ParquetPageSource(parquetReader, fileSchema, messageColumnIO, typeManager, schema, columns, effectivePredicate, useParquetColumnNames);
        }
        catch (Exception e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException inputStream) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)((Object)e);
            }
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }
}

