/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.RichColumnDescriptor;
import com.facebook.presto.hive.parquet.reader.ParquetPrimitiveColumnReader;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import java.math.BigInteger;
import parquet.io.api.Binary;

public class ParquetLongDecimalColumnReader
extends ParquetPrimitiveColumnReader {
    ParquetLongDecimalColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            Binary value = this.valuesReader.readBytes();
            type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((BigInteger)new BigInteger(value.getBytes())));
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

