/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.Field;
import com.facebook.presto.hive.parquet.ParquetDataPage;
import com.facebook.presto.hive.parquet.ParquetDataPageV1;
import com.facebook.presto.hive.parquet.ParquetDataPageV2;
import com.facebook.presto.hive.parquet.ParquetDictionaryPage;
import com.facebook.presto.hive.parquet.ParquetEncoding;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import com.facebook.presto.hive.parquet.ParquetValuesType;
import com.facebook.presto.hive.parquet.RichColumnDescriptor;
import com.facebook.presto.hive.parquet.dictionary.ParquetDictionary;
import com.facebook.presto.hive.parquet.reader.ColumnChunk;
import com.facebook.presto.hive.parquet.reader.ParquetBinaryColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetBooleanColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetDecimalColumnReaderFactory;
import com.facebook.presto.hive.parquet.reader.ParquetDoubleColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetFloatColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetIntColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetLevelNullReader;
import com.facebook.presto.hive.parquet.reader.ParquetLevelRLEReader;
import com.facebook.presto.hive.parquet.reader.ParquetLevelReader;
import com.facebook.presto.hive.parquet.reader.ParquetLevelValuesReader;
import com.facebook.presto.hive.parquet.reader.ParquetLongColumnReader;
import com.facebook.presto.hive.parquet.reader.ParquetPageReader;
import com.facebook.presto.hive.parquet.reader.ParquetTimestampColumnReader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import parquet.bytes.BytesUtils;
import parquet.column.ColumnDescriptor;
import parquet.column.values.ValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import parquet.io.ParquetDecodingException;

public abstract class ParquetPrimitiveColumnReader {
    private static final int EMPTY_LEVEL_VALUE = -1;
    protected final RichColumnDescriptor columnDescriptor;
    protected int definitionLevel = -1;
    protected int repetitionLevel = -1;
    protected ValuesReader valuesReader;
    private int nextBatchSize;
    private ParquetLevelReader repetitionReader;
    private ParquetLevelReader definitionReader;
    private long totalValueCount;
    private ParquetPageReader pageReader;
    private ParquetDictionary dictionary;
    private int currentValueCount;
    private ParquetDataPage page;
    private int remainingValueCountInPage;
    private int readOffset;

    protected abstract void readValue(BlockBuilder var1, Type var2);

    protected abstract void skipValue();

    protected boolean isValueNull() {
        return ParquetTypeUtils.isValueNull(this.columnDescriptor.isRequired(), this.definitionLevel, this.columnDescriptor.getMaxDefinitionLevel());
    }

    public static ParquetPrimitiveColumnReader createReader(RichColumnDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BOOLEAN: {
                return new ParquetBooleanColumnReader(descriptor);
            }
            case INT32: {
                return ParquetPrimitiveColumnReader.createDecimalColumnReader(descriptor).orElse(new ParquetIntColumnReader(descriptor));
            }
            case INT64: {
                return ParquetPrimitiveColumnReader.createDecimalColumnReader(descriptor).orElse(new ParquetLongColumnReader(descriptor));
            }
            case INT96: {
                return new ParquetTimestampColumnReader(descriptor);
            }
            case FLOAT: {
                return new ParquetFloatColumnReader(descriptor);
            }
            case DOUBLE: {
                return new ParquetDoubleColumnReader(descriptor);
            }
            case BINARY: {
                return ParquetPrimitiveColumnReader.createDecimalColumnReader(descriptor).orElse(new ParquetBinaryColumnReader(descriptor));
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return ParquetPrimitiveColumnReader.createDecimalColumnReader(descriptor).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Parquet type FIXED_LEN_BYTE_ARRAY supported as DECIMAL; got " + descriptor.getPrimitiveType().getOriginalType()));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported parquet type: " + descriptor.getType());
    }

    private static Optional<ParquetPrimitiveColumnReader> createDecimalColumnReader(RichColumnDescriptor descriptor) {
        Optional<Type> type = ParquetTypeUtils.createDecimalType(descriptor);
        if (type.isPresent()) {
            DecimalType decimalType = (DecimalType)type.get();
            return Optional.of(ParquetDecimalColumnReaderFactory.createReader(descriptor, decimalType.getPrecision(), decimalType.getScale()));
        }
        return Optional.empty();
    }

    public ParquetPrimitiveColumnReader(RichColumnDescriptor columnDescriptor) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor");
        this.pageReader = null;
    }

    public ParquetPageReader getPageReader() {
        return this.pageReader;
    }

    public void setPageReader(ParquetPageReader pageReader) {
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader");
        ParquetDictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(this.columnDescriptor, dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + (Object)((Object)this.columnDescriptor), (Throwable)e);
            }
        } else {
            this.dictionary = null;
        }
        Preconditions.checkArgument((pageReader.getTotalValueCount() > 0L ? 1 : 0) != 0, (Object)"page is empty");
        this.totalValueCount = pageReader.getTotalValueCount();
    }

    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    public ColumnDescriptor getDescriptor() {
        return this.columnDescriptor;
    }

    public ColumnChunk readPrimitive(Field field) throws IOException {
        int valueCount;
        int valuesToRead;
        IntArrayList definitionLevels = new IntArrayList();
        IntArrayList repetitionLevels = new IntArrayList();
        this.seek();
        BlockBuilder blockBuilder = field.getType().createBlockBuilder(null, this.nextBatchSize);
        for (valueCount = 0; valueCount < this.nextBatchSize; valueCount += valuesToRead) {
            if (this.page == null) {
                this.readNextPage();
            }
            valuesToRead = Math.min(this.remainingValueCountInPage, this.nextBatchSize - valueCount);
            this.readValues(blockBuilder, valuesToRead, field.getType(), (IntList)definitionLevels, (IntList)repetitionLevels);
        }
        Preconditions.checkArgument((valueCount == this.nextBatchSize ? 1 : 0) != 0, (String)"valueCount %s not equals to batchSize %s", (int)valueCount, (int)this.nextBatchSize);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return new ColumnChunk(blockBuilder.build(), definitionLevels.toIntArray(), repetitionLevels.toIntArray());
    }

    private void readValues(BlockBuilder blockBuilder, int valuesToRead, Type type, IntList definitionLevels, IntList repetitionLevels) {
        this.processValues(valuesToRead, ignored -> {
            this.readValue(blockBuilder, type);
            definitionLevels.add(this.definitionLevel);
            repetitionLevels.add(this.repetitionLevel);
        });
    }

    private void skipValues(int valuesToRead) {
        this.processValues(valuesToRead, ignored -> this.skipValue());
    }

    private void processValues(int valuesToRead, Consumer<Void> valueConsumer) {
        if (this.definitionLevel == -1 && this.repetitionLevel == -1) {
            this.definitionLevel = this.definitionReader.readLevel();
            this.repetitionLevel = this.repetitionReader.readLevel();
        }
        int valueCount = 0;
        for (int i = 0; i < valuesToRead; ++i) {
            do {
                valueConsumer.accept(null);
                if (++valueCount == this.remainingValueCountInPage) {
                    this.updateValueCounts(valueCount);
                    if (!this.readNextPage()) {
                        return;
                    }
                    valueCount = 0;
                }
                this.repetitionLevel = this.repetitionReader.readLevel();
                this.definitionLevel = this.definitionReader.readLevel();
            } while (this.repetitionLevel != 0);
        }
        this.updateValueCounts(valueCount);
    }

    private void seek() {
        int valuePosition;
        int offset;
        Preconditions.checkArgument(((long)this.currentValueCount <= this.totalValueCount ? 1 : 0) != 0, (Object)"Already read all values in column chunk");
        if (this.readOffset == 0) {
            return;
        }
        for (valuePosition = 0; valuePosition < this.readOffset; valuePosition += offset) {
            if (this.page == null) {
                this.readNextPage();
            }
            offset = Math.min(this.remainingValueCountInPage, this.readOffset - valuePosition);
            this.skipValues(offset);
        }
        Preconditions.checkArgument((valuePosition == this.readOffset ? 1 : 0) != 0, (String)"valuePosition %s must be equal to readOffset %s", (int)valuePosition, (int)this.readOffset);
    }

    private boolean readNextPage() {
        Verify.verify((this.page == null ? 1 : 0) != 0, (String)"readNextPage has to be called when page is null", (Object[])new Object[0]);
        this.page = this.pageReader.readPage();
        if (this.page == null) {
            return false;
        }
        this.remainingValueCountInPage = this.page.getValueCount();
        this.valuesReader = this.page instanceof ParquetDataPageV1 ? this.readPageV1((ParquetDataPageV1)this.page) : this.readPageV2((ParquetDataPageV2)this.page);
        return true;
    }

    private void updateValueCounts(int valuesRead) {
        if (valuesRead == this.remainingValueCountInPage) {
            this.page = null;
            this.valuesReader = null;
        }
        this.remainingValueCountInPage -= valuesRead;
        this.currentValueCount += valuesRead;
    }

    private ValuesReader readPageV1(ParquetDataPageV1 page) {
        ValuesReader rlReader = page.getRepetitionLevelEncoding().getValuesReader(this.columnDescriptor, ParquetValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDefinitionLevelEncoding().getValuesReader(this.columnDescriptor, ParquetValuesType.DEFINITION_LEVEL);
        this.repetitionReader = new ParquetLevelValuesReader(rlReader);
        this.definitionReader = new ParquetLevelValuesReader(dlReader);
        try {
            byte[] bytes = page.getSlice().getBytes();
            rlReader.initFromPage(page.getValueCount(), bytes, 0);
            int offset = rlReader.getNextOffset();
            dlReader.initFromPage(page.getValueCount(), bytes, offset);
            offset = dlReader.getNextOffset();
            return this.initDataReader(page.getValueEncoding(), bytes, offset, page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page " + page + " in column " + (Object)((Object)this.columnDescriptor), (Throwable)e);
        }
    }

    private ValuesReader readPageV2(ParquetDataPageV2 page) {
        this.repetitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        return this.initDataReader(page.getDataEncoding(), page.getSlice().getBytes(), 0, page.getValueCount());
    }

    private ParquetLevelReader buildLevelRLEReader(int maxLevel, Slice slice) {
        if (maxLevel == 0) {
            return new ParquetLevelNullReader();
        }
        return new ParquetLevelRLEReader(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), new ByteArrayInputStream(slice.getBytes())));
    }

    private ValuesReader initDataReader(ParquetEncoding dataEncoding, byte[] bytes, int offset, int valueCount) {
        ValuesReader valuesReader;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("Dictionary is missing for Page");
            }
            valuesReader = dataEncoding.getDictionaryBasedValuesReader(this.columnDescriptor, ParquetValuesType.VALUES, this.dictionary);
        } else {
            valuesReader = dataEncoding.getValuesReader(this.columnDescriptor, ParquetValuesType.VALUES);
        }
        try {
            valuesReader.initFromPage(valueCount, bytes, offset);
            return valuesReader;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page in column " + (Object)((Object)this.columnDescriptor), (Throwable)e);
        }
    }
}

