/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.RichColumnDescriptor;
import com.facebook.presto.hive.parquet.reader.ParquetPrimitiveColumnReader;
import com.facebook.presto.hive.util.DecimalUtils;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import parquet.schema.PrimitiveType;

public class ParquetShortDecimalColumnReader
extends ParquetPrimitiveColumnReader {
    ParquetShortDecimalColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            long decimalValue = this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT32) ? (long)this.valuesReader.readInteger() : (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT64) ? this.valuesReader.readLong() : DecimalUtils.getShortDecimalValue(this.valuesReader.readBytes().getBytes()));
            type.writeLong(blockBuilder, decimalValue);
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT32)) {
                this.valuesReader.readInteger();
            } else if (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) {
                this.valuesReader.readLong();
            } else {
                this.valuesReader.readBytes();
            }
        }
    }
}

