/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.Field;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;

public class ParquetStructColumnReader {
    private ParquetStructColumnReader() {
    }

    public static BooleanList calculateStructOffsets(Field field, int[] fieldDefinitionLevels, int[] fieldRepetitionLevels) {
        int maxDefinitionLevel = field.getDefinitionLevel();
        int maxRepetitionLevel = field.getRepetitionLevel();
        BooleanArrayList structIsNull = new BooleanArrayList();
        boolean required = field.isRequired();
        if (fieldDefinitionLevels == null) {
            return structIsNull;
        }
        for (int i = 0; i < fieldDefinitionLevels.length; ++i) {
            if (fieldRepetitionLevels[i] > maxRepetitionLevel) continue;
            if (ParquetTypeUtils.isValueNull(required, fieldDefinitionLevels[i], maxDefinitionLevel)) {
                structIsNull.add(true);
                continue;
            }
            if (fieldDefinitionLevels[i] < maxDefinitionLevel) continue;
            structIsNull.add(false);
        }
        return structIsNull;
    }
}

