/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security;

import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.security.LegacySecurityConfig;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;

public class LegacyAccessControl
implements ConnectorAccessControl {
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;
    private final boolean allowDropTable;
    private final boolean allowRenameTable;
    private final boolean allowAddColumn;
    private final boolean allowDropColumn;
    private final boolean allowRenameColumn;

    @Inject
    public LegacyAccessControl(Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider, LegacySecurityConfig securityConfig) {
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
        Objects.requireNonNull(securityConfig, "securityConfig is null");
        this.allowDropTable = securityConfig.getAllowDropTable();
        this.allowRenameTable = securityConfig.getAllowRenameTable();
        this.allowAddColumn = securityConfig.getAllowAddColumn();
        this.allowDropColumn = securityConfig.getAllowDropColumn();
        this.allowRenameColumn = securityConfig.getAllowRenameColumn();
    }

    public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
    }

    public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName, String newSchemaName) {
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, Identity identity) {
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, Identity identity, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanDropTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        Optional<Table> target;
        if (!this.allowDropTable) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
        if (!(target = this.metastoreProvider.apply((HiveTransactionHandle)transaction).getTable(tableName.getSchemaName(), tableName.getTableName())).isPresent()) {
            AccessDeniedException.denyDropTable((String)tableName.toString(), (String)"Table not found");
        }
        if (!identity.getUser().equals(target.get().getOwner())) {
            AccessDeniedException.denyDropTable((String)tableName.toString(), (String)"Owner of the table is different from session user");
        }
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.allowRenameTable) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, Identity identity, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.allowAddColumn) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        if (!this.allowDropColumn) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.allowRenameColumn) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanCreateView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanDropView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanCreateViewWithSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanCreateViewWithSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transaction, Identity identity, Privilege privilege, SchemaTableName tableName, String grantee, boolean withGrantOption) {
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transaction, Identity identity, Privilege privilege, SchemaTableName tableName, String revokee, boolean grantOptionFor) {
    }
}

