/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security;

import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class SqlStandardAccessControl
implements ConnectorAccessControl {
    public static final String ADMIN_ROLE_NAME = "admin";
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final String connectorId;
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;
    private final ExtendedHiveMetastore metastore;

    @Inject
    public SqlStandardAccessControl(HiveConnectorId connectorId, Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider, ExtendedHiveMetastore metastore) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    public void checkCanCreateSchema(ConnectorTransactionHandle transaction, Identity identity, String schemaName) {
        if (!this.isAdmin(transaction, identity)) {
            AccessDeniedException.denyCreateSchema((String)schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transaction, Identity identity, String schemaName) {
        if (!this.isDatabaseOwner(transaction, identity, schemaName)) {
            AccessDeniedException.denyDropSchema((String)schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorTransactionHandle transaction, Identity identity, String schemaName, String newSchemaName) {
        if (!this.isAdmin(transaction, identity) || !this.isDatabaseOwner(transaction, identity, schemaName)) {
            AccessDeniedException.denyRenameSchema((String)schemaName, (String)newSchemaName);
        }
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, Identity identity) {
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, Identity identity, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.isDatabaseOwner(transaction, identity, tableName.getSchemaName())) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, Identity identity, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.INSERT)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.DELETE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanCreateView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.isDatabaseOwner(transaction, identity, viewName.getSchemaName())) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanDropView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkTablePermission(transaction, identity, viewName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkTablePermission(transaction, identity, viewName, HivePrivilegeInfo.HivePrivilege.SELECT)) {
            AccessDeniedException.denySelectView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        } else if (!this.getGrantOptionForPrivilege(transaction, identity, Privilege.SELECT, tableName)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkTablePermission(transaction, identity, viewName, HivePrivilegeInfo.HivePrivilege.SELECT)) {
            AccessDeniedException.denySelectView((String)viewName.toString());
        }
        if (!this.getGrantOptionForPrivilege(transaction, identity, Privilege.SELECT, viewName)) {
            AccessDeniedException.denyCreateViewWithSelect((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, String propertyName) {
        if (!this.metastore.getRoles(identity.getUser()).contains(ADMIN_ROLE_NAME)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)this.connectorId, (String)propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transaction, Identity identity, Privilege privilege, SchemaTableName tableName, String grantee, boolean withGrantOption) {
        if (this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP)) {
            return;
        }
        HivePrivilegeInfo.HivePrivilege hivePrivilege = HivePrivilegeInfo.toHivePrivilege(privilege);
        if (hivePrivilege == null || !this.getGrantOptionForPrivilege(transaction, identity, privilege, tableName)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transaction, Identity identity, Privilege privilege, SchemaTableName tableName, String revokee, boolean grantOptionFor) {
        if (this.checkTablePermission(transaction, identity, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP)) {
            return;
        }
        HivePrivilegeInfo.HivePrivilege hivePrivilege = HivePrivilegeInfo.toHivePrivilege(privilege);
        if (hivePrivilege == null || !this.getGrantOptionForPrivilege(transaction, identity, privilege, tableName)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    private boolean checkDatabasePermission(ConnectorTransactionHandle transaction, Identity identity, String schemaName, HivePrivilegeInfo.HivePrivilege ... requiredPrivileges) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        Set privilegeSet = metastore.getDatabasePrivileges(identity.getUser(), schemaName).stream().map(HivePrivilegeInfo::getHivePrivilege).collect(Collectors.toSet());
        return privilegeSet.containsAll((Collection<?>)ImmutableSet.copyOf((Object[])requiredPrivileges));
    }

    private boolean isDatabaseOwner(ConnectorTransactionHandle transaction, Identity identity, String schemaName) {
        return this.checkDatabasePermission(transaction, identity, schemaName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP);
    }

    private boolean getGrantOptionForPrivilege(ConnectorTransactionHandle transaction, Identity identity, Privilege privilege, SchemaTableName tableName) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        return metastore.getTablePrivileges(identity.getUser(), tableName.getSchemaName(), tableName.getTableName()).contains(new HivePrivilegeInfo(HivePrivilegeInfo.toHivePrivilege(privilege), true));
    }

    private boolean checkTablePermission(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName, HivePrivilegeInfo.HivePrivilege ... requiredPrivileges) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        Set privilegeSet = metastore.getTablePrivileges(identity.getUser(), tableName.getSchemaName(), tableName.getTableName()).stream().map(HivePrivilegeInfo::getHivePrivilege).collect(Collectors.toSet());
        return privilegeSet.containsAll((Collection<?>)ImmutableSet.copyOf((Object[])requiredPrivileges));
    }

    private boolean isAdmin(ConnectorTransactionHandle transaction, Identity identity) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transaction);
        return metastore.getRoles(identity.getUser()).contains(ADMIN_ROLE_NAME);
    }
}

