/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.statistics;

import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.PartitionStatistics;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.statistics.HiveStatisticsProvider;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.Utils;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.RangeColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import org.joda.time.DateTimeZone;

public class MetastoreHiveStatisticsProvider
implements HiveStatisticsProvider {
    private final TypeManager typeManager;
    private final SemiTransactionalHiveMetastore metastore;
    private final DateTimeZone timeZone;

    public MetastoreHiveStatisticsProvider(TypeManager typeManager, SemiTransactionalHiveMetastore metastore, DateTimeZone timeZone) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.timeZone = timeZone;
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, List<HivePartition> hivePartitions, Map<String, ColumnHandle> tableColumns) {
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.EMPTY_STATISTICS;
        }
        Map<String, PartitionStatistics> partitionStatistics = this.getPartitionsStatistics((HiveTableHandle)tableHandle, hivePartitions, tableColumns);
        TableStatistics.Builder tableStatistics = TableStatistics.builder();
        Estimate rowCount = this.calculateRowsCount(partitionStatistics);
        tableStatistics.setRowCount(rowCount);
        for (Map.Entry<String, ColumnHandle> columnEntry : tableColumns.entrySet()) {
            Estimate nullsFraction;
            String columnName = columnEntry.getKey();
            HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)columnEntry.getValue();
            RangeColumnStatistics.Builder rangeStatistics = RangeColumnStatistics.builder();
            Object lowValueCandidates = ImmutableList.of();
            Object highValueCandidates = ImmutableList.of();
            Type prestoType = this.typeManager.getType(hiveColumnHandle.getTypeSignature());
            if (hiveColumnHandle.isPartitionKey()) {
                rangeStatistics.setDistinctValuesCount(this.countDistinctPartitionKeys(hiveColumnHandle, hivePartitions));
                nullsFraction = this.calculateNullsFractionForPartitioningKey(hiveColumnHandle, hivePartitions, partitionStatistics);
                if (this.isLowHighSupportedForType(prestoType)) {
                    highValueCandidates = lowValueCandidates = (List)hivePartitions.stream().map(HivePartition::getKeys).map(keys -> (NullableValue)keys.get(hiveColumnHandle)).filter(value -> !value.isNull()).map(NullableValue::getValue).collect(ImmutableList.toImmutableList());
                }
            } else {
                rangeStatistics.setDistinctValuesCount(this.calculateDistinctValuesCount(partitionStatistics, columnName));
                nullsFraction = this.calculateNullsFraction(partitionStatistics, columnName, rowCount);
                if (this.isLowHighSupportedForType(prestoType)) {
                    lowValueCandidates = (List)partitionStatistics.values().stream().map(PartitionStatistics::getColumnStatistics).filter(stats -> stats.containsKey(columnName)).map(stats -> (HiveColumnStatistics)stats.get(columnName)).map(HiveColumnStatistics::getLowValue).filter(Optional::isPresent).map(Optional::get).map(value -> this.lowHighValueAsPrestoType(value, prestoType)).collect(ImmutableList.toImmutableList());
                    highValueCandidates = (List)partitionStatistics.values().stream().map(PartitionStatistics::getColumnStatistics).filter(stats -> stats.containsKey(columnName)).map(stats -> (HiveColumnStatistics)stats.get(columnName)).map(HiveColumnStatistics::getHighValue).filter(Optional::isPresent).map(Optional::get).map(value -> this.lowHighValueAsPrestoType(value, prestoType)).collect(ImmutableList.toImmutableList());
                }
            }
            rangeStatistics.setFraction(nullsFraction.map(value -> 1.0 - value));
            Comparator comparator = (leftValue, rightValue) -> {
                Block leftBlock = Utils.nativeValueToBlock((Type)prestoType, (Object)leftValue);
                Block rightBlock = Utils.nativeValueToBlock((Type)prestoType, (Object)rightValue);
                return prestoType.compareTo(leftBlock, 0, rightBlock, 0);
            };
            rangeStatistics.setLowValue(lowValueCandidates.stream().min(comparator));
            rangeStatistics.setHighValue(highValueCandidates.stream().max(comparator));
            ColumnStatistics.Builder columnStatistics = ColumnStatistics.builder();
            columnStatistics.setNullsFraction(nullsFraction);
            columnStatistics.addRange(rangeStatistics.build());
            tableStatistics.setColumnStatistics((ColumnHandle)hiveColumnHandle, columnStatistics.build());
        }
        return tableStatistics.build();
    }

    private boolean isLowHighSupportedForType(Type type) {
        if (type instanceof DecimalType) {
            return true;
        }
        return type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(RealType.REAL) || type.equals(DoubleType.DOUBLE) || type.equals(DateType.DATE) || type.equals(TimestampType.TIMESTAMP);
    }

    private Object lowHighValueAsPrestoType(Object value, Type prestoType) {
        Preconditions.checkArgument((boolean)this.isLowHighSupportedForType(prestoType), (Object)("Unsupported type " + prestoType));
        Objects.requireNonNull(value, "high/low value connot be null");
        if (prestoType.equals(BigintType.BIGINT) || prestoType.equals(IntegerType.INTEGER) || prestoType.equals(SmallintType.SMALLINT) || prestoType.equals(TinyintType.TINYINT)) {
            Preconditions.checkArgument((boolean)(value instanceof Long), (Object)("expected Long value but got " + value.getClass()));
            return value;
        }
        if (prestoType.equals(DoubleType.DOUBLE)) {
            Preconditions.checkArgument((boolean)(value instanceof Double), (Object)("expected Double value but got " + value.getClass()));
            return value;
        }
        if (prestoType.equals(RealType.REAL)) {
            Preconditions.checkArgument((boolean)(value instanceof Double), (Object)("expected Double value but got " + value.getClass()));
            return (long)Float.floatToRawIntBits((float)((Double)value).doubleValue());
        }
        if (prestoType.equals(DateType.DATE)) {
            Preconditions.checkArgument((boolean)(value instanceof LocalDate), (Object)("expected LocalDate value but got " + value.getClass()));
            return ((LocalDate)value).toEpochDay();
        }
        if (prestoType.equals(TimestampType.TIMESTAMP)) {
            Preconditions.checkArgument((boolean)(value instanceof Long), (Object)("expected Long value but got " + value.getClass()));
            return this.timeZone.convertLocalToUTC((Long)value * 1000L, false);
        }
        if (prestoType instanceof DecimalType) {
            Preconditions.checkArgument((boolean)(value instanceof BigDecimal), (Object)("expected BigDecimal value but got " + value.getClass()));
            BigInteger unscaled = Decimals.rescale((BigDecimal)((BigDecimal)value), (DecimalType)((DecimalType)prestoType)).unscaledValue();
            if (Decimals.isShortDecimal((Type)prestoType)) {
                return unscaled.longValueExact();
            }
            return Decimals.encodeUnscaledValue((BigInteger)unscaled);
        }
        throw new IllegalArgumentException("Unsupported presto type " + prestoType);
    }

    private Estimate calculateRowsCount(Map<String, PartitionStatistics> partitionStatistics) {
        List knownPartitionRowCounts = (List)partitionStatistics.values().stream().map(stats -> stats.getBasicStatistics().getRowCount()).filter(OptionalLong::isPresent).map(OptionalLong::getAsLong).collect(ImmutableList.toImmutableList());
        long knownPartitionRowCountsSum = knownPartitionRowCounts.stream().mapToLong(a -> a).sum();
        long partitionsWithStatsCount = knownPartitionRowCounts.size();
        long allPartitionsCount = partitionStatistics.size();
        if (partitionsWithStatsCount == 0L) {
            return Estimate.unknownValue();
        }
        return new Estimate(1.0 * (double)knownPartitionRowCountsSum / (double)partitionsWithStatsCount * (double)allPartitionsCount);
    }

    private Estimate calculateDistinctValuesCount(Map<String, PartitionStatistics> statisticsByPartitionName, String column) {
        return this.summarizePartitionStatistics(statisticsByPartitionName.values(), column, columnStatistics -> {
            if (columnStatistics.getDistinctValuesCount().isPresent()) {
                return OptionalDouble.of(columnStatistics.getDistinctValuesCount().getAsLong());
            }
            if (columnStatistics.getFalseCount().isPresent() && columnStatistics.getTrueCount().isPresent() && columnStatistics.getNullsCount().isPresent()) {
                long falseCount = columnStatistics.getFalseCount().getAsLong();
                long trueCount = columnStatistics.getTrueCount().getAsLong();
                long nullCount = columnStatistics.getNullsCount().getAsLong();
                return OptionalDouble.of((falseCount > 0L ? 1 : 0) + (trueCount > 0L ? 1 : 0) + (nullCount > 0L ? 1 : 0));
            }
            return OptionalDouble.empty();
        }, DoubleStream::max);
    }

    private Estimate calculateNullsFraction(Map<String, PartitionStatistics> statisticsByPartitionName, String column, Estimate totalRowsCount) {
        Estimate totalNullsCount = this.summarizePartitionStatistics(statisticsByPartitionName.values(), column, columnStatistics -> {
            if (columnStatistics.getNullsCount().isPresent()) {
                return OptionalDouble.of(columnStatistics.getNullsCount().getAsLong());
            }
            return OptionalDouble.empty();
        }, nullsCountStream -> {
            double nullsCount = 0.0;
            long partitionsWithStatisticsCount = 0L;
            PrimitiveIterator.OfDouble nullsCountIterator = nullsCountStream.iterator();
            while (nullsCountIterator.hasNext()) {
                nullsCount += nullsCountIterator.nextDouble();
                ++partitionsWithStatisticsCount;
            }
            if (partitionsWithStatisticsCount == 0L) {
                return OptionalDouble.empty();
            }
            int allPartitionsCount = statisticsByPartitionName.size();
            return OptionalDouble.of((double)((long)allPartitionsCount / partitionsWithStatisticsCount) * nullsCount);
        });
        if (totalNullsCount.isValueUnknown() || totalRowsCount.isValueUnknown()) {
            return Estimate.unknownValue();
        }
        if (totalRowsCount.getValue() == 0.0) {
            return Estimate.zeroValue();
        }
        return new Estimate(totalNullsCount.getValue() / totalRowsCount.getValue());
    }

    private Estimate countDistinctPartitionKeys(HiveColumnHandle partitionColumn, List<HivePartition> partitions) {
        return new Estimate((double)partitions.stream().map(HivePartition::getKeys).map(keys -> (NullableValue)keys.get(partitionColumn)).distinct().count());
    }

    private Estimate calculateNullsFractionForPartitioningKey(HiveColumnHandle partitionColumn, List<HivePartition> partitions, Map<String, PartitionStatistics> partitionStatistics) {
        OptionalDouble rowsPerPartition = partitionStatistics.values().stream().map(stats -> stats.getBasicStatistics().getRowCount()).filter(OptionalLong::isPresent).mapToLong(OptionalLong::getAsLong).average();
        if (!rowsPerPartition.isPresent()) {
            return Estimate.unknownValue();
        }
        double estimatedTotalRowsCount = rowsPerPartition.getAsDouble() * (double)partitions.size();
        if (estimatedTotalRowsCount == 0.0) {
            return Estimate.zeroValue();
        }
        double estimatedNullsCount = partitions.stream().filter(partition -> partition.getKeys().get(partitionColumn).isNull()).map(HivePartition::getPartitionId).mapToLong(partitionId -> ((PartitionStatistics)partitionStatistics.get(partitionId)).getBasicStatistics().getRowCount().orElse((long)rowsPerPartition.getAsDouble())).sum();
        return new Estimate(estimatedNullsCount / estimatedTotalRowsCount);
    }

    private Estimate summarizePartitionStatistics(Collection<PartitionStatistics> partitionStatistics, String column, Function<HiveColumnStatistics, OptionalDouble> valueExtractFunction, Function<DoubleStream, OptionalDouble> valueAggregateFunction) {
        DoubleStream intermediateStream = partitionStatistics.stream().map(PartitionStatistics::getColumnStatistics).filter(stats -> stats.containsKey(column)).map(stats -> (HiveColumnStatistics)stats.get(column)).map(valueExtractFunction).filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble);
        OptionalDouble statisticsValue = valueAggregateFunction.apply(intermediateStream);
        if (statisticsValue.isPresent()) {
            return new Estimate(statisticsValue.getAsDouble());
        }
        return Estimate.unknownValue();
    }

    private Map<String, PartitionStatistics> getPartitionsStatistics(HiveTableHandle tableHandle, List<HivePartition> hivePartitions, Map<String, ColumnHandle> tableColumns) {
        if (hivePartitions.isEmpty()) {
            return ImmutableMap.of();
        }
        boolean unpartitioned = hivePartitions.stream().anyMatch(partition -> partition.getPartitionId().equals("<UNPARTITIONED>"));
        if (unpartitioned) {
            Preconditions.checkArgument((hivePartitions.size() == 1 ? 1 : 0) != 0, (Object)"expected only one hive partition");
        }
        if (unpartitioned) {
            return ImmutableMap.of((Object)"<UNPARTITIONED>", (Object)this.getTableStatistics(tableHandle.getSchemaTableName()));
        }
        return this.getPartitionsStatistics(tableHandle.getSchemaTableName(), hivePartitions);
    }

    private Map<String, PartitionStatistics> getPartitionsStatistics(SchemaTableName schemaTableName, List<HivePartition> hivePartitions) {
        String databaseName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        ImmutableMap.Builder resultMap = ImmutableMap.builder();
        List partitionNames = (List)hivePartitions.stream().map(HivePartition::getPartitionId).collect(ImmutableList.toImmutableList());
        Map<String, Map<String, HiveColumnStatistics>> partitionColumnStatisticsMap = this.metastore.getPartitionColumnStatistics(databaseName, tableName, (Set<String>)ImmutableSet.copyOf((Collection)partitionNames));
        Map<String, Optional<Partition>> partitionsByNames = this.metastore.getPartitionsByNames(databaseName, tableName, partitionNames);
        for (String partitionName : partitionNames) {
            Map partitionParameters = partitionsByNames.get(partitionName).map(Partition::getParameters).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get metadata for partition %s.%s.%s", databaseName, tableName, partitionName)));
            Map<String, HiveColumnStatistics> partitionColumnStatistics = partitionColumnStatisticsMap.getOrDefault(partitionName, (Map<String, HiveColumnStatistics>)ImmutableMap.of());
            resultMap.put((Object)partitionName, (Object)this.readStatisticsFromParameters(partitionParameters, partitionColumnStatistics));
        }
        return resultMap.build();
    }

    private PartitionStatistics getTableStatistics(SchemaTableName schemaTableName) {
        String databaseName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Table table = this.metastore.getTable(databaseName, tableName).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get metadata for table %s.%s", databaseName, tableName)));
        Map<String, HiveColumnStatistics> tableColumnStatistics = this.metastore.getTableColumnStatistics(databaseName, tableName);
        return this.readStatisticsFromParameters(table.getParameters(), tableColumnStatistics);
    }

    private PartitionStatistics readStatisticsFromParameters(Map<String, String> parameters, Map<String, HiveColumnStatistics> columnStatistics) {
        return new PartitionStatistics(HiveBasicStatistics.createFromPartitionParameters(parameters), columnStatistics);
    }
}

