/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;

public final class Statistics {
    private static final Set<String> STATISTICS_PARAMETERS = ImmutableSet.copyOf(HiveBasicStatistics.createZeroStatistics().toPartitionParameters().keySet());

    private Statistics() {
    }

    public static Table updateStatistics(Table table, HiveBasicStatistics statistics, ReduceOperator operator) {
        Map<String, String> parameters = table.getParameters();
        Map<String, String> updatedParameters = Statistics.updateStatistics(parameters, statistics, operator);
        return Table.builder(table).setParameters(updatedParameters).build();
    }

    public static Partition updateStatistics(Partition partition, HiveBasicStatistics statistics, ReduceOperator operator) {
        Map<String, String> parameters = partition.getParameters();
        Map<String, String> updatedParameters = Statistics.updateStatistics(parameters, statistics, operator);
        return Partition.builder(partition).setParameters(updatedParameters).build();
    }

    public static Map<String, String> updateStatistics(Map<String, String> parameters, HiveBasicStatistics update, ReduceOperator operator) {
        HiveBasicStatistics currentStatistics = HiveBasicStatistics.createFromPartitionParameters(parameters);
        HiveBasicStatistics updatedStatistics = Statistics.reduce(currentStatistics, update, operator);
        Map<String, String> updatedParameters = parameters.entrySet().stream().filter(entry -> !STATISTICS_PARAMETERS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        updatedParameters.putAll(updatedStatistics.toPartitionParameters());
        return Collections.unmodifiableMap(updatedParameters);
    }

    public static HiveBasicStatistics add(HiveBasicStatistics first, HiveBasicStatistics second) {
        return Statistics.reduce(first, second, ReduceOperator.ADD);
    }

    public static HiveBasicStatistics subtract(HiveBasicStatistics first, HiveBasicStatistics second) {
        return Statistics.reduce(first, second, ReduceOperator.SUBTRACT);
    }

    public static HiveBasicStatistics reduce(HiveBasicStatistics first, HiveBasicStatistics second, ReduceOperator operator) {
        return new HiveBasicStatistics(Statistics.reduce(first.getFileCount(), second.getFileCount(), operator), Statistics.reduce(first.getRowCount(), second.getRowCount(), operator), Statistics.reduce(first.getInMemoryDataSizeInBytes(), second.getInMemoryDataSizeInBytes(), operator), Statistics.reduce(first.getOnDiskDataSizeInBytes(), second.getOnDiskDataSizeInBytes(), operator));
    }

    private static OptionalLong reduce(OptionalLong first, OptionalLong second, ReduceOperator operator) {
        if (first.isPresent() && second.isPresent()) {
            switch (operator) {
                case ADD: {
                    return OptionalLong.of(first.getAsLong() + second.getAsLong());
                }
                case SUBTRACT: {
                    return OptionalLong.of(first.getAsLong() - second.getAsLong());
                }
            }
        }
        return OptionalLong.empty();
    }

    public static enum ReduceOperator {
        ADD,
        SUBTRACT;


        public ReduceOperator flip() {
            switch (this) {
                case SUBTRACT: {
                    return ADD;
                }
                case ADD: {
                    return SUBTRACT;
                }
            }
            throw new UnsupportedOperationException("flip is not implemented for operation type: " + (Object)((Object)this));
        }
    }
}

