/*
 * Decompiled with CFR 0.152.
 */
package parquet.io;

import com.facebook.presto.hive.parquet.Field;
import com.facebook.presto.hive.parquet.GroupField;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import com.facebook.presto.hive.parquet.PrimitiveField;
import com.facebook.presto.hive.parquet.RichColumnDescriptor;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import parquet.io.ColumnIO;
import parquet.io.GroupColumnIO;
import parquet.io.PrimitiveColumnIO;
import parquet.schema.Type;

public class ColumnIOConverter {
    private ColumnIOConverter() {
    }

    public static Optional<Field> constructField(Type type, ColumnIO columnIO) {
        if (columnIO == null) {
            return Optional.empty();
        }
        boolean required = columnIO.getType().getRepetition() != Type.Repetition.OPTIONAL;
        int repetitionLevel = columnIO.getRepetitionLevel();
        int definitionLevel = columnIO.getDefinitionLevel();
        if ("row".equals(type.getTypeSignature().getBase())) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            List parameters = type.getTypeParameters();
            ImmutableList.Builder fileldsBuilder = ImmutableList.builder();
            List fields = type.getTypeSignature().getParameters();
            boolean structHasParameters = false;
            for (int i = 0; i < fields.size(); ++i) {
                NamedTypeSignature namedTypeSignature = ((TypeSignatureParameter)fields.get(i)).getNamedTypeSignature();
                String name = ((String)namedTypeSignature.getName().get()).toLowerCase(Locale.ENGLISH);
                Optional<Field> field = ColumnIOConverter.constructField((Type)parameters.get(i), groupColumnIO.getChild(name));
                structHasParameters |= field.isPresent();
                fileldsBuilder.add(field);
            }
            if (structHasParameters) {
                return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (ImmutableList<Optional<Field>>)fileldsBuilder.build()));
            }
            return Optional.empty();
        }
        if ("map".equals(type.getTypeSignature().getBase())) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            MapType mapType = (MapType)type;
            GroupColumnIO keyValueColumnIO = ParquetTypeUtils.getMapKeyValueColumn(groupColumnIO);
            if (keyValueColumnIO.getChildrenCount() < 2) {
                return Optional.empty();
            }
            Optional<Field> keyField = ColumnIOConverter.constructField(mapType.getKeyType(), keyValueColumnIO.getChild(0));
            Optional<Field> valueField = ColumnIOConverter.constructField(mapType.getValueType(), keyValueColumnIO.getChild(1));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (ImmutableList<Optional<Field>>)ImmutableList.of(keyField, valueField)));
        }
        if ("array".equals(type.getTypeSignature().getBase())) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            List types = type.getTypeParameters();
            if (groupColumnIO.getChildrenCount() == 0) {
                return Optional.empty();
            }
            Optional<Field> field = ColumnIOConverter.constructField((Type)types.get(0), ParquetTypeUtils.getArrayElementColumn(groupColumnIO.getChild(0)));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (ImmutableList<Optional<Field>>)ImmutableList.of(field)));
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        RichColumnDescriptor column = new RichColumnDescriptor(primitiveColumnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
        return Optional.of(new PrimitiveField(type, repetitionLevel, definitionLevel, required, column, primitiveColumnIO.getId()));
    }
}

