/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.block.LazyBlockLoader;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BucketAdaptation;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveCoercer;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.joda.time.DateTimeZone;

public class HivePageSource
implements ConnectorPageSource {
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Optional<BucketAdapter> bucketAdapter;
    private final Object[] prefilledValues;
    private final Type[] types;
    private final Function<Block, Block>[] coercers;
    private final ConnectorPageSource delegate;

    public HivePageSource(List<HivePageSourceProvider.ColumnMapping> columnMappings, Optional<BucketAdaptation> bucketAdaptation, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, ConnectorPageSource delegate) {
        Objects.requireNonNull(columnMappings, "columnMappings is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        this.bucketAdapter = bucketAdaptation.map(BucketAdapter::new);
        int size = columnMappings.size();
        this.prefilledValues = new Object[size];
        this.types = new Type[size];
        this.coercers = new Function[size];
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            HiveColumnHandle column = columnMapping.getHiveColumnHandle();
            String name = column.getName();
            this.types[columnIndex] = type = typeManager.getType(column.getTypeSignature());
            if (columnMapping.getCoercionFrom().isPresent()) {
                this.coercers[columnIndex] = HiveCoercer.createCoercer(typeManager, columnMapping.getCoercionFrom().get(), columnMapping.getHiveColumnHandle().getHiveType());
            }
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.PREFILLED) continue;
            this.prefilledValues[columnIndex] = HiveUtil.typedPartitionKey(columnMapping.getPrefilledValue(), type, name, hiveStorageTimeZone);
        }
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            if (this.bucketAdapter.isPresent()) {
                IntArrayList rowsToKeep = this.bucketAdapter.get().computeEligibleRowIds(dataPage);
                Block[] adaptedBlocks = new Block[dataPage.getChannelCount()];
                for (int i = 0; i < adaptedBlocks.length; ++i) {
                    Block block = dataPage.getBlock(i);
                    adaptedBlocks[i] = block instanceof LazyBlock && !((LazyBlock)block).isLoaded() ? new LazyBlock(rowsToKeep.size(), (LazyBlockLoader)new RowFilterLazyBlockLoader(dataPage.getBlock(i), rowsToKeep)) : block.getPositions(rowsToKeep.elements(), 0, rowsToKeep.size());
                }
                dataPage = new Page(rowsToKeep.size(), adaptedBlocks);
            }
            int batchSize = dataPage.getPositionCount();
            ArrayList<Block> blocks = new ArrayList<Block>();
            block9: for (int fieldId = 0; fieldId < this.columnMappings.size(); ++fieldId) {
                HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(fieldId);
                switch (columnMapping.getKind()) {
                    case PREFILLED: {
                        blocks.add(RunLengthEncodedBlock.create((Type)this.types[fieldId], (Object)this.prefilledValues[fieldId], (int)batchSize));
                        continue block9;
                    }
                    case REGULAR: {
                        Block block = dataPage.getBlock(columnMapping.getIndex());
                        if (this.coercers[fieldId] != null) {
                            block = new LazyBlock(batchSize, (LazyBlockLoader)new CoercionLazyBlockLoader(block, this.coercers[fieldId]));
                        }
                        blocks.add(block);
                        continue block9;
                    }
                    case INTERIM: {
                        continue block9;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            return new Page(batchSize, blocks.toArray(new Block[0]));
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    @VisibleForTesting
    ConnectorPageSource getPageSource() {
        return this.delegate;
    }

    private static Page extractColumns(Page page, int[] columns) {
        Block[] blocks = new Block[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dataColumn = columns[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private static class BucketAdapter {
        public final int[] bucketColumns;
        public final int bucketToKeep;
        public final int tableBucketCount;
        public final int partitionBucketCount;
        private final List<TypeInfo> typeInfoList;

        public BucketAdapter(BucketAdaptation bucketAdaptation) {
            this.bucketColumns = bucketAdaptation.getBucketColumnIndices();
            this.bucketToKeep = bucketAdaptation.getBucketToKeep();
            this.typeInfoList = (List)bucketAdaptation.getBucketColumnHiveTypes().stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
            this.tableBucketCount = bucketAdaptation.getTableBucketCount();
            this.partitionBucketCount = bucketAdaptation.getPartitionBucketCount();
        }

        public IntArrayList computeEligibleRowIds(Page page) {
            IntArrayList ids = new IntArrayList(page.getPositionCount());
            Page bucketColumnsPage = HivePageSource.extractColumns(page, this.bucketColumns);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int bucket = HiveBucketing.getHiveBucket(this.tableBucketCount, this.typeInfoList, bucketColumnsPage, position);
                if ((bucket - this.bucketToKeep) % this.partitionBucketCount != 0) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("A row that is supposed to be in bucket %s is encountered. Only rows in bucket %s (modulo %s) are expected", bucket, this.bucketToKeep % this.partitionBucketCount, this.partitionBucketCount));
                }
                if (bucket != this.bucketToKeep) continue;
                ids.add(position);
            }
            return ids;
        }
    }

    private static final class RowFilterLazyBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private Block block;
        private final IntArrayList rowsToKeep;

        public RowFilterLazyBlockLoader(Block block, IntArrayList rowsToKeep) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.rowsToKeep = Objects.requireNonNull(rowsToKeep, "rowsToKeep is null");
        }

        public void load(LazyBlock lazyBlock) {
            if (this.block == null) {
                return;
            }
            lazyBlock.setBlock(this.block.getPositions(this.rowsToKeep.elements(), 0, this.rowsToKeep.size()));
            this.block = null;
        }
    }

    private static final class CoercionLazyBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final Function<Block, Block> coercer;
        private Block block;

        public CoercionLazyBlockLoader(Block block, Function<Block, Block> coercer) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.coercer = Objects.requireNonNull(coercer, "coercer is null");
        }

        public void load(LazyBlock lazyBlock) {
            if (this.block == null) {
                return;
            }
            lazyBlock.setBlock(this.coercer.apply(this.block.getLoadedBlock()));
            this.block = null;
        }
    }
}

