/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;

public final class HiveSessionProperties {
    private static final String IGNORE_TABLE_BUCKETING = "ignore_table_bucketing";
    private static final String BUCKET_EXECUTION_ENABLED = "bucket_execution_enabled";
    private static final String NODE_SELECTION_STRATEGY = "node_selection_strategy";
    private static final String INSERT_EXISTING_PARTITIONS_BEHAVIOR = "insert_existing_partitions_behavior";
    private static final String ORC_BLOOM_FILTERS_ENABLED = "orc_bloom_filters_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String ORC_TINY_STRIPE_THRESHOLD = "orc_tiny_stripe_threshold";
    private static final String ORC_MAX_READ_BLOCK_SIZE = "orc_max_read_block_size";
    private static final String ORC_LAZY_READ_SMALL_RANGES = "orc_lazy_read_small_ranges";
    private static final String ORC_ZSTD_JNI_DECOMPRESSION_ENABLED = "orc_zstd_jni_decompression_enabled";
    private static final String ORC_STRING_STATISTICS_LIMIT = "orc_string_statistics_limit";
    private static final String ORC_OPTIMIZED_WRITER_ENABLED = "orc_optimized_writer_enabled";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE = "orc_optimized_writer_validate";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE = "orc_optimized_writer_validate_percentage";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_MODE = "orc_optimized_writer_validate_mode";
    private static final String ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE = "orc_optimized_writer_min_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE = "orc_optimized_writer_max_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS = "orc_optimized_writer_max_stripe_rows";
    private static final String ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY = "orc_optimized_writer_max_dictionary_memory";
    private static final String PAGEFILE_WRITER_MAX_STRIPE_SIZE = "pagefile_writer_max_stripe_size";
    private static final String HIVE_STORAGE_FORMAT = "hive_storage_format";
    private static final String COMPRESSION_CODEC = "compression_codec";
    private static final String ORC_COMPRESSION_CODEC = "orc_compression_codec";
    private static final String RESPECT_TABLE_FORMAT = "respect_table_format";
    private static final String PARQUET_USE_COLUMN_NAME = "parquet_use_column_names";
    private static final String PARQUET_FAIL_WITH_CORRUPTED_STATISTICS = "parquet_fail_with_corrupted_statistics";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private static final String MAX_SPLIT_SIZE = "max_split_size";
    private static final String MAX_INITIAL_SPLIT_SIZE = "max_initial_split_size";
    public static final String RCFILE_OPTIMIZED_WRITER_ENABLED = "rcfile_optimized_writer_enabled";
    private static final String RCFILE_OPTIMIZED_WRITER_VALIDATE = "rcfile_optimized_writer_validate";
    private static final String SORTED_WRITING_ENABLED = "sorted_writing_enabled";
    public static final String SORTED_WRITE_TO_TEMP_PATH_ENABLED = "sorted_write_to_temp_path_enabled";
    public static final String SORTED_WRITE_TEMP_PATH_SUBDIRECTORY_COUNT = "sorted_write_temp_path_subdirectory_count";
    private static final String STATISTICS_ENABLED = "statistics_enabled";
    private static final String PARTITION_STATISTICS_SAMPLE_SIZE = "partition_statistics_sample_size";
    private static final String IGNORE_CORRUPTED_STATISTICS = "ignore_corrupted_statistics";
    public static final String COLLECT_COLUMN_STATISTICS_ON_WRITE = "collect_column_statistics_on_write";
    private static final String OPTIMIZE_MISMATCHED_BUCKET_COUNT = "optimize_mismatched_bucket_count";
    private static final String S3_SELECT_PUSHDOWN_ENABLED = "s3_select_pushdown_enabled";
    private static final String SHUFFLE_PARTITIONED_COLUMNS_FOR_TABLE_WRITE = "shuffle_partitioned_columns_for_table_write";
    private static final String TEMPORARY_STAGING_DIRECTORY_ENABLED = "temporary_staging_directory_enabled";
    private static final String TEMPORARY_STAGING_DIRECTORY_PATH = "temporary_staging_directory_path";
    private static final String TEMPORARY_TABLE_SCHEMA = "temporary_table_schema";
    private static final String TEMPORARY_TABLE_STORAGE_FORMAT = "temporary_table_storage_format";
    private static final String TEMPORARY_TABLE_COMPRESSION_CODEC = "temporary_table_compression_codec";
    public static final String PUSHDOWN_FILTER_ENABLED = "pushdown_filter_enabled";
    public static final String RANGE_FILTERS_ON_SUBSCRIPTS_ENABLED = "range_filters_on_subscripts_enabled";
    public static final String ADAPTIVE_FILTER_REORDERING_ENABLED = "adaptive_filter_reordering_enabled";
    public static final String VIRTUAL_BUCKET_COUNT = "virtual_bucket_count";
    public static final String MAX_BUCKETS_FOR_GROUPED_EXECUTION = "max_buckets_for_grouped_execution";
    public static final String OFFLINE_DATA_DEBUG_MODE_ENABLED = "offline_data_debug_mode_enabled";
    public static final String FAIL_FAST_ON_INSERT_INTO_IMMUTABLE_PARTITIONS_ENABLED = "fail_fast_on_insert_into_immutable_partitions_enabled";
    public static final String USE_LIST_DIRECTORY_CACHE = "use_list_directory_cache";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public HiveSessionProperties(HiveClientConfig hiveClientConfig, OrcFileWriterConfig orcFileWriterConfig, ParquetFileWriterConfig parquetFileWriterConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)IGNORE_TABLE_BUCKETING, (String)"Ignore table bucketing to enable reading from unbucketed partitions", (Boolean)hiveClientConfig.isIgnoreTableBucketing(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)BUCKET_EXECUTION_ENABLED, (String)"Enable bucket-aware execution: only use a single worker per bucket", (Boolean)hiveClientConfig.isBucketExecutionEnabled(), (boolean)false), (Object)new PropertyMetadata(NODE_SELECTION_STRATEGY, "Node affinity selection strategy", (Type)VarcharType.VARCHAR, NodeSelectionStrategy.class, (Object)hiveClientConfig.getNodeSelectionStrategy(), false, value -> NodeSelectionStrategy.valueOf((String)((String)value)), Enum::toString), (Object)new PropertyMetadata(INSERT_EXISTING_PARTITIONS_BEHAVIOR, "Behavior on insert existing partitions; this session property doesn't control behavior on insert existing unpartitioned table", (Type)VarcharType.VARCHAR, InsertExistingPartitionsBehavior.class, (Object)HiveSessionProperties.getDefaultInsertExistingPartitionsBehavior(hiveClientConfig), false, value -> InsertExistingPartitionsBehavior.valueOf((String)value, hiveClientConfig.isImmutablePartitions()), Enum::toString), (Object)PropertyMetadata.booleanProperty((String)ORC_BLOOM_FILTERS_ENABLED, (String)"ORC: Enable bloom filters for predicate pushdown", (Boolean)hiveClientConfig.isOrcBloomFiltersEnabled(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_MERGE_DISTANCE, "ORC: Maximum size of gap between two reads to merge into a single read", hiveClientConfig.getOrcMaxMergeDistance(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_BUFFER_SIZE, "ORC: Maximum size of a single read", hiveClientConfig.getOrcMaxBufferSize(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_STREAM_BUFFER_SIZE, "ORC: Size of buffer for streaming reads", hiveClientConfig.getOrcStreamBufferSize(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_TINY_STRIPE_THRESHOLD, "ORC: Threshold below which an ORC stripe or file will read in its entirety", hiveClientConfig.getOrcTinyStripeThreshold(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_READ_BLOCK_SIZE, "ORC: Soft max size of Presto blocks produced by ORC reader", hiveClientConfig.getOrcMaxReadBlockSize(), false), (Object)PropertyMetadata.booleanProperty((String)ORC_LAZY_READ_SMALL_RANGES, (String)"Experimental: ORC: Read small file segments lazily", (Boolean)hiveClientConfig.isOrcLazyReadSmallRanges(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(ORC_STRING_STATISTICS_LIMIT, "ORC: Maximum size of string statistics; drop if exceeding", orcFileWriterConfig.getStringStatisticsLimit(), false), (Object[])new PropertyMetadata[]{PropertyMetadata.booleanProperty((String)ORC_OPTIMIZED_WRITER_ENABLED, (String)"Experimental: ORC: Enable optimized writer", (Boolean)hiveClientConfig.isOrcOptimizedWriterEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: ORC: Force all validation for files", (Boolean)(hiveClientConfig.getOrcWriterValidationPercentage() > 0.0 ? 1 : 0), (boolean)false), new PropertyMetadata(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, "Experimental: ORC: sample percentage for validation for files", (Type)DoubleType.DOUBLE, Double.class, (Object)hiveClientConfig.getOrcWriterValidationPercentage(), false, value -> {
            double doubleValue = ((Number)value).doubleValue();
            if (doubleValue < 0.0 || doubleValue > 100.0) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 0.0 and 100.0 inclusive: %s", ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, doubleValue));
            }
            return doubleValue;
        }, value -> value), PropertyMetadata.stringProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE_MODE, (String)"Experimental: ORC: Level of detail in ORC validation", (String)hiveClientConfig.getOrcWriterValidationMode().toString(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, "Experimental: ORC: Min stripe size", orcFileWriterConfig.getStripeMinSize(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, "Experimental: ORC: Max stripe size", orcFileWriterConfig.getStripeMaxSize(), false), PropertyMetadata.integerProperty((String)ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, (String)"Experimental: ORC: Max stripe row count", (Integer)orcFileWriterConfig.getStripeMaxRowCount(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, "Experimental: ORC: Max dictionary memory", orcFileWriterConfig.getDictionaryMaxMemory(), false), HiveSessionProperties.dataSizeSessionProperty(PAGEFILE_WRITER_MAX_STRIPE_SIZE, "PAGEFILE: Max stripe size", hiveClientConfig.getPageFileStripeMaxSize(), false), PropertyMetadata.stringProperty((String)HIVE_STORAGE_FORMAT, (String)"Default storage format for new tables or partitions", (String)hiveClientConfig.getHiveStorageFormat().toString(), (boolean)false), new PropertyMetadata(COMPRESSION_CODEC, "The compression codec to use when writing files", (Type)VarcharType.VARCHAR, HiveCompressionCodec.class, (Object)hiveClientConfig.getCompressionCodec(), false, value -> HiveCompressionCodec.valueOf(((String)value).toUpperCase()), Enum::name), new PropertyMetadata(ORC_COMPRESSION_CODEC, "The preferred compression codec to use when writing ORC and DWRF files", (Type)VarcharType.VARCHAR, HiveCompressionCodec.class, (Object)hiveClientConfig.getOrcCompressionCodec(), false, value -> HiveCompressionCodec.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)RESPECT_TABLE_FORMAT, (String)"Write new partitions using table format rather than default storage format", (Boolean)hiveClientConfig.isRespectTableFormat(), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_USE_COLUMN_NAME, (String)"Experimental: Parquet: Access Parquet columns using names from the file", (Boolean)hiveClientConfig.isUseParquetColumnNames(), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_FAIL_WITH_CORRUPTED_STATISTICS, (String)"Parquet: Fail when scanning Parquet files with corrupted statistics", (Boolean)hiveClientConfig.isFailOnCorruptedParquetStatistics(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(PARQUET_MAX_READ_BLOCK_SIZE, "Parquet: Maximum size of a block to read", hiveClientConfig.getParquetMaxReadBlockSize(), false), HiveSessionProperties.dataSizeSessionProperty(PARQUET_WRITER_BLOCK_SIZE, "Parquet: Writer block size", parquetFileWriterConfig.getBlockSize(), false), HiveSessionProperties.dataSizeSessionProperty(PARQUET_WRITER_PAGE_SIZE, "Parquet: Writer page size", parquetFileWriterConfig.getPageSize(), false), HiveSessionProperties.dataSizeSessionProperty(MAX_SPLIT_SIZE, "Max split size", hiveClientConfig.getMaxSplitSize(), true), HiveSessionProperties.dataSizeSessionProperty(MAX_INITIAL_SPLIT_SIZE, "Max initial split size", hiveClientConfig.getMaxInitialSplitSize(), true), PropertyMetadata.booleanProperty((String)RCFILE_OPTIMIZED_WRITER_ENABLED, (String)"Experimental: RCFile: Enable optimized writer", (Boolean)hiveClientConfig.isRcfileOptimizedWriterEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)RCFILE_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: RCFile: Validate writer files", (Boolean)hiveClientConfig.isRcfileWriterValidate(), (boolean)false), PropertyMetadata.booleanProperty((String)SORTED_WRITING_ENABLED, (String)"Enable writing to bucketed sorted tables", (Boolean)hiveClientConfig.isSortedWritingEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SORTED_WRITE_TO_TEMP_PATH_ENABLED, (String)"Enable writing temp files to temp path when writing to bucketed sorted tables", (Boolean)hiveClientConfig.isSortedWriteToTempPathEnabled(), (boolean)false), PropertyMetadata.integerProperty((String)SORTED_WRITE_TEMP_PATH_SUBDIRECTORY_COUNT, (String)"Number of directories per partition for temp files generated by writing sorted table", (Integer)hiveClientConfig.getSortedWriteTempPathSubdirectoryCount(), (boolean)false), PropertyMetadata.booleanProperty((String)STATISTICS_ENABLED, (String)"Experimental: Expose table statistics", (Boolean)hiveClientConfig.isTableStatisticsEnabled(), (boolean)false), PropertyMetadata.integerProperty((String)PARTITION_STATISTICS_SAMPLE_SIZE, (String)"Maximum sample size of the partitions column statistics", (Integer)hiveClientConfig.getPartitionStatisticsSampleSize(), (boolean)false), PropertyMetadata.booleanProperty((String)IGNORE_CORRUPTED_STATISTICS, (String)"Experimental: Ignore corrupted statistics rather than failing", (Boolean)hiveClientConfig.isIgnoreCorruptedStatistics(), (boolean)false), PropertyMetadata.booleanProperty((String)COLLECT_COLUMN_STATISTICS_ON_WRITE, (String)"Experimental: Enables automatic column level statistics collection on write", (Boolean)hiveClientConfig.isCollectColumnStatisticsOnWrite(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_MISMATCHED_BUCKET_COUNT, (String)"Experimental: Enable optimization to avoid shuffle when bucket count is compatible but not the same", (Boolean)hiveClientConfig.isOptimizeMismatchedBucketCount(), (boolean)false), PropertyMetadata.booleanProperty((String)S3_SELECT_PUSHDOWN_ENABLED, (String)"S3 Select pushdown enabled", (Boolean)hiveClientConfig.isS3SelectPushdownEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)TEMPORARY_STAGING_DIRECTORY_ENABLED, (String)"Should use temporary staging directory for write operations", (Boolean)hiveClientConfig.isTemporaryStagingDirectoryEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)TEMPORARY_STAGING_DIRECTORY_PATH, (String)"Temporary staging directory location", (String)hiveClientConfig.getTemporaryStagingDirectoryPath(), (boolean)false), PropertyMetadata.stringProperty((String)TEMPORARY_TABLE_SCHEMA, (String)"Schema where to create temporary tables", (String)hiveClientConfig.getTemporaryTableSchema(), (boolean)false), new PropertyMetadata(TEMPORARY_TABLE_STORAGE_FORMAT, "Storage format used to store data in temporary tables", (Type)VarcharType.VARCHAR, HiveStorageFormat.class, (Object)hiveClientConfig.getTemporaryTableStorageFormat(), false, value -> HiveStorageFormat.valueOf((String)((String)value).toUpperCase()), Enum::name), new PropertyMetadata(TEMPORARY_TABLE_COMPRESSION_CODEC, "Compression codec used to store data in temporary tables", (Type)VarcharType.VARCHAR, HiveCompressionCodec.class, (Object)hiveClientConfig.getTemporaryTableCompressionCodec(), false, value -> HiveCompressionCodec.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)PUSHDOWN_FILTER_ENABLED, (String)"Experimental: enable complex filter pushdown", (Boolean)hiveClientConfig.isPushdownFilterEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)RANGE_FILTERS_ON_SUBSCRIPTS_ENABLED, (String)"Experimental: enable pushdown of range filters on subscripts (a[2] = 5) into ORC column readers", (Boolean)hiveClientConfig.isRangeFiltersOnSubscriptsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ADAPTIVE_FILTER_REORDERING_ENABLED, (String)"Experimental: enable adaptive filter reordering", (Boolean)hiveClientConfig.isAdaptiveFilterReorderingEnabled(), (boolean)false), PropertyMetadata.integerProperty((String)VIRTUAL_BUCKET_COUNT, (String)"Number of virtual bucket assigned for unbucketed tables", (Integer)0, (boolean)false), PropertyMetadata.integerProperty((String)MAX_BUCKETS_FOR_GROUPED_EXECUTION, (String)"maximum total buckets to allow using grouped execution", (Integer)hiveClientConfig.getMaxBucketsForGroupedExecution(), (boolean)false), PropertyMetadata.booleanProperty((String)OFFLINE_DATA_DEBUG_MODE_ENABLED, (String)"allow reading from tables or partitions that are marked as offline or not readable", (Boolean)false, (boolean)true), PropertyMetadata.booleanProperty((String)ORC_ZSTD_JNI_DECOMPRESSION_ENABLED, (String)"use JNI based zstd decompression for reading ORC files", (Boolean)hiveClientConfig.isZstdJniDecompressionEnabled(), (boolean)true), PropertyMetadata.booleanProperty((String)SHUFFLE_PARTITIONED_COLUMNS_FOR_TABLE_WRITE, (String)"Shuffle the data on partitioned columns", (Boolean)false, (boolean)false), PropertyMetadata.booleanProperty((String)FAIL_FAST_ON_INSERT_INTO_IMMUTABLE_PARTITIONS_ENABLED, (String)"Fail fast when trying to insert into an immutable partition. Increases load on the metastore", (Boolean)hiveClientConfig.isFailFastOnInsertIntoImmutablePartitionsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_LIST_DIRECTORY_CACHE, (String)"Use list directory cache if available when set to true", (Boolean)(!hiveClientConfig.getFileStatusCacheTables().isEmpty() ? 1 : 0), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isBucketExecutionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(BUCKET_EXECUTION_ENABLED, Boolean.class);
    }

    public static boolean shouldIgnoreTableBucketing(ConnectorSession session) {
        return (Boolean)session.getProperty(IGNORE_TABLE_BUCKETING, Boolean.class);
    }

    public static int getMaxBucketsForGroupedExecution(ConnectorSession session) {
        return (Integer)session.getProperty(MAX_BUCKETS_FOR_GROUPED_EXECUTION, Integer.class);
    }

    public static NodeSelectionStrategy getNodeSelectionStrategy(ConnectorSession session) {
        return (NodeSelectionStrategy)session.getProperty(NODE_SELECTION_STRATEGY, NodeSelectionStrategy.class);
    }

    public static InsertExistingPartitionsBehavior getInsertExistingPartitionsBehavior(ConnectorSession session) {
        return (InsertExistingPartitionsBehavior)((Object)session.getProperty(INSERT_EXISTING_PARTITIONS_BEHAVIOR, InsertExistingPartitionsBehavior.class));
    }

    public static boolean isOrcBloomFiltersEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_ENABLED, Boolean.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcTinyStripeThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_TINY_STRIPE_THRESHOLD, DataSize.class);
    }

    public static DataSize getOrcMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean getOrcLazyReadSmallRanges(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_LAZY_READ_SMALL_RANGES, Boolean.class);
    }

    public static boolean isOrcZstdJniDecompressionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_ZSTD_JNI_DECOMPRESSION_ENABLED, Boolean.class);
    }

    public static DataSize getOrcStringStatisticsLimit(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STRING_STATISTICS_LIMIT, DataSize.class);
    }

    public static boolean isOrcOptimizedWriterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_ENABLED, Boolean.class);
    }

    public static boolean isOrcOptimizedWriterValidate(ConnectorSession session) {
        boolean validate = (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
        double percentage = (Double)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, Double.class);
        Preconditions.checkArgument((percentage >= 0.0 && percentage <= 100.0 ? 1 : 0) != 0);
        if (!validate) {
            return false;
        }
        return ThreadLocalRandom.current().nextDouble(100.0) < percentage;
    }

    public static OrcWriteValidation.OrcWriteValidationMode getOrcOptimizedWriterValidateMode(ConnectorSession session) {
        return OrcWriteValidation.OrcWriteValidationMode.valueOf((String)((String)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_MODE, String.class)).toUpperCase(Locale.ENGLISH));
    }

    public static DataSize getOrcOptimizedWriterMinStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, DataSize.class);
    }

    public static DataSize getOrcOptimizedWriterMaxStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, DataSize.class);
    }

    public static int getOrcOptimizedWriterMaxStripeRows(ConnectorSession session) {
        return (Integer)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, Integer.class);
    }

    public static DataSize getOrcOptimizedWriterMaxDictionaryMemory(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, DataSize.class);
    }

    public static DataSize getPageFileStripeMaxSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PAGEFILE_WRITER_MAX_STRIPE_SIZE, DataSize.class);
    }

    public static HiveStorageFormat getHiveStorageFormat(ConnectorSession session) {
        return HiveStorageFormat.valueOf((String)((String)session.getProperty(HIVE_STORAGE_FORMAT, String.class)).toUpperCase(Locale.ENGLISH));
    }

    public static HiveCompressionCodec getCompressionCodec(ConnectorSession session) {
        return (HiveCompressionCodec)((Object)session.getProperty(COMPRESSION_CODEC, HiveCompressionCodec.class));
    }

    public static HiveCompressionCodec getOrcCompressionCodec(ConnectorSession session) {
        return (HiveCompressionCodec)((Object)session.getProperty(ORC_COMPRESSION_CODEC, HiveCompressionCodec.class));
    }

    public static boolean isRespectTableFormat(ConnectorSession session) {
        return (Boolean)session.getProperty(RESPECT_TABLE_FORMAT, Boolean.class);
    }

    public static boolean isUseParquetColumnNames(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_USE_COLUMN_NAME, Boolean.class);
    }

    public static boolean isFailOnCorruptedParquetStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_FAIL_WITH_CORRUPTED_STATISTICS, Boolean.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_BLOCK_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterPageSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_PAGE_SIZE, DataSize.class);
    }

    public static DataSize getMaxSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_SPLIT_SIZE, DataSize.class);
    }

    public static DataSize getMaxInitialSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_INITIAL_SPLIT_SIZE, DataSize.class);
    }

    public static boolean isRcfileOptimizedWriterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(RCFILE_OPTIMIZED_WRITER_ENABLED, Boolean.class);
    }

    public static boolean isRcfileOptimizedWriterValidate(ConnectorSession session) {
        return (Boolean)session.getProperty(RCFILE_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
    }

    public static boolean isSortedWritingEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SORTED_WRITING_ENABLED, Boolean.class);
    }

    public static boolean isSortedWriteToTempPathEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SORTED_WRITE_TO_TEMP_PATH_ENABLED, Boolean.class);
    }

    public static int getSortedWriteTempPathSubdirectoryCount(ConnectorSession session) {
        return (Integer)session.getProperty(SORTED_WRITE_TEMP_PATH_SUBDIRECTORY_COUNT, Integer.class);
    }

    public static boolean isS3SelectPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(S3_SELECT_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(STATISTICS_ENABLED, Boolean.class);
    }

    public static int getPartitionStatisticsSampleSize(ConnectorSession session) {
        int size = (Integer)session.getProperty(PARTITION_STATISTICS_SAMPLE_SIZE, Integer.class);
        if (size < 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than 0: %s", PARTITION_STATISTICS_SAMPLE_SIZE, size));
        }
        return size;
    }

    public static boolean isIgnoreCorruptedStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(IGNORE_CORRUPTED_STATISTICS, Boolean.class);
    }

    public static boolean isCollectColumnStatisticsOnWrite(ConnectorSession session) {
        return (Boolean)session.getProperty(COLLECT_COLUMN_STATISTICS_ON_WRITE, Boolean.class);
    }

    @Deprecated
    public static boolean isOptimizedMismatchedBucketCount(ConnectorSession session) {
        return (Boolean)session.getProperty(OPTIMIZE_MISMATCHED_BUCKET_COUNT, Boolean.class);
    }

    public static boolean isTemporaryStagingDirectoryEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(TEMPORARY_STAGING_DIRECTORY_ENABLED, Boolean.class);
    }

    public static String getTemporaryStagingDirectoryPath(ConnectorSession session) {
        return (String)session.getProperty(TEMPORARY_STAGING_DIRECTORY_PATH, String.class);
    }

    public static String getTemporaryTableSchema(ConnectorSession session) {
        return (String)session.getProperty(TEMPORARY_TABLE_SCHEMA, String.class);
    }

    public static HiveStorageFormat getTemporaryTableStorageFormat(ConnectorSession session) {
        return (HiveStorageFormat)session.getProperty(TEMPORARY_TABLE_STORAGE_FORMAT, HiveStorageFormat.class);
    }

    public static HiveCompressionCodec getTemporaryTableCompressionCodec(ConnectorSession session) {
        return (HiveCompressionCodec)((Object)session.getProperty(TEMPORARY_TABLE_COMPRESSION_CODEC, HiveCompressionCodec.class));
    }

    public static boolean isPushdownFilterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PUSHDOWN_FILTER_ENABLED, Boolean.class);
    }

    public static boolean isRangeFiltersOnSubscriptsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(RANGE_FILTERS_ON_SUBSCRIPTS_ENABLED, Boolean.class);
    }

    public static boolean isAdaptiveFilterReorderingEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ADAPTIVE_FILTER_REORDERING_ENABLED, Boolean.class);
    }

    public static int getVirtualBucketCount(ConnectorSession session) {
        int virtualBucketCount = (Integer)session.getProperty(VIRTUAL_BUCKET_COUNT, Integer.class);
        if (virtualBucketCount < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must not be negative: %s", VIRTUAL_BUCKET_COUNT, virtualBucketCount));
        }
        return virtualBucketCount;
    }

    public static boolean isOfflineDataDebugModeEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(OFFLINE_DATA_DEBUG_MODE_ENABLED, Boolean.class);
    }

    public static boolean isShufflePartitionedColumnsForTableWriteEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SHUFFLE_PARTITIONED_COLUMNS_FOR_TABLE_WRITE, Boolean.class);
    }

    public static PropertyMetadata<DataSize> dataSizeSessionProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.createUnboundedVarcharType(), DataSize.class, (Object)defaultValue, hidden, value -> DataSize.valueOf((String)((String)value)), DataSize::toString);
    }

    private static InsertExistingPartitionsBehavior getDefaultInsertExistingPartitionsBehavior(HiveClientConfig hiveClientConfig) {
        if (!hiveClientConfig.isImmutablePartitions()) {
            return InsertExistingPartitionsBehavior.APPEND;
        }
        return hiveClientConfig.isInsertOverwriteImmutablePartitionEnabled() ? InsertExistingPartitionsBehavior.OVERWRITE : InsertExistingPartitionsBehavior.ERROR;
    }

    public static boolean isFailFastOnInsertIntoImmutablePartitionsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(FAIL_FAST_ON_INSERT_INTO_IMMUTABLE_PARTITIONS_ENABLED, Boolean.class);
    }

    public static boolean isUseListDirectoryCache(ConnectorSession session) {
        return (Boolean)session.getProperty(USE_LIST_DIRECTORY_CACHE, Boolean.class);
    }

    public static enum InsertExistingPartitionsBehavior {
        ERROR,
        APPEND,
        OVERWRITE;


        public static InsertExistingPartitionsBehavior valueOf(String value, boolean immutablePartition) {
            InsertExistingPartitionsBehavior enumValue = InsertExistingPartitionsBehavior.valueOf(value.toUpperCase(Locale.ENGLISH));
            if (immutablePartition) {
                Preconditions.checkArgument((enumValue != APPEND ? 1 : 0) != 0, (Object)String.format("Presto is configured to treat Hive partitions as immutable. %s is not allowed to be set to %s", new Object[]{HiveSessionProperties.INSERT_EXISTING_PARTITIONS_BEHAVIOR, APPEND}));
            }
            return enumValue;
        }
    }
}

